Summary: Module utilities and kerneld
Name: modutils
Version: 2.3.5
Release: 1
Copyright: GPL
Group: Utilities/System
Source: modutils-2.3.5.tar.gz
Source1: kerneld.init
ExclusiveOS: Linux
BuildRoot: /tmp/modutils

%description
The Linux kernel allows new kernel pieces to be loaded and old ones to
be unloaded while the kernel continues to run. These loadable pieces
are called modules, and can include device drivers and filesystems among
other things. This package includes program to load and unload programs
both automatically and manually.

This set does not include 'request-route' script (still present in
sources).

%prep
%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr
make dep all
# make -C insmod insmod.static

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/{usr/man/man{2,5,8},sbin}
make install prefix=$RPM_BUILD_ROOT/usr exec_prefix=$RPM_BUILD_ROOT
(cd kerneld; 
make install-scripts prefix=$RPM_BUILD_ROOT/usr exec_prefix=$RPM_BUILD_ROOT
)
# security hole, works poorly anyway
rm -f $RPM_BUILD_ROOT/sbin/request-route
# for f in depmod genksyms insmod insmod.static kerneld ksyms lsmod modinfo ;
for f in depmod genksyms insmod kerneld ksyms lsmod modinfo ; \
do strip $RPM_BUILD_ROOT/sbin/$f || : ; done
install -m 755 $RPM_SOURCE_DIR/kerneld.init $RPM_BUILD_ROOT/etc/rc.d/init.d/kerneld

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add kerneld

%postun
if [ $1 = 0 ]; then
    /sbin/chkconfig --del kerneld
fi

%files
%defattr(-,root,root)
%attr(755,root,root)/sbin/depmod
%attr(755,root,root)/sbin/genksyms
%attr(755,root,root)/sbin/insmod
#%attr(755,root,root)/sbin/insmod.static
%attr(755,root,root)/sbin/kerneld
%attr(755,root,root)/sbin/ksyms
%attr(755,root,root)/sbin/lsmod
%attr(755,root,root)/sbin/modinfo
%attr(755,root,root)/sbin/modprobe
%attr(755,root,root)/sbin/rmmod
%attr(755,root,root)/sbin/insmod_ksymoops_clean
%attr(755,root,root)/sbin/kernelversion
# %attr(755,root,root)/sbin/rmmod.static
%attr(644,root,root)/usr/man/man2/create_module.2
%attr(644,root,root)/usr/man/man2/delete_module.2
%attr(644,root,root)/usr/man/man2/get_kernel_syms.2
%attr(644,root,root)/usr/man/man2/init_module.2
%attr(644,root,root)/usr/man/man2/query_module.2
%attr(644,root,root)/usr/man/man5/modules.conf.5
%attr(644,root,root)/usr/man/man8/depmod.8
%attr(644,root,root)/usr/man/man8/genksyms.8
%attr(644,root,root)/usr/man/man8/insmod.8
%attr(644,root,root)/usr/man/man8/kerneld.8
%attr(644,root,root)/usr/man/man8/ksyms.8
%attr(644,root,root)/usr/man/man8/lsmod.8
%attr(644,root,root)/usr/man/man8/modinfo.8
%attr(644,root,root)/usr/man/man8/modprobe.8
%attr(644,root,root)/usr/man/man8/rmmod.8
%attr(755,root,root) %config /etc/rc.d/init.d/kerneld
%attr(-,root,root) %doc COPYING README CREDITS TODO ChangeLog NEWS

