/*
 * Handle module symbols
 *
 * Copyright 1994, 1995, 1996, 1997 Jacques Gelinas <jack@solucorp.qc.ca>
 * Additional modifications: Bjrn Ekwall <bj0rn@blox.se> February, March 1999
 *
 * This file is part of the Linux modutils.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include "depmod.h"
extern "C" {
#include "util.h"
};

#define ALLOC_SYM	10000	/* Number of symbols allocated per chunk */
/*
 *	List of symbols
 *	For each symbol, save the name or the originating module
 */
SYMBOLS::SYMBOLS()
{
	sym.cur = NULL;
	memset(hash, 0, sizeof(hash));
	allocsym();
}

/*
 *	Allocate a new buffer for the collection of symbols
 */
void SYMBOLS::allocsym()
{
	LIST_SYMBOL *list = (LIST_SYMBOL*)xmalloc(sizeof(LIST_SYMBOL) +
						  ALLOC_SYM * sizeof(SYMBOL));
	list->next = sym.cur;
	sym.cur = list;
	sym.nb  = 0;
	sym.ptacc = list->alloc;
	sym.lastacc = list->alloc+ALLOC_SYM;
}

/*
 *	Add a global symbol, defined or undefined.
 *	Return the new symbol
 */
SYMBOL *SYMBOLS::add (
	const char *name,	/* Symbol name */
	MODULE *module,		/* Module that has this symbol */
	SYM_STATUS status)
{
	/* Search for the name */
	unsigned short hashval = 0;
	const char *pt = name;

	for (pt = name; *pt; ++pt)
		hashval = (hashval << 1) + *pt;
	hashval %= 2048;

	SYMBOL **ffind = hash + hashval;
	SYMBOL *added;

	/* Add to the list */
	if (sym.ptacc == sym.lastacc)
		allocsym();
	added = sym.ptacc++;
	sym.nb++;

	added->name = xstrdup(name);
	added->next = *ffind;
	*ffind = added;
	added->hashval = hashval;
	if (status == SYM_NEED) {
		added->defined = 0;
		added->module = NULL;
	} else {
		added->defined = 1;
		added->module = module;
	}

	return added;
}

void SYMBOLS::resolve (SYMBOL *sym)
{
	/*
	 * This is a defined symbol.
	 * Find all undefined references to it.
	 */
	SYMBOL **ffind = hash + sym->hashval;
	SYMBOL *find;

	for (find = *ffind; find; find = find->next) {
		if (strcmp(find->name, sym->name) == 0) {
			if (find->module == NULL)
				find->module = sym->module;
			else if (find != sym)
				break; /* Someone else beat us to it */
		}
	}
}
