#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "include/syscallmgr.h"
#include "audit.h"
#include "log.h"

static struct audit *head=NULL;
static struct audit *tail=NULL;
static char *buf1=NULL;
static char *buf2=NULL;
static int cnt1=0;
static int cnt2=0;

#define BUFSIZE 1024

/*void readdata */


int add_entry(struct audit *kuku) {

	static struct audit *ptr;
	
	ptr=(struct audit *)malloc(sizeof(struct audit));
	memcpy(ptr,kuku,sizeof(struct audit));
	
	ptr->next=NULL;
	ptr->prev=head;
	if (head!=NULL) {
		head->next=ptr;
	} 
	
	if (tail==NULL) {
		tail=ptr;
	}
	
	head=ptr;
	return(0);
}


struct audit *get_entry(int number) {
	static struct audit *temp;
	int i=0;

	for (temp=tail;temp!=NULL;temp=temp->next) {
		if (++i==number) return(temp);
	}
	return(NULL);
}

int del_entry(int id) /*(struct audit *koko)*/ {
	struct audit *koko;
	
	if ((koko=get_entry(id))==NULL) {
		printf("Delete: Entry %d does not exist\n",id);
		return(1);
	}
	
	if (koko->prev!=NULL) {
		koko->prev->next=koko->next;
	} else {
		tail=koko->next;
	}
	
	if (koko->next!=NULL) {
		koko->next->prev=koko->prev;
	} else {
		head=koko->prev;
	}
	
	free(koko);
	printf("Delete: Entry %d deleted\n",id);
	return(0);
}

#define STAR    0
#define NOTSTAR 1
#define RESET   2

int strmask(char *str, char *mask)
/*
    Tests string 'str' against mask string 'mask'
    Returns TRUE if the string matches the mask.

    The mask can contain '?' and '*' wild card characters.
    '?' matches any single character.
    '*' matches any number of any characters.

    For example:
                    strmask("Hello", "Hello");  ---> TRUE
                    strmask("Hello", "Jello");  ---> FALSE
                    strmask("Hello", "H*o");    ---> TRUE
                    strmask("Hello", "H*g");    ---> FALSE
                    strmask("Hello", "?ello");  ---> TRUE
                    strmask("Hello", "H????");  ---> TRUE
                    strmask("H", "H????");      ---> FALSE
*/
{
    char *sp, *mp, *reset_string, *reset_mask, *sn;
    int state;

    sp = str;
    mp = mask;

    while (1) {
        switch (*mp) {
        case '\0':
            return(*sp ? 0:1);
        case '?':
            sp++;
            mp++;
            break;
        default:
            if (*mp == *sp) {
                sp++;
                mp++;
                break;
            }
            else {
                return(0);
            }
        case '*':
            if (*(mp + 1) == '\0') {
                return(1);
            }
            if ((sn = strchr(sp, *(mp + 1))) == NULL) {
                return(0);
            }

            /* save place -- match rest of string */
            /* if fail, reset to here */
            reset_mask = mp;
            reset_string = sn + 1;

            mp = mp + 2;
            sp = sn + 1;
            state = NOTSTAR;
            while (state == NOTSTAR) {
                switch (*mp) {
                case '\0':
                    if (*sp == '\0') {
                        return(0);
                    }
                    else {
                        state = RESET;
                    }
                    break;
                case '?':
                    sp++;
                    mp++;
                    break;
                default:
                    if (*mp == *sp) {
                        sp++;
                        mp++;
                    }
                    else {
                        state = RESET;
                    }
                    break;
                case '*':
                    state = STAR;
                    break;
                }
            }
            /* we've reach a new star or should reset to last star */
            if (state == RESET) {
                sp = reset_string;
                mp = reset_mask;
            }
            break;
        }
    }
}

int matchit(char *cmd,int gid,int uid,int ttymaj,int ttymin,char class) {

	struct audit *temp;
	
	int i=0;

	for (temp=tail;temp!=NULL;temp=temp->next) {
		if (((temp->alluids==1) || (temp->uid==uid)) &&
	 	    ((temp->allgids==1) || (temp->gid==gid)) &&
	 	    ((temp->class=='*') || (temp->class==class)) &&
	 	    ((temp->allttymin==1) || (temp->ttymin==ttymin)) && 
	 	    ((temp->allttymaj==1) || (temp->ttymaj==ttymaj)) &&
		    (strmask(cmd,temp->cmd))) {
		    		i |=temp->action;
		}
	}
	return(i);
}

void process_log(char *s) {
	int pid,uid,gid,maj,min;
	
	printf("%s\n",s);
}

void process_command(char *s) {
	int pid,uid,gid,maj,min;
	char cmd[100];
	sscanf(s,"%s\n",&cmd);
	if (strncasecmp(cmd,"ADD",3)) { 
	/* koko */
	} else if (strncasecmp(cmd,"DEL",d)) {
	/* koko */
	} else if (strncasecmp(cmd,"DEL",d)) {
	/* koko */
	}
}
	
	
	

void process(char *s,int i,void (*func)(char *),char *ko,int j) {
	int k;
/*	static int j=0;
	static char *ko=NULL;*/
	
	if ((ko=realloc(ko,j+i+1))==NULL) {
		printf("realloc() returns NULL\n");
		exit(1);
	} 
	
	k=0;
	while (k<i) {
		if ((ko[j++]=s[k++])=='\n') {
			ko[--j]='\0';
			(func)(ko);
			j=0;
		}
	}
	return;

}

void main (int argc,char *argv[]) {
	int i,j,f,p;
	fd_set fds;
	char buf[BUFSIZE];
	
	if ((f=open("/proc/audit",O_RDONLY|O_NONBLOCK|O_NDELAY))==-1) {
		perror("open(/proc/audit)");
		exit(1);
	}
	
	if ((mknod("/tmp/audit-commands",S_IREAD|S_IWRITE|S_IFIFO,0))==-1) {
		perror("mknod(/tmp/audit-commands)");
		exit(1);
	}
	
	if ((p=open("/tmp/audit-commands",O_RDWR|O_NONBLOCK|O_NDELAY))==-1) {
		perror("open(/tmp/audit-commands)");
		exit(1);
	}
	
	while (1) {
		FD_ZERO(&fds);
		FD_SET(p,&fds);
		FD_SET(f,&fds);
		if (select(p+1,&fds,NULL,NULL,NULL)==-1) {
			perror("select()");
			exit(-1);
		} else {
			if (FD_ISSET(f,&fds)) {
				if ((i=read(f,buf,BUFSIZE))>0) {
					process(buf,i,process_log,buf1,cnt1);
				}
			}
			if (FD_ISSET(p,&fds)) {
				if ((i=read(p,buf,BUFSIZE))>0) {
					process(buf,i,process_command,buf2,cnt2);
				}
			}
		}
	}
}
				
				
				
		
	
	
	
	
