/*
 * SMU_7_0_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_7_0_0_D_H
#define SMU_7_0_0_D_H

#define mmGCK_SMC_IND_INDEX                                                     0x80
#define mmGCK0_GCK_SMC_IND_INDEX                                                0x80
#define mmGCK1_GCK_SMC_IND_INDEX                                                0x82
#define mmGCK2_GCK_SMC_IND_INDEX                                                0x84
#define mmGCK3_GCK_SMC_IND_INDEX                                                0x86
#define mmGCK_SMC_IND_DATA                                                      0x81
#define mmGCK0_GCK_SMC_IND_DATA                                                 0x81
#define mmGCK1_GCK_SMC_IND_DATA                                                 0x83
#define mmGCK2_GCK_SMC_IND_DATA                                                 0x85
#define mmGCK3_GCK_SMC_IND_DATA                                                 0x87
#define ixCG_DCLK_CNTL                                                          0xc050009c
#define ixCG_DCLK_STATUS                                                        0xc05000a0
#define ixCG_VCLK_CNTL                                                          0xc05000a4
#define ixCG_VCLK_STATUS                                                        0xc05000a8
#define ixCG_ECLK_CNTL                                                          0xc05000ac
#define ixCG_ECLK_STATUS                                                        0xc05000b0
#define ixCG_ACLK_CNTL                                                          0xc05000dc
#define ixGCK_DFS_BYPASS_CNTL                                                   0xc0500118
#define ixCG_SPLL_FUNC_CNTL                                                     0xc0500140
#define ixCG_SPLL_FUNC_CNTL_2                                                   0xc0500144
#define ixCG_SPLL_FUNC_CNTL_3                                                   0xc0500148
#define ixCG_SPLL_FUNC_CNTL_4                                                   0xc050014c
#define ixCG_SPLL_FUNC_CNTL_5                                                   0xc0500150
#define ixCG_SPLL_FUNC_CNTL_6                                                   0xc0500154
#define ixCG_SPLL_FUNC_CNTL_7                                                   0xc0500158
#define ixSPLL_CNTL_MODE                                                        0xc0500160
#define ixCG_SPLL_SPREAD_SPECTRUM                                               0xc0500164
#define ixCG_SPLL_SPREAD_SPECTRUM_2                                             0xc0500168
#define ixMPLL_BYPASSCLK_SEL                                                    0xc050019c
#define ixCG_CLKPIN_CNTL                                                        0xc05001a0
#define ixCG_CLKPIN_CNTL_2                                                      0xc05001a4
#define ixTHM_CLK_CNTL                                                          0xc05001a8
#define ixMISC_CLK_CTRL                                                         0xc05001ac
#define ixGCK_PLL_TEST_CNTL                                                     0xc05001c0
#define ixGCK_PLL_TEST_CNTL_2                                                   0xc05001c4
#define ixGCK_ADFS_CLK_BYPASS_CNTL1                                             0xc05001c8
#define mmSMC_IND_INDEX                                                         0x80
#define mmSMC0_SMC_IND_INDEX                                                    0x80
#define mmSMC1_SMC_IND_INDEX                                                    0x82
#define mmSMC2_SMC_IND_INDEX                                                    0x84
#define mmSMC3_SMC_IND_INDEX                                                    0x86
#define mmSMC_IND_DATA                                                          0x81
#define mmSMC0_SMC_IND_DATA                                                     0x81
#define mmSMC1_SMC_IND_DATA                                                     0x83
#define mmSMC2_SMC_IND_DATA                                                     0x85
#define mmSMC3_SMC_IND_DATA                                                     0x87
#define mmSMC_IND_INDEX_0                                                       0x80
#define mmSMC_IND_DATA_0                                                        0x81
#define mmSMC_IND_INDEX_1                                                       0x82
#define mmSMC_IND_DATA_1                                                        0x83
#define mmSMC_IND_INDEX_2                                                       0x84
#define mmSMC_IND_DATA_2                                                        0x85
#define mmSMC_IND_INDEX_3                                                       0x86
#define mmSMC_IND_DATA_3                                                        0x87
#define mmSMC_IND_INDEX_4                                                       0x88
#define mmSMC_IND_DATA_4                                                        0x89
#define mmSMC_IND_INDEX_5                                                       0x8a
#define mmSMC_IND_DATA_5                                                        0x8b
#define mmSMC_IND_INDEX_6                                                       0x8c
#define mmSMC_IND_DATA_6                                                        0x8d
#define mmSMC_IND_INDEX_7                                                       0x8e
#define mmSMC_IND_DATA_7                                                        0x8f
#define mmSMC_IND_ACCESS_CNTL                                                   0x90
#define mmSMC_MESSAGE_0                                                         0x94
#define mmSMC_RESP_0                                                            0x95
#define mmSMC_MESSAGE_1                                                         0x96
#define mmSMC_RESP_1                                                            0x97
#define mmSMC_MESSAGE_2                                                         0x98
#define mmSMC_RESP_2                                                            0x99
#define mmSMC_MESSAGE_3                                                         0x9a
#define mmSMC_RESP_3                                                            0x9b
#define mmSMC_MESSAGE_4                                                         0x9c
#define mmSMC_RESP_4                                                            0x9d
#define mmSMC_MESSAGE_5                                                         0x9e
#define mmSMC_RESP_5                                                            0x9f
#define mmSMC_MESSAGE_6                                                         0xa0
#define mmSMC_RESP_6                                                            0xa1
#define mmSMC_MESSAGE_7                                                         0xa2
#define mmSMC_RESP_7                                                            0xa3
#define mmSMC_MSG_ARG_0                                                         0xa4
#define mmSMC_MSG_ARG_1                                                         0xa5
#define mmSMC_MSG_ARG_2                                                         0xa6
#define mmSMC_MSG_ARG_3                                                         0xa7
#define mmSMC_MSG_ARG_4                                                         0xa8
#define mmSMC_MSG_ARG_5                                                         0xa9
#define mmSMC_MSG_ARG_6                                                         0xaa
#define mmSMC_MSG_ARG_7                                                         0xab
#define mmSMC_MESSAGE_8                                                         0xb5
#define mmSMC_RESP_8                                                            0xb6
#define mmSMC_MESSAGE_9                                                         0xb7
#define mmSMC_RESP_9                                                            0xb8
#define mmSMC_MESSAGE_10                                                        0xb9
#define mmSMC_RESP_10                                                           0xba
#define mmSMC_MESSAGE_11                                                        0xbb
#define mmSMC_RESP_11                                                           0xbc
#define mmSMC_MSG_ARG_8                                                         0xbd
#define mmSMC_MSG_ARG_9                                                         0xbe
#define mmSMC_MSG_ARG_10                                                        0xbf
#define mmSMC_MSG_ARG_11                                                        0x91
#define ixSMC_SYSCON_RESET_CNTL                                                 0x80000000
#define ixSMC_SYSCON_CLOCK_CNTL_0                                               0x80000004
#define ixSMC_SYSCON_CLOCK_CNTL_1                                               0x80000008
#define ixSMC_SYSCON_CLOCK_CNTL_2                                               0x8000000c
#define ixSMC_SYSCON_MISC_CNTL                                                  0x80000010
#define ixSMC_SYSCON_MSG_ARG_0                                                  0x80000068
#define ixSMC_PC_C                                                              0x80000370
#define ixSMC_SCRATCH9                                                          0x80000424
#define mmCG_FPS_CNT                                                            0x1a4
#define mmSMU_SMC_IND_INDEX                                                     0x80
#define mmSMU0_SMU_SMC_IND_INDEX                                                0x80
#define mmSMU1_SMU_SMC_IND_INDEX                                                0x82
#define mmSMU2_SMU_SMC_IND_INDEX                                                0x84
#define mmSMU3_SMU_SMC_IND_INDEX                                                0x86
#define mmSMU_SMC_IND_DATA                                                      0x81
#define mmSMU0_SMU_SMC_IND_DATA                                                 0x81
#define mmSMU1_SMU_SMC_IND_DATA                                                 0x83
#define mmSMU2_SMU_SMC_IND_DATA                                                 0x85
#define mmSMU3_SMU_SMC_IND_DATA                                                 0x87
#define ixRCU_UC_EVENTS                                                         0xc0000004
#define ixRCU_MISC_CTRL                                                         0xc0000010
#define ixCC_RCU_FUSES                                                          0xc00c0000
#define ixCC_SMU_MISC_FUSES                                                     0xc00c0004
#define ixCC_SCLK_VID_FUSES                                                     0xc00c0008
#define ixCC_GIO_IOCCFG_FUSES                                                   0xc00c000c
#define ixCC_GIO_IOC_FUSES                                                      0xc00c0010
#define ixCC_SMU_TST_EFUSE1_MISC                                                0xc00c001c
#define ixCC_TST_ID_STRAPS                                                      0xc00c0020
#define ixCC_FCTRL_FUSES                                                        0xc00c0024
#define ixSMU_MAIN_PLL_OP_FREQ                                                  0xe0003020
#define ixSMU_STATUS                                                            0xe0003088
#define ixSMU_FIRMWARE                                                          0xe00030a4
#define ixSMU_INPUT_DATA                                                        0xe00030b8
#define ixSMU_EFUSE_0                                                           0xc0100000
#define ixDPM_TABLE_1                                                           0x3f000
#define ixDPM_TABLE_2                                                           0x3f004
#define ixDPM_TABLE_3                                                           0x3f008
#define ixDPM_TABLE_4                                                           0x3f00c
#define ixDPM_TABLE_5                                                           0x3f010
#define ixDPM_TABLE_6                                                           0x3f014
#define ixDPM_TABLE_7                                                           0x3f018
#define ixDPM_TABLE_8                                                           0x3f01c
#define ixDPM_TABLE_9                                                           0x3f020
#define ixDPM_TABLE_10                                                          0x3f024
#define ixDPM_TABLE_11                                                          0x3f028
#define ixDPM_TABLE_12                                                          0x3f02c
#define ixDPM_TABLE_13                                                          0x3f030
#define ixDPM_TABLE_14                                                          0x3f034
#define ixDPM_TABLE_15                                                          0x3f038
#define ixDPM_TABLE_16                                                          0x3f03c
#define ixDPM_TABLE_17                                                          0x3f040
#define ixDPM_TABLE_18                                                          0x3f044
#define ixDPM_TABLE_19                                                          0x3f048
#define ixDPM_TABLE_20                                                          0x3f04c
#define ixDPM_TABLE_21                                                          0x3f050
#define ixDPM_TABLE_22                                                          0x3f054
#define ixDPM_TABLE_23                                                          0x3f058
#define ixDPM_TABLE_24                                                          0x3f05c
#define ixDPM_TABLE_25                                                          0x3f060
#define ixDPM_TABLE_26                                                          0x3f064
#define ixDPM_TABLE_27                                                          0x3f068
#define ixDPM_TABLE_28                                                          0x3f06c
#define ixDPM_TABLE_29                                                          0x3f070
#define ixDPM_TABLE_30                                                          0x3f074
#define ixDPM_TABLE_31                                                          0x3f078
#define ixDPM_TABLE_32                                                          0x3f07c
#define ixDPM_TABLE_33                                                          0x3f080
#define ixDPM_TABLE_34                                                          0x3f084
#define ixDPM_TABLE_35                                                          0x3f088
#define ixDPM_TABLE_36                                                          0x3f08c
#define ixDPM_TABLE_37                                                          0x3f090
#define ixDPM_TABLE_38                                                          0x3f094
#define ixDPM_TABLE_39                                                          0x3f098
#define ixDPM_TABLE_40                                                          0x3f09c
#define ixDPM_TABLE_41                                                          0x3f0a0
#define ixDPM_TABLE_42                                                          0x3f0a4
#define ixDPM_TABLE_43                                                          0x3f0a8
#define ixDPM_TABLE_44                                                          0x3f0ac
#define ixDPM_TABLE_45                                                          0x3f0b0
#define ixDPM_TABLE_46                                                          0x3f0b4
#define ixDPM_TABLE_47                                                          0x3f0b8
#define ixDPM_TABLE_48                                                          0x3f0bc
#define ixDPM_TABLE_49                                                          0x3f0c0
#define ixDPM_TABLE_50                                                          0x3f0c4
#define ixDPM_TABLE_51                                                          0x3f0c8
#define ixDPM_TABLE_52                                                          0x3f0cc
#define ixDPM_TABLE_53                                                          0x3f0d0
#define ixDPM_TABLE_54                                                          0x3f0d4
#define ixDPM_TABLE_55                                                          0x3f0d8
#define ixDPM_TABLE_56                                                          0x3f0dc
#define ixDPM_TABLE_57                                                          0x3f0e0
#define ixDPM_TABLE_58                                                          0x3f0e4
#define ixDPM_TABLE_59                                                          0x3f0e8
#define ixDPM_TABLE_60                                                          0x3f0ec
#define ixDPM_TABLE_61                                                          0x3f0f0
#define ixDPM_TABLE_62                                                          0x3f0f4
#define ixDPM_TABLE_63                                                          0x3f0f8
#define ixDPM_TABLE_64                                                          0x3f0fc
#define ixDPM_TABLE_65                                                          0x3f100
#define ixDPM_TABLE_66                                                          0x3f104
#define ixDPM_TABLE_67                                                          0x3f108
#define ixDPM_TABLE_68                                                          0x3f10c
#define ixDPM_TABLE_69                                                          0x3f110
#define ixDPM_TABLE_70                                                          0x3f114
#define ixDPM_TABLE_71                                                          0x3f118
#define ixDPM_TABLE_72                                                          0x3f11c
#define ixDPM_TABLE_73                                                          0x3f120
#define ixDPM_TABLE_74                                                          0x3f124
#define ixDPM_TABLE_75                                                          0x3f128
#define ixDPM_TABLE_76                                                          0x3f12c
#define ixDPM_TABLE_77                                                          0x3f130
#define ixDPM_TABLE_78                                                          0x3f134
#define ixDPM_TABLE_79                                                          0x3f138
#define ixDPM_TABLE_80                                                          0x3f13c
#define ixDPM_TABLE_81                                                          0x3f140
#define ixDPM_TABLE_82                                                          0x3f144
#define ixDPM_TABLE_83                                                          0x3f148
#define ixDPM_TABLE_84                                                          0x3f14c
#define ixDPM_TABLE_85                                                          0x3f150
#define ixDPM_TABLE_86                                                          0x3f154
#define ixDPM_TABLE_87                                                          0x3f158
#define ixDPM_TABLE_88                                                          0x3f15c
#define ixDPM_TABLE_89                                                          0x3f160
#define ixDPM_TABLE_90                                                          0x3f164
#define ixDPM_TABLE_91                                                          0x3f168
#define ixDPM_TABLE_92                                                          0x3f16c
#define ixDPM_TABLE_93                                                          0x3f170
#define ixDPM_TABLE_94                                                          0x3f174
#define ixDPM_TABLE_95                                                          0x3f178
#define ixDPM_TABLE_96                                                          0x3f17c
#define ixDPM_TABLE_97                                                          0x3f180
#define ixDPM_TABLE_98                                                          0x3f184
#define ixDPM_TABLE_99                                                          0x3f188
#define ixDPM_TABLE_100                                                         0x3f18c
#define ixDPM_TABLE_101                                                         0x3f190
#define ixDPM_TABLE_102                                                         0x3f194
#define ixDPM_TABLE_103                                                         0x3f198
#define ixDPM_TABLE_104                                                         0x3f19c
#define ixDPM_TABLE_105                                                         0x3f1a0
#define ixDPM_TABLE_106                                                         0x3f1a4
#define ixDPM_TABLE_107                                                         0x3f1a8
#define ixDPM_TABLE_108                                                         0x3f1ac
#define ixDPM_TABLE_109                                                         0x3f1b0
#define ixDPM_TABLE_110                                                         0x3f1b4
#define ixDPM_TABLE_111                                                         0x3f1b8
#define ixDPM_TABLE_112                                                         0x3f1bc
#define ixDPM_TABLE_113                                                         0x3f1c0
#define ixDPM_TABLE_114                                                         0x3f1c4
#define ixDPM_TABLE_115                                                         0x3f1c8
#define ixDPM_TABLE_116                                                         0x3f1cc
#define ixDPM_TABLE_117                                                         0x3f1d0
#define ixDPM_TABLE_118                                                         0x3f1d4
#define ixDPM_TABLE_119                                                         0x3f1d8
#define ixDPM_TABLE_120                                                         0x3f1dc
#define ixDPM_TABLE_121                                                         0x3f1e0
#define ixDPM_TABLE_122                                                         0x3f1e4
#define ixDPM_TABLE_123                                                         0x3f1e8
#define ixDPM_TABLE_124                                                         0x3f1ec
#define ixDPM_TABLE_125                                                         0x3f1f0
#define ixDPM_TABLE_126                                                         0x3f1f4
#define ixDPM_TABLE_127                                                         0x3f1f8
#define ixDPM_TABLE_128                                                         0x3f1fc
#define ixDPM_TABLE_129                                                         0x3f200
#define ixDPM_TABLE_130                                                         0x3f204
#define ixDPM_TABLE_131                                                         0x3f208
#define ixDPM_TABLE_132                                                         0x3f20c
#define ixDPM_TABLE_133                                                         0x3f210
#define ixDPM_TABLE_134                                                         0x3f214
#define ixDPM_TABLE_135                                                         0x3f218
#define ixDPM_TABLE_136                                                         0x3f21c
#define ixDPM_TABLE_137                                                         0x3f220
#define ixDPM_TABLE_138                                                         0x3f224
#define ixDPM_TABLE_139                                                         0x3f228
#define ixDPM_TABLE_140                                                         0x3f22c
#define ixDPM_TABLE_141                                                         0x3f230
#define ixDPM_TABLE_142                                                         0x3f234
#define ixDPM_TABLE_143                                                         0x3f238
#define ixDPM_TABLE_144                                                         0x3f23c
#define ixDPM_TABLE_145                                                         0x3f240
#define ixDPM_TABLE_146                                                         0x3f244
#define ixDPM_TABLE_147                                                         0x3f248
#define ixDPM_TABLE_148                                                         0x3f24c
#define ixDPM_TABLE_149                                                         0x3f250
#define ixDPM_TABLE_150                                                         0x3f254
#define ixDPM_TABLE_151                                                         0x3f258
#define ixDPM_TABLE_152                                                         0x3f25c
#define ixDPM_TABLE_153                                                         0x3f260
#define ixDPM_TABLE_154                                                         0x3f264
#define ixDPM_TABLE_155                                                         0x3f268
#define ixDPM_TABLE_156                                                         0x3f26c
#define ixDPM_TABLE_157                                                         0x3f270
#define ixDPM_TABLE_158                                                         0x3f274
#define ixDPM_TABLE_159                                                         0x3f278
#define ixDPM_TABLE_160                                                         0x3f27c
#define ixDPM_TABLE_161                                                         0x3f280
#define ixDPM_TABLE_162                                                         0x3f284
#define ixDPM_TABLE_163                                                         0x3f288
#define ixDPM_TABLE_164                                                         0x3f28c
#define ixDPM_TABLE_165                                                         0x3f290
#define ixDPM_TABLE_166                                                         0x3f294
#define ixDPM_TABLE_167                                                         0x3f298
#define ixDPM_TABLE_168                                                         0x3f29c
#define ixDPM_TABLE_169                                                         0x3f2a0
#define ixDPM_TABLE_170                                                         0x3f2a4
#define ixDPM_TABLE_171                                                         0x3f2a8
#define ixDPM_TABLE_172                                                         0x3f2ac
#define ixDPM_TABLE_173                                                         0x3f2b0
#define ixDPM_TABLE_174                                                         0x3f2b4
#define ixDPM_TABLE_175                                                         0x3f2b8
#define ixDPM_TABLE_176                                                         0x3f2bc
#define ixDPM_TABLE_177                                                         0x3f2c0
#define ixDPM_TABLE_178                                                         0x3f2c4
#define ixDPM_TABLE_179                                                         0x3f2c8
#define ixDPM_TABLE_180                                                         0x3f2cc
#define ixDPM_TABLE_181                                                         0x3f2d0
#define ixDPM_TABLE_182                                                         0x3f2d4
#define ixDPM_TABLE_183                                                         0x3f2d8
#define ixDPM_TABLE_184                                                         0x3f2dc
#define ixDPM_TABLE_185                                                         0x3f2e0
#define ixDPM_TABLE_186                                                         0x3f2e4
#define ixDPM_TABLE_187                                                         0x3f2e8
#define ixDPM_TABLE_188                                                         0x3f2ec
#define ixDPM_TABLE_189                                                         0x3f2f0
#define ixDPM_TABLE_190                                                         0x3f2f4
#define ixDPM_TABLE_191                                                         0x3f2f8
#define ixSOFT_REGISTERS_TABLE_1                                                0x3f900
#define ixSOFT_REGISTERS_TABLE_2                                                0x3f904
#define ixSOFT_REGISTERS_TABLE_3                                                0x3f908
#define ixSOFT_REGISTERS_TABLE_4                                                0x3f90c
#define ixSOFT_REGISTERS_TABLE_5                                                0x3f910
#define ixSOFT_REGISTERS_TABLE_6                                                0x3f914
#define ixSOFT_REGISTERS_TABLE_7                                                0x3f918
#define ixSOFT_REGISTERS_TABLE_8                                                0x3f91c
#define ixSOFT_REGISTERS_TABLE_9                                                0x3f920
#define ixSOFT_REGISTERS_TABLE_10                                               0x3f924
#define ixSOFT_REGISTERS_TABLE_11                                               0x3f928
#define ixSOFT_REGISTERS_TABLE_12                                               0x3f92c
#define ixSOFT_REGISTERS_TABLE_13                                               0x3f930
#define ixSOFT_REGISTERS_TABLE_14                                               0x3f934
#define ixSOFT_REGISTERS_TABLE_15                                               0x3f938
#define ixSOFT_REGISTERS_TABLE_16                                               0x3f93c
#define ixSOFT_REGISTERS_TABLE_17                                               0x3f940
#define ixSOFT_REGISTERS_TABLE_18                                               0x3f944
#define ixSOFT_REGISTERS_TABLE_19                                               0x3f948
#define ixSOFT_REGISTERS_TABLE_20                                               0x3f94c
#define ixSOFT_REGISTERS_TABLE_21                                               0x3f950
#define ixSMU_LCLK_DPM_STATE_0_CNTL_0                                           0x3fd00
#define ixSMU_LCLK_DPM_STATE_1_CNTL_0                                           0x3fd14
#define ixSMU_LCLK_DPM_STATE_2_CNTL_0                                           0x3fd28
#define ixSMU_LCLK_DPM_STATE_3_CNTL_0                                           0x3fd3c
#define ixSMU_LCLK_DPM_STATE_4_CNTL_0                                           0x3fd50
#define ixSMU_LCLK_DPM_STATE_5_CNTL_0                                           0x3fd64
#define ixSMU_LCLK_DPM_STATE_6_CNTL_0                                           0x3fd78
#define ixSMU_LCLK_DPM_STATE_7_CNTL_0                                           0x3fd8c
#define ixSMU_LCLK_DPM_STATE_0_CNTL_1                                           0x3fd04
#define ixSMU_LCLK_DPM_STATE_1_CNTL_1                                           0x3fd18
#define ixSMU_LCLK_DPM_STATE_2_CNTL_1                                           0x3fd2c
#define ixSMU_LCLK_DPM_STATE_3_CNTL_1                                           0x3fd40
#define ixSMU_LCLK_DPM_STATE_4_CNTL_1                                           0x3fd54
#define ixSMU_LCLK_DPM_STATE_5_CNTL_1                                           0x3fd68
#define ixSMU_LCLK_DPM_STATE_6_CNTL_1                                           0x3fd7c
#define ixSMU_LCLK_DPM_STATE_7_CNTL_1                                           0x3fd90
#define ixSMU_LCLK_DPM_STATE_0_CNTL_2                                           0x3fd08
#define ixSMU_LCLK_DPM_STATE_1_CNTL_2                                           0x3fd1c
#define ixSMU_LCLK_DPM_STATE_2_CNTL_2                                           0x3fd30
#define ixSMU_LCLK_DPM_STATE_3_CNTL_2                                           0x3fd44
#define ixSMU_LCLK_DPM_STATE_4_CNTL_2                                           0x3fd58
#define ixSMU_LCLK_DPM_STATE_5_CNTL_2                                           0x3fd6c
#define ixSMU_LCLK_DPM_STATE_6_CNTL_2                                           0x3fd80
#define ixSMU_LCLK_DPM_STATE_7_CNTL_2                                           0x3fd94
#define ixSMU_LCLK_DPM_STATE_0_CNTL_3                                           0x3fd0c
#define ixSMU_LCLK_DPM_STATE_1_CNTL_3                                           0x3fd20
#define ixSMU_LCLK_DPM_STATE_2_CNTL_3                                           0x3fd34
#define ixSMU_LCLK_DPM_STATE_3_CNTL_3                                           0x3fd48
#define ixSMU_LCLK_DPM_STATE_4_CNTL_3                                           0x3fd5c
#define ixSMU_LCLK_DPM_STATE_5_CNTL_3                                           0x3fd70
#define ixSMU_LCLK_DPM_STATE_6_CNTL_3                                           0x3fd84
#define ixSMU_LCLK_DPM_STATE_7_CNTL_3                                           0x3fd98
#define ixSMU_LCLK_DPM_STATE_0_ACTIVITY_THRESHOLD                               0x3fd10
#define ixSMU_LCLK_DPM_STATE_1_ACTIVITY_THRESHOLD                               0x3fd24
#define ixSMU_LCLK_DPM_STATE_2_ACTIVITY_THRESHOLD                               0x3fd38
#define ixSMU_LCLK_DPM_STATE_3_ACTIVITY_THRESHOLD                               0x3fd4c
#define ixSMU_LCLK_DPM_STATE_4_ACTIVITY_THRESHOLD                               0x3fd60
#define ixSMU_LCLK_DPM_STATE_5_ACTIVITY_THRESHOLD                               0x3fd74
#define ixSMU_LCLK_DPM_STATE_6_ACTIVITY_THRESHOLD                               0x3fd88
#define ixSMU_LCLK_DPM_STATE_7_ACTIVITY_THRESHOLD                               0x3fd9c
#define ixGIO_PID_CONTROLLER_CNTL_0                                             0x3fda0
#define ixGIO_PID_CONTROLLER_CNTL_1                                             0x3fda4
#define ixGIO_PID_CONTROLLER_CNTL_2                                             0x3fda8
#define ixGIO_PID_CONTROLLER_CNTL_3                                             0x3fdac
#define ixGIO_PID_CONTROLLER_CNTL_4                                             0x3fdb0
#define ixGIO_PID_CONTROLLER_CNTL_5                                             0x3fdb4
#define ixGIO_PID_CONTROLLER_CNTL_6                                             0x3fdb8
#define ixGIO_PID_CONTROLLER_CNTL_7                                             0x3fdbc
#define ixGIO_PID_CONTROLLER_CNTL_8                                             0x3fdc0
#define ixSMU_LCLK_DPM_LEVEL_COUNT                                              0x3fdc4
#define ixSMU_LCLK_DPM_CNTL                                                     0x3fdc8
#define ixSMU_LCLK_DPM_CURRENT_AND_TARGET_STATE                                 0x3fdcc
#define ixSMU_LCLK_DPM_THERMAL_THROTTLING_CNTL                                  0x3fdd0
#define ixSMU_LCLK_DPM_THERMAL_THROTTLING_THRESHOLDS                            0x3fdd4
#define ixPM_FUSES_1                                                            0x3fa80
#define ixPM_FUSES_2                                                            0x3fa84
#define ixPM_FUSES_3                                                            0x3fa88
#define ixPM_FUSES_4                                                            0x3fa8c
#define ixPM_FUSES_5                                                            0x3fa90
#define ixPM_FUSES_6                                                            0x3fa94
#define ixPM_FUSES_7                                                            0x3fa98
#define ixPM_FUSES_8                                                            0x3fa9c
#define ixPM_FUSES_9                                                            0x3faa0
#define ixPM_FUSES_10                                                           0x3faa4
#define ixPM_FUSES_11                                                           0x3faa8
#define ixPM_FUSES_12                                                           0x3faac
#define ixPM_FUSES_13                                                           0x3fab0
#define ixPM_FUSES_14                                                           0x3fab4
#define ixPM_FUSES_15                                                           0x3fab8
#define ixPM_FUSES_16                                                           0x3fabc
#define ixPM_FUSES_17                                                           0x3fac0
#define ixPM_FUSES_18                                                           0x3fac4
#define ixPM_FUSES_19                                                           0x3fac8
#define ixPM_FUSES_20                                                           0x3facc
#define ixPM_FUSES_21                                                           0x3fad0
#define ixPM_FUSES_22                                                           0x3fad4
#define ixPM_FUSES_23                                                           0x3fad8
#define ixPM_FUSES_24                                                           0x3fadc
#define ixPM_FUSES_25                                                           0x3fae0
#define ixPM_FUSES_26                                                           0x3fae4
#define ixPM_FUSES_27                                                           0x3fae8
#define ixPM_FUSES_28                                                           0x3faec
#define ixPM_FUSES_29                                                           0x3faf0
#define ixPM_FUSES_30                                                           0x3faf4
#define ixPM_FUSES_31                                                           0x3faf8
#define ixPM_FUSES_32                                                           0x3fafc
#define ixPM_FUSES_33                                                           0x3fb00
#define ixPM_FUSES_34                                                           0x3fb04
#define ixPM_FUSES_35                                                           0x3fb08
#define ixPM_FUSES_36                                                           0x3fb0c
#define ixPM_FUSES_37                                                           0x3fb10
#define ixPM_FUSES_38                                                           0x3fb14
#define ixPM_FUSES_39                                                           0x3fb18
#define ixPM_FUSES_40                                                           0x3fb1c
#define ixPM_FUSES_41                                                           0x3fb20
#define ixPM_FUSES_42                                                           0x3fb24
#define ixPM_FUSES_43                                                           0x3fb28
#define ixPM_FUSES_44                                                           0x3fb2c
#define ixPM_FUSES_45                                                           0x3fb30
#define ixPM_FUSES_46                                                           0x3fb34
#define ixPM_FUSES_47                                                           0x3fb38
#define ixPM_FUSES_48                                                           0x3fb3c
#define ixPM_FUSES_49                                                           0x3fb40
#define ixPM_FUSES_50                                                           0x3fb44
#define ixPM_FUSES_51                                                           0x3fb48
#define ixPM_FUSES_52                                                           0x3fb4c
#define ixPM_FUSES_53                                                           0x3fb50
#define ixPM_FUSES_54                                                           0x3fb54
#define ixPM_FUSES_55                                                           0x3fb58
#define ixPM_FUSES_56                                                           0x3fb5c
#define ixPM_FUSES_57                                                           0x3fb60
#define ixPM_FUSES_58                                                           0x3fb64
#define ixPM_FUSES_59                                                           0x3fb68
#define ixPM_FUSES_60                                                           0x3fb6c
#define ixPM_FUSES_61                                                           0x3fb70
#define ixPM_FUSES_62                                                           0x3fb74
#define ixPM_FUSES_63                                                           0x3fb78
#define ixPM_FUSES_64                                                           0x3fb7c
#define ixPM_FUSES_65                                                           0x3fb80
#define ixFIRMWARE_FLAGS                                                        0x3f800
#define ixTEMPERATURE_READ_ADDR                                                 0x3f808
#define ixCURRENT_GNB_TEMP                                                      0x3f810
#define ixCURRENT_GLOBAL_TEMP                                                   0x3f814
#define ixFEATURE_STATUS                                                        0x3f818
#define ixPCIE_PLL_RECONF                                                       0x3f81c
#define ixPM_INTERVAL_CNTL_0                                                    0x3f820
#define ixPM_INTERVAL_CNTL_1                                                    0x3f824
#define ixPM_INTERVAL_CNTL_2                                                    0x3f82c
#define ixVPC_INTERVAL_CNTL                                                     0x3f830
#define ixDISP_PHY_TDP_LIMIT                                                    0x3f834
#define ixFCH_PWR_CREDIT                                                        0x3f838
#define ixPKGPWR_MV_AVG                                                         0x3f83c
#define ixPACKAGE_POWER                                                         0x3f840
#define ixPKG_PWR_CNTL                                                          0x3f844
#define ixPKG_PWR_STATUS                                                        0x3f848
#define ixDISP_PHY_CONFIG                                                       0x3f84c
#define ixGPU_TDP_LIMIT                                                         0x3f850
#define ixEXT_API_IN_DATA_0_0                                                   0x3f858
#define ixEXT_API_IN_DATA_0_1                                                   0x3f85c
#define ixEXT_API_IN_DATA_0_2                                                   0x3f860
#define ixEXT_API_IN_DATA_0_3                                                   0x3f864
#define ixEXT_API_OUT_DATA_0_0                                                  0x3f868
#define ixEXT_API_OUT_DATA_0_1                                                  0x3f86c
#define ixEXT_API_OUT_DATA_0_2                                                  0x3f870
#define ixEXT_API_OUT_DATA_0_3                                                  0x3f874
#define ixBAPM_PARAMETERS                                                       0x3f984
#define ixBAPM_PARAMETERS_2                                                     0x3f988
#define ixBAPM_PARAMETERS_3                                                     0x3f98c
#define ixBAPM_PARAMETERS_4                                                     0x3f990
#define ixSMU_SVI_TELEMETRY                                                     0x3f994
#define ixBAPM_STATUS                                                           0x3f998
#define ixSMU_HTC_STATUS                                                        0x3f99c
#define ixSMU_VPC_STATUS                                                        0x3f9a0
#define ixENTITY_TEMPERATURES_1                                                 0x3f9a4
#define ixENTITY_TEMPERATURES_2                                                 0x3f9a8
#define ixENTITY_TEMPERATURES_3                                                 0x3f9ac
#define ixCU_POWER                                                              0x3f9b0
#define ixGPU_POWER                                                             0x3f9b4
#define ixNTE_POWER                                                             0x3f9b8
#define ixTDC_STATUS                                                            0x3f9d0
#define ixTDC_MV_AVERAGE                                                        0x3f9d4
#define ixPM_CONFIG                                                             0x3f9d8
#define ixTE0_TEMPERATURE_READ_ADDR                                             0x3f9dc
#define ixTE1_TEMPERATURE_READ_ADDR                                             0x3f9e0
#define ixTE2_TEMPERATURE_READ_ADDR                                             0x3f9e4
#define ixNB_DPM_CONFIG_1                                                       0x3f9e8
#define ixNB_DPM_CONFIG_2                                                       0x3f9ec
#define ixNB_DPM_CONFIG_3                                                       0x3f9f0
#define ixSMU_IDD_OVERRIDE                                                      0x3f9fc
#define ixAVS_CONFIG                                                            0x3fa00
#define ixTDC_VRM_LIMIT                                                         0x3fa04
#define ixCU0_PSM_CONFIG                                                        0x3fa08
#define ixCU1_PSM_CONFIG                                                        0x3fa0c
#define ixSPMI_CONFIG                                                           0x3fa10
#define ixSPMI_SMC_CHAIN_ADDR                                                   0x3fa14
#define ixSPMI_STATUS                                                           0x3fa30
#define ixAVSNB_CONFIG                                                          0x3fa34
#define ixHTC_CONFIG                                                            0x3fa38
#define ixAVS_CU0_TEMPERATURE_SENSOR                                            0x3fa3c
#define ixAVS_CU1_TEMPERATURE_SENSOR                                            0x3fa40
#define ixAVS_GNB_TEMPERATURE_SENSOR                                            0x3fa44
#define ixAVS_UNB_TEMPERATURE_SENSOR                                            0x3fa48
#define ixSMU_MONITOR_PORT80_MMIO_ADDR                                          0x3fa4c
#define ixSMU_MONITOR_PORT80_MEMBASE_HI                                         0x3fa50
#define ixSMU_MONITOR_PORT80_MEMBASE_LO                                         0x3fa54
#define ixSMU_MONITOR_PORT80_MEMSETUP                                           0x3fa58
#define ixSMU_MONITOR_PORT80_CTRL                                               0x3fa5c
#define ixSMU_TCEN_ALIVE                                                        0x3fa60
#define ixPDM_STATUS                                                            0x3fa64
#define ixPDM_CNTL_1                                                            0x3fa68
#define ixPDM_CNTL_2                                                            0x3fa6c
#define ixPDM_CNTL_3                                                            0x3fa70
#define ixSMU_PM_STATUS_0                                                       0x3fe00
#define ixSMU_PM_STATUS_1                                                       0x3fe04
#define ixSMU_PM_STATUS_2                                                       0x3fe08
#define ixSMU_PM_STATUS_3                                                       0x3fe0c
#define ixSMU_PM_STATUS_4                                                       0x3fe10
#define ixSMU_PM_STATUS_5                                                       0x3fe14
#define ixSMU_PM_STATUS_6                                                       0x3fe18
#define ixSMU_PM_STATUS_7                                                       0x3fe1c
#define ixSMU_PM_STATUS_8                                                       0x3fe20
#define ixSMU_PM_STATUS_9                                                       0x3fe24
#define ixSMU_PM_STATUS_10                                                      0x3fe28
#define ixSMU_PM_STATUS_11                                                      0x3fe2c
#define ixSMU_PM_STATUS_12                                                      0x3fe30
#define ixSMU_PM_STATUS_13                                                      0x3fe34
#define ixSMU_PM_STATUS_14                                                      0x3fe38
#define ixSMU_PM_STATUS_15                                                      0x3fe3c
#define ixSMU_PM_STATUS_16                                                      0x3fe40
#define ixSMU_PM_STATUS_17                                                      0x3fe44
#define ixSMU_PM_STATUS_18                                                      0x3fe48
#define ixSMU_PM_STATUS_19                                                      0x3fe4c
#define ixSMU_PM_STATUS_20                                                      0x3fe50
#define ixSMU_PM_STATUS_21                                                      0x3fe54
#define ixSMU_PM_STATUS_22                                                      0x3fe58
#define ixSMU_PM_STATUS_23                                                      0x3fe5c
#define ixSMU_PM_STATUS_24                                                      0x3fe60
#define ixSMU_PM_STATUS_25                                                      0x3fe64
#define ixSMU_PM_STATUS_26                                                      0x3fe68
#define ixSMU_PM_STATUS_27                                                      0x3fe6c
#define ixSMU_PM_STATUS_28                                                      0x3fe70
#define ixSMU_PM_STATUS_29                                                      0x3fe74
#define ixSMU_PM_STATUS_30                                                      0x3fe78
#define ixSMU_PM_STATUS_31                                                      0x3fe7c
#define ixSMU_PM_STATUS_32                                                      0x3fe80
#define ixSMU_PM_STATUS_33                                                      0x3fe84
#define ixSMU_PM_STATUS_34                                                      0x3fe88
#define ixSMU_PM_STATUS_35                                                      0x3fe8c
#define ixSMU_PM_STATUS_36                                                      0x3fe90
#define ixSMU_PM_STATUS_37                                                      0x3fe94
#define ixSMU_PM_STATUS_38                                                      0x3fe98
#define ixSMU_PM_STATUS_39                                                      0x3fe9c
#define ixSMU_PM_STATUS_40                                                      0x3fea0
#define ixSMU_PM_STATUS_41                                                      0x3fea4
#define ixSMU_PM_STATUS_42                                                      0x3fea8
#define ixSMU_PM_STATUS_43                                                      0x3feac
#define ixSMU_PM_STATUS_44                                                      0x3feb0
#define ixSMU_PM_STATUS_45                                                      0x3feb4
#define ixSMU_PM_STATUS_46                                                      0x3feb8
#define ixSMU_PM_STATUS_47                                                      0x3febc
#define ixSMU_PM_STATUS_48                                                      0x3fec0
#define ixSMU_PM_STATUS_49                                                      0x3fec4
#define ixSMU_PM_STATUS_50                                                      0x3fec8
#define ixSMU_PM_STATUS_51                                                      0x3fecc
#define ixSMU_PM_STATUS_52                                                      0x3fed0
#define ixSMU_PM_STATUS_53                                                      0x3fed4
#define ixSMU_PM_STATUS_54                                                      0x3fed8
#define ixSMU_PM_STATUS_55                                                      0x3fedc
#define ixSMU_PM_STATUS_56                                                      0x3fee0
#define ixSMU_PM_STATUS_57                                                      0x3fee4
#define ixSMU_PM_STATUS_58                                                      0x3fee8
#define ixSMU_PM_STATUS_59                                                      0x3feec
#define ixSMU_PM_STATUS_60                                                      0x3fef0
#define ixSMU_PM_STATUS_61                                                      0x3fef4
#define ixSMU_PM_STATUS_62                                                      0x3fef8
#define ixSMU_PM_STATUS_63                                                      0x3fefc
#define ixSMU_PM_STATUS_64                                                      0x3ff00
#define ixSMU_PM_STATUS_65                                                      0x3ff04
#define ixSMU_PM_STATUS_66                                                      0x3ff08
#define ixSMU_PM_STATUS_67                                                      0x3ff0c
#define ixSMU_PM_STATUS_68                                                      0x3ff10
#define ixSMU_PM_STATUS_69                                                      0x3ff14
#define ixSMU_PM_STATUS_70                                                      0x3ff18
#define ixSMU_PM_STATUS_71                                                      0x3ff1c
#define ixSMU_PM_STATUS_72                                                      0x3ff20
#define ixSMU_PM_STATUS_73                                                      0x3ff24
#define ixSMU_PM_STATUS_74                                                      0x3ff28
#define ixSMU_PM_STATUS_75                                                      0x3ff2c
#define ixSMU_PM_STATUS_76                                                      0x3ff30
#define ixSMU_PM_STATUS_77                                                      0x3ff34
#define ixSMU_PM_STATUS_78                                                      0x3ff38
#define ixSMU_PM_STATUS_79                                                      0x3ff3c
#define ixSMU_PM_STATUS_80                                                      0x3ff40
#define ixSMU_PM_STATUS_81                                                      0x3ff44
#define ixSMU_PM_STATUS_82                                                      0x3ff48
#define ixSMU_PM_STATUS_83                                                      0x3ff4c
#define ixSMU_PM_STATUS_84                                                      0x3ff50
#define ixSMU_PM_STATUS_85                                                      0x3ff54
#define ixSMU_PM_STATUS_86                                                      0x3ff58
#define ixSMU_PM_STATUS_87                                                      0x3ff5c
#define ixSMU_PM_STATUS_88                                                      0x3ff60
#define ixSMU_PM_STATUS_89                                                      0x3ff64
#define ixSMU_PM_STATUS_90                                                      0x3ff68
#define ixSMU_PM_STATUS_91                                                      0x3ff6c
#define ixSMU_PM_STATUS_92                                                      0x3ff70
#define ixSMU_PM_STATUS_93                                                      0x3ff74
#define ixSMU_PM_STATUS_94                                                      0x3ff78
#define ixSMU_PM_STATUS_95                                                      0x3ff7c
#define ixSMU_PM_STATUS_96                                                      0x3ff80
#define ixSMU_PM_STATUS_97                                                      0x3ff84
#define ixSMU_PM_STATUS_98                                                      0x3ff88
#define ixSMU_PM_STATUS_99                                                      0x3ff8c
#define ixSMU_PM_STATUS_100                                                     0x3ff90
#define ixSMU_PM_STATUS_101                                                     0x3ff94
#define ixSMU_PM_STATUS_102                                                     0x3ff98
#define ixSMU_PM_STATUS_103                                                     0x3ff9c
#define ixSMU_PM_STATUS_104                                                     0x3ffa0
#define ixSMU_PM_STATUS_105                                                     0x3ffa4
#define ixSMU_PM_STATUS_106                                                     0x3ffa8
#define ixSMU_PM_STATUS_107                                                     0x3ffac
#define ixSMU_PM_STATUS_108                                                     0x3ffb0
#define ixSMU_PM_STATUS_109                                                     0x3ffb4
#define ixSMU_PM_STATUS_110                                                     0x3ffb8
#define ixSMU_PM_STATUS_111                                                     0x3ffbc
#define ixSMU_PM_STATUS_112                                                     0x3ffc0
#define ixSMU_PM_STATUS_113                                                     0x3ffc4
#define ixSMU_PM_STATUS_114                                                     0x3ffc8
#define ixSMU_PM_STATUS_115                                                     0x3ffcc
#define ixSMU_PM_STATUS_116                                                     0x3ffd0
#define ixSMU_PM_STATUS_117                                                     0x3ffd4
#define ixSMU_PM_STATUS_118                                                     0x3ffd8
#define ixSMU_PM_STATUS_119                                                     0x3ffdc
#define ixSMU_PM_STATUS_120                                                     0x3ffe0
#define ixSMU_PM_STATUS_121                                                     0x3ffe4
#define ixSMU_PM_STATUS_122                                                     0x3ffe8
#define ixSMU_PM_STATUS_123                                                     0x3ffec
#define ixSMU_PM_STATUS_124                                                     0x3fff0
#define ixSMU_PM_STATUS_125                                                     0x3fff4
#define ixSMU_PM_STATUS_126                                                     0x3fff8
#define ixSMU_PM_STATUS_127                                                     0x3fffc
#define ixCG_THERMAL_INT_ENA                                                    0xc2100024
#define ixCG_THERMAL_INT_CTRL                                                   0xc2100028
#define ixCG_THERMAL_INT_STATUS                                                 0xc210002c
#define ixGENERAL_PWRMGT                                                        0xc0200000
#define ixCNB_PWRMGT_CNTL                                                       0xc0200004
#define ixSCLK_PWRMGT_CNTL                                                      0xc0200008
#define ixTARGET_AND_CURRENT_PROFILE_INDEX                                      0xc0200014
#define ixCG_FREQ_TRAN_VOTING_0                                                 0xc02001a8
#define ixCG_FREQ_TRAN_VOTING_1                                                 0xc02001ac
#define ixCG_FREQ_TRAN_VOTING_2                                                 0xc02001b0
#define ixCG_FREQ_TRAN_VOTING_3                                                 0xc02001b4
#define ixCG_FREQ_TRAN_VOTING_4                                                 0xc02001b8
#define ixCG_FREQ_TRAN_VOTING_5                                                 0xc02001bc
#define ixCG_FREQ_TRAN_VOTING_6                                                 0xc02001c0
#define ixCG_FREQ_TRAN_VOTING_7                                                 0xc02001c4
#define ixPLL_TEST_CNTL                                                         0xc020003c
#define ixCG_STATIC_SCREEN_PARAMETER                                            0xc0200044
#define ixCG_DISPLAY_GAP_CNTL                                                   0xc0200060
#define ixCG_DISPLAY_GAP_CNTL2                                                  0xc0200230
#define ixCG_ACPI_CNTL                                                          0xc0200064
#define ixSCLK_DEEP_SLEEP_CNTL                                                  0xc0200080
#define ixSCLK_DEEP_SLEEP_CNTL2                                                 0xc0200084
#define ixSCLK_DEEP_SLEEP_CNTL3                                                 0xc020009c
#define ixSCLK_DEEP_SLEEP_MISC_CNTL                                             0xc0200088
#define ixLCLK_DEEP_SLEEP_CNTL                                                  0xc020008c
#define ixLCLK_DEEP_SLEEP_CNTL2                                                 0xc0200310
#define ixSMU_VOLTAGE_STATUS                                                    0xc0200094
#define ixTARGET_AND_CURRENT_PROFILE_INDEX_1                                    0xc02000f0
#define ixCG_ULV_PARAMETER                                                      0xc020015c
#define ixSCLK_MIN_DIV                                                          0xc0200308
#define ixLCAC_SX0_CNTL                                                         0xc0400d00
#define ixLCAC_SX0_OVR_SEL                                                      0xc0400d04
#define ixLCAC_SX0_OVR_VAL                                                      0xc0400d08
#define ixLCAC_MC0_CNTL                                                         0xc0400d30
#define ixLCAC_MC0_OVR_SEL                                                      0xc0400d34
#define ixLCAC_MC0_OVR_VAL                                                      0xc0400d38
#define ixLCAC_MC1_CNTL                                                         0xc0400d3c
#define ixLCAC_MC1_OVR_SEL                                                      0xc0400d40
#define ixLCAC_MC1_OVR_VAL                                                      0xc0400d44
#define ixLCAC_MC2_CNTL                                                         0xc0400d48
#define ixLCAC_MC2_OVR_SEL                                                      0xc0400d4c
#define ixLCAC_MC2_OVR_VAL                                                      0xc0400d50
#define ixLCAC_MC3_CNTL                                                         0xc0400d54
#define ixLCAC_MC3_OVR_SEL                                                      0xc0400d58
#define ixLCAC_MC3_OVR_VAL                                                      0xc0400d5c
#define ixLCAC_CPL_CNTL                                                         0xc0400d80
#define ixLCAC_CPL_OVR_SEL                                                      0xc0400d84
#define ixLCAC_CPL_OVR_VAL                                                      0xc0400d88

#endif /* SMU_7_0_0_D_H */
