/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2024 Intel Corporation
 */

#ifndef __INTEL_PIPE_CRC_REGS_H__
#define __INTEL_PIPE_CRC_REGS_H__

#include "intel_display_reg_defs.h"

#define _PIPE_CRC_CTL_A			0x60050
#define PIPE_CRC_CTL(dev_priv, pipe)		_MMIO_TRANS2((dev_priv), (pipe), _PIPE_CRC_CTL_A)
#define   PIPE_CRC_ENABLE		REG_BIT(31)
/* skl+ source selection */
#define   PIPE_CRC_SOURCE_MASK_SKL	REG_GENMASK(30, 28)
#define   PIPE_CRC_SOURCE_PLANE_1_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 0)
#define   PIPE_CRC_SOURCE_PLANE_2_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 2)
#define   PIPE_CRC_SOURCE_DMUX_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 4)
#define   PIPE_CRC_SOURCE_PLANE_3_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 6)
#define   PIPE_CRC_SOURCE_PLANE_4_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 7)
#define   PIPE_CRC_SOURCE_PLANE_5_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 5)
#define   PIPE_CRC_SOURCE_PLANE_6_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 3)
#define   PIPE_CRC_SOURCE_PLANE_7_SKL	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_SKL, 1)
/* ivb+ source selection */
#define   PIPE_CRC_SOURCE_MASK_IVB	REG_GENMASK(30, 29)
#define   PIPE_CRC_SOURCE_PRIMARY_IVB	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_IVB, 0)
#define   PIPE_CRC_SOURCE_SPRITE_IVB	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_IVB, 1)
#define   PIPE_CRC_SOURCE_PF_IVB	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_IVB, 2)
/* ilk+ source selection */
#define   PIPE_CRC_SOURCE_MASK_ILK	REG_GENMASK(30, 28)
#define   PIPE_CRC_SOURCE_PRIMARY_ILK	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_ILK, 0)
#define   PIPE_CRC_SOURCE_SPRITE_ILK	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_ILK, 1)
#define   PIPE_CRC_SOURCE_PIPE_ILK	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_ILK, 2)
/* embedded DP port on the north display block */
#define   PIPE_CRC_SOURCE_PORT_A_ILK	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_ILK, 4)
#define   PIPE_CRC_SOURCE_FDI_ILK	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_ILK, 5)
/* vlv source selection */
#define   PIPE_CRC_SOURCE_MASK_VLV	REG_GENMASK(30, 27)
#define   PIPE_CRC_SOURCE_PIPE_VLV	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_VLV, 0)
#define   PIPE_CRC_SOURCE_HDMIB_VLV	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_VLV, 1)
#define   PIPE_CRC_SOURCE_HDMIC_VLV	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_VLV, 2)
/* with DP port the pipe source is invalid */
#define   PIPE_CRC_SOURCE_DP_D_VLV	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_VLV, 3)
#define   PIPE_CRC_SOURCE_DP_B_VLV	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_VLV, 6)
#define   PIPE_CRC_SOURCE_DP_C_VLV	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_VLV, 7)
/* gen3+ source selection */
#define   PIPE_CRC_SOURCE_MASK_I9XX	REG_GENMASK(30, 28)
#define   PIPE_CRC_SOURCE_PIPE_I9XX	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 0)
#define   PIPE_CRC_SOURCE_SDVOB_I9XX	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 1)
#define   PIPE_CRC_SOURCE_SDVOC_I9XX	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 2)
/* with DP/TV port the pipe source is invalid */
#define   PIPE_CRC_SOURCE_DP_D_G4X	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 3)
#define   PIPE_CRC_SOURCE_TV_PRE	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 4)
#define   PIPE_CRC_SOURCE_TV_POST	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 5)
#define   PIPE_CRC_SOURCE_DP_B_G4X	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 6)
#define   PIPE_CRC_SOURCE_DP_C_G4X	REG_FIELD_PREP(PIPE_CRC_SOURCE_MASK_I9XX, 7)
/* gen2 doesn't have source selection bits */
#define   PIPE_CRC_INCLUDE_BORDER_I8XX	REG_BIT(30)
#define   PIPE_CRC_EXP_RED_MASK		REG_BIT(22, 0) /* pre-ivb */
#define   PIPE_CRC_EXP_1_MASK_IVB	REG_BIT(22, 0) /* ivb */

#define _PIPE_CRC_EXP_GREEN_A		0x60054
#define PIPE_CRC_EXP_GREEN(dev_priv, pipe)	_MMIO_TRANS2(dev_priv, pipe, _PIPE_CRC_EXP_GREEN_A)
#define   PIPE_CRC_EXP_GREEN_MASK	REG_BIT(22, 0) /* pre-ivb */

#define _PIPE_CRC_EXP_BLUE_A		0x60058
#define PIPE_CRC_EXP_BLUE(dev_priv, pipe)	_MMIO_TRANS2(dev_priv, pipe, _PIPE_CRC_EXP_BLUE_A)
#define   PIPE_CRC_EXP_BLUE_MASK	REG_BIT(22, 0) /* pre-ivb */

#define _PIPE_CRC_EXP_RES1_A_I915	0x6005c /* i915+ */
#define PIPE_CRC_EXP_RES1_I915(dev_priv, pipe)	_MMIO_TRANS2(dev_priv, pipe, _PIPE_CRC_EXP_RES1_A_I915)
#define   PIPE_CRC_EXP_RES1_MASK	REG_BIT(22, 0) /* pre-ivb */

#define _PIPE_CRC_EXP_RES2_A_G4X	0x60080 /* g4x+ */
#define PIPE_CRC_EXP_RES2_G4X(dev_priv, pipe)	_MMIO_TRANS2(dev_priv, pipe, _PIPE_CRC_EXP_RES2_A_G4X)
#define   PIPE_CRC_EXP_RES2_MASK	REG_BIT(22, 0) /* pre-ivb */

#define _PIPE_CRC_RES_RED_A		0x60060
#define PIPE_CRC_RES_RED(dev_priv, pipe)	_MMIO_TRANS2((dev_priv), (pipe), _PIPE_CRC_RES_RED_A)

#define _PIPE_CRC_RES_GREEN_A		0x60064
#define PIPE_CRC_RES_GREEN(dev_priv, pipe)	_MMIO_TRANS2((dev_priv), (pipe), _PIPE_CRC_RES_GREEN_A)

#define _PIPE_CRC_RES_BLUE_A		0x60068
#define PIPE_CRC_RES_BLUE(dev_priv, pipe)	_MMIO_TRANS2((dev_priv), (pipe), _PIPE_CRC_RES_BLUE_A)

#define _PIPE_CRC_RES_RES1_A_I915	0x6006c /* i915+ */
#define PIPE_CRC_RES_RES1_I915(dev_priv, pipe)	_MMIO_TRANS2((dev_priv), (pipe), _PIPE_CRC_RES_RES1_A_I915)

#define _PIPE_CRC_RES_RES2_A_G4X	0x60080 /* g4x+ */
#define PIPE_CRC_RES_RES2_G4X(dev_priv, pipe)	_MMIO_TRANS2((dev_priv), (pipe), _PIPE_CRC_RES_RES2_A_G4X)

/* ivb */
#define _PIPE_CRC_EXP_2_A_IVB		0x60054
#define _PIPE_CRC_EXP_2_B_IVB		0x61054
#define PIPE_CRC_EXP_2_IVB(pipe)		_MMIO_PIPE(pipe, _PIPE_CRC_EXP_2_A_IVB, _PIPE_CRC_EXP_2_B_IVB)
#define   PIPE_CRC_EXP_2_MASK_IVB	REG_BIT(22, 0) /* ivb */

/* ivb */
#define _PIPE_CRC_EXP_3_A_IVB		0x60058
#define _PIPE_CRC_EXP_3_B_IVB		0x61058
#define PIPE_CRC_EXP_3_IVB(pipe)		_MMIO_PIPE(pipe, _PIPE_CRC_EXP_3_A_IVB, _PIPE_CRC_EXP_3_B_IVB)
#define   PIPE_CRC_EXP_3_MASK_IVB	REG_BIT(22, 0) /* ivb */

/* ivb */
#define _PIPE_CRC_EXP_4_A_IVB		0x6005c
#define _PIPE_CRC_EXP_4_B_IVB		0x6105c
#define PIPE_CRC_EXP_4_IVB(pipe)		_MMIO_PIPE(pipe, _PIPE_CRC_EXP_2_A_IVB, _PIPE_CRC_EXP_2_B_IVB)
#define   PIPE_CRC_EXP_4_MASK_IVB	REG_BIT(22, 0) /* ivb */

/* ivb */
#define _PIPE_CRC_EXP_5_A_IVB		0x60060
#define _PIPE_CRC_EXP_5_B_IVB		0x61060
#define PIPE_CRC_EXP_5_IVB(pipe)		_MMIO_PIPE(pipe, _PIPE_CRC_EXP_2_A_IVB, _PIPE_CRC_EXP_2_B_IVB)
#define   PIPE_CRC_EXP_5_MASK_IVB	REG_BIT(22, 0) /* ivb */

/* ivb */
#define _PIPE_CRC_RES_1_A_IVB		0x60064
#define _PIPE_CRC_RES_1_B_IVB		0x61064
#define PIPE_CRC_RES_1_IVB(pipe)		_MMIO_PIPE((pipe), _PIPE_CRC_RES_1_A_IVB, _PIPE_CRC_RES_1_B_IVB)

/* ivb */
#define _PIPE_CRC_RES_2_A_IVB		0x60068
#define _PIPE_CRC_RES_2_B_IVB		0x61068
#define PIPE_CRC_RES_2_IVB(pipe)		_MMIO_PIPE((pipe), _PIPE_CRC_RES_2_A_IVB, _PIPE_CRC_RES_2_B_IVB)

/* ivb */
#define _PIPE_CRC_RES_3_A_IVB		0x6006c
#define _PIPE_CRC_RES_3_B_IVB		0x6106c
#define PIPE_CRC_RES_3_IVB(pipe)		_MMIO_PIPE((pipe), _PIPE_CRC_RES_3_A_IVB, _PIPE_CRC_RES_3_B_IVB)

/* ivb */
#define _PIPE_CRC_RES_4_A_IVB		0x60070
#define _PIPE_CRC_RES_4_B_IVB		0x61070
#define PIPE_CRC_RES_4_IVB(pipe)		_MMIO_PIPE((pipe), _PIPE_CRC_RES_4_A_IVB, _PIPE_CRC_RES_4_B_IVB)

/* ivb */
#define _PIPE_CRC_RES_5_A_IVB		0x60074
#define _PIPE_CRC_RES_5_B_IVB		0x61074
#define PIPE_CRC_RES_5_IVB(pipe)		_MMIO_PIPE((pipe), _PIPE_CRC_RES_5_A_IVB, _PIPE_CRC_RES_5_B_IVB)

/* hsw+ */
#define _PIPE_CRC_EXP_A_HSW		0x60054
#define _PIPE_CRC_EXP_B_HSW		0x61054
#define PIPE_CRC_EXP_HSW(pipe)			_MMIO_PIPE((pipe), _PIPE_CRC_EXP_A_HSW, _PIPE_CRC_EXP_B_HSW)

/* hsw+ */
#define _PIPE_CRC_RES_A_HSW		0x60064
#define _PIPE_CRC_RES_B_HSW		0x61064
#define PIPE_CRC_RES_HSW(pipe)			_MMIO_PIPE((pipe), _PIPE_CRC_RES_A_HSW, _PIPE_CRC_RES_B_HSW)

#endif /* __INTEL_PIPE_CRC_REGS_H__ */
