// SPDX-License-Identifier: GPL-2.0
#include <linux/dma-direct.h>
#include <linux/export.h>

/* Set this to 1 if there is a HW IOMMU in the system */
int iommu_detected __read_mostly;

const struct dma_map_ops *dma_ops;
EXPORT_SYMBOL(dma_ops);

void *arch_dma_alloc(struct device *dev, size_t size,
		dma_addr_t *dma_handle, gfp_t gfp, unsigned long attrs)
{
	return dma_direct_alloc_pages(dev, size, dma_handle, gfp, attrs);
}

void arch_dma_free(struct device *dev, size_t size, void *cpu_addr,
		dma_addr_t dma_addr, unsigned long attrs)
{
	dma_direct_free_pages(dev, size, cpu_addr, dma_addr, attrs);
}
