#!/bin/awk -f
# SPDX-License-Identifier: GPL-2.0-only
# gen-insn-x86-dat.awk: script to convert data for the insn-x86 test
# Copyright (c) 2015, Intel Corporation.
#

BEGIN {
	print "/*"
	print " * Generated by gen-insn-x86-dat.sh and gen-insn-x86-dat.awk"
	print " * from insn-x86-dat-src.c for inclusion by insn-x86.c"
	print " * Do not change this code."
	print "*/\n"
	op = ""
	branch = ""
	rel = 0
	going = 0
}

/ Start here / {
	going = 1
}

/ Stop here / {
	going = 0
}

/^\s*[0-9a-fA-F]+\:/ {
	if (going) {
		colon_pos = index($0, ":")
		useful_line = substr($0, colon_pos + 1)
		first_pos = match(useful_line, "[0-9a-fA-F]")
		useful_line = substr(useful_line, first_pos)
		gsub("\t", "\\t", useful_line)
		printf "{{"
		len = 0
		for (i = 2; i <= NF; i++) {
			if (match($i, "^[0-9a-fA-F][0-9a-fA-F]$")) {
				printf "0x%s, ", $i
				len += 1
			} else {
				break
			}
		}
		printf "}, %d, %s, \"%s\", \"%s\",", len, rel, op, branch
		printf "\n\"%s\",},\n", useful_line
		op = ""
		branch = ""
		rel = 0
	}
}

/ Expecting: / {
	expecting_str = " Expecting: "
	expecting_len = length(expecting_str)
	expecting_pos = index($0, expecting_str)
	useful_line = substr($0, expecting_pos + expecting_len)
	for (i = 1; i <= NF; i++) {
		if ($i == "Expecting:") {
			i++
			op = $i
			i++
			branch = $i
			i++
			rel = $i
			break
		}
	}
}
