// SPDX-License-Identifier: GPL-2.0-only
/*
 * Hardware modules present on the DRA7xx chips
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - http://www.ti.com
 *
 * Paul Walmsley
 * Benoit Cousson
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#include <linux/io.h>
#include <linux/power/smartreflex.h>

#include <linux/omap-dma.h>

#include "omap_hwmod.h"
#include "omap_hwmod_common_data.h"
#include "cm1_7xx.h"
#include "cm2_7xx.h"
#include "prm7xx.h"
#include "wd_timer.h"
#include "soc.h"

/* Base offset for all DRA7XX interrupts external to MPUSS */
#define DRA7XX_IRQ_GIC_START	32

/* Base offset for all DRA7XX dma requests */
#define DRA7XX_DMA_REQ_START	1


/*
 * IP blocks
 */

/*
 * 'dmm' class
 * instance(s): dmm
 */
static struct omap_hwmod_class dra7xx_dmm_hwmod_class = {
	.name	= "dmm",
};

/* dmm */
static struct omap_hwmod dra7xx_dmm_hwmod = {
	.name		= "dmm",
	.class		= &dra7xx_dmm_hwmod_class,
	.clkdm_name	= "emif_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_EMIF_DMM_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_EMIF_DMM_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'l3' class
 * instance(s): l3_instr, l3_main_1, l3_main_2
 */
static struct omap_hwmod_class dra7xx_l3_hwmod_class = {
	.name	= "l3",
};

/* l3_instr */
static struct omap_hwmod dra7xx_l3_instr_hwmod = {
	.name		= "l3_instr",
	.class		= &dra7xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INSTR_L3_INSTR_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INSTR_L3_INSTR_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* l3_main_1 */
static struct omap_hwmod dra7xx_l3_main_1_hwmod = {
	.name		= "l3_main_1",
	.class		= &dra7xx_l3_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_L3_MAIN_1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_L3_MAIN_1_CONTEXT_OFFSET,
		},
	},
};

/* l3_main_2 */
static struct omap_hwmod dra7xx_l3_main_2_hwmod = {
	.name		= "l3_main_2",
	.class		= &dra7xx_l3_hwmod_class,
	.clkdm_name	= "l3instr_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INSTR_L3_MAIN_2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INSTR_L3_MAIN_2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'l4' class
 * instance(s): l4_cfg, l4_per1, l4_per2, l4_per3, l4_wkup
 */
static struct omap_hwmod_class dra7xx_l4_hwmod_class = {
	.name	= "l4",
};

/* l4_cfg */
static struct omap_hwmod dra7xx_l4_cfg_hwmod = {
	.name		= "l4_cfg",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_L4_CFG_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_L4_CFG_CONTEXT_OFFSET,
		},
	},
};

/* l4_per1 */
static struct omap_hwmod dra7xx_l4_per1_hwmod = {
	.name		= "l4_per1",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_L4_PER1_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_per2 */
static struct omap_hwmod dra7xx_l4_per2_hwmod = {
	.name		= "l4_per2",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_L4_PER2_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_per3 */
static struct omap_hwmod dra7xx_l4_per3_hwmod = {
	.name		= "l4_per3",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "l4per3_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER3_L4_PER3_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/* l4_wkup */
static struct omap_hwmod dra7xx_l4_wkup_hwmod = {
	.name		= "l4_wkup",
	.class		= &dra7xx_l4_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_L4_WKUP_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_L4_WKUP_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'atl' class
 *
 */

static struct omap_hwmod_class dra7xx_atl_hwmod_class = {
	.name	= "atl",
};

/* atl */
static struct omap_hwmod dra7xx_atl_hwmod = {
	.name		= "atl",
	.class		= &dra7xx_atl_hwmod_class,
	.clkdm_name	= "atl_clkdm",
	.main_clk	= "atl_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_ATL_ATL_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_ATL_ATL_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'bb2d' class
 *
 */

static struct omap_hwmod_class dra7xx_bb2d_hwmod_class = {
	.name	= "bb2d",
};

/* bb2d */
static struct omap_hwmod dra7xx_bb2d_hwmod = {
	.name		= "bb2d",
	.class		= &dra7xx_bb2d_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.main_clk	= "dpll_core_h24x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_BB2D_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_DSS_BB2D_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'counter' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_counter_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_counter_hwmod_class = {
	.name	= "counter",
	.sysc	= &dra7xx_counter_sysc,
};

/* counter_32k */
static struct omap_hwmod dra7xx_counter_32k_hwmod = {
	.name		= "counter_32k",
	.class		= &dra7xx_counter_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE,
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_COUNTER_32K_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_COUNTER_32K_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'ctrl_module' class
 *
 */

static struct omap_hwmod_class dra7xx_ctrl_module_hwmod_class = {
	.name	= "ctrl_module",
};

/* ctrl_module_wkup */
static struct omap_hwmod dra7xx_ctrl_module_wkup_hwmod = {
	.name		= "ctrl_module_wkup",
	.class		= &dra7xx_ctrl_module_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.prcm = {
		.omap4 = {
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
};

/*
 * 'gmac' class
 * cpsw/gmac sub system
 */
static struct omap_hwmod_class_sysconfig dra7xx_gmac_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x8,
	.syss_offs	= 0x4,
	.sysc_flags	= (SYSC_HAS_SIDLEMODE | SYSC_HAS_MIDLEMODE |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | MSTANDBY_FORCE |
			   MSTANDBY_NO),
	.sysc_fields	= &omap_hwmod_sysc_type3,
};

static struct omap_hwmod_class dra7xx_gmac_hwmod_class = {
	.name		= "gmac",
	.sysc		= &dra7xx_gmac_sysc,
};

static struct omap_hwmod dra7xx_gmac_hwmod = {
	.name		= "gmac",
	.class		= &dra7xx_gmac_hwmod_class,
	.clkdm_name	= "gmac_clkdm",
	.flags		= (HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY),
	.main_clk	= "dpll_gmac_ck",
	.mpu_rt_idx	= 1,
	.prcm		= {
		.omap4	= {
			.clkctrl_offs	= DRA7XX_CM_GMAC_GMAC_CLKCTRL_OFFSET,
			.context_offs	= DRA7XX_RM_GMAC_GMAC_CONTEXT_OFFSET,
			.modulemode	= MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'mdio' class
 */
static struct omap_hwmod_class dra7xx_mdio_hwmod_class = {
	.name		= "davinci_mdio",
};

static struct omap_hwmod dra7xx_mdio_hwmod = {
	.name		= "davinci_mdio",
	.class		= &dra7xx_mdio_hwmod_class,
	.clkdm_name	= "gmac_clkdm",
	.main_clk	= "dpll_gmac_ck",
};

/*
 * 'dcan' class
 *
 */

static struct omap_hwmod_class dra7xx_dcan_hwmod_class = {
	.name	= "dcan",
};

/* dcan1 */
static struct omap_hwmod dra7xx_dcan1_hwmod = {
	.name		= "dcan1",
	.class		= &dra7xx_dcan_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "dcan1_sys_clk_mux",
	.flags		= HWMOD_CLKDM_NOAUTO,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_DCAN1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_DCAN1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* dcan2 */
static struct omap_hwmod dra7xx_dcan2_hwmod = {
	.name		= "dcan2",
	.class		= &dra7xx_dcan_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "sys_clkin1",
	.flags		= HWMOD_CLKDM_NOAUTO,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_DCAN2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_DCAN2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* pwmss  */
static struct omap_hwmod_class_sysconfig dra7xx_epwmss_sysc = {
	.rev_offs	= 0x0,
	.sysc_offs	= 0x4,
	.sysc_flags	= SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			  SYSC_HAS_RESET_STATUS,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

/*
 * epwmss class
 */
static struct omap_hwmod_class dra7xx_epwmss_hwmod_class = {
	.name		= "epwmss",
	.sysc		= &dra7xx_epwmss_sysc,
};

/* epwmss0 */
static struct omap_hwmod dra7xx_epwmss0_hwmod = {
	.name		= "epwmss0",
	.class		= &dra7xx_epwmss_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "l4_root_clk_div",
	.prcm		= {
		.omap4	= {
			.modulemode	= MODULEMODE_SWCTRL,
			.clkctrl_offs	= DRA7XX_CM_L4PER2_PWMSS1_CLKCTRL_OFFSET,
			.context_offs	= DRA7XX_RM_L4PER2_PWMSS1_CONTEXT_OFFSET,
		},
	},
};

/* epwmss1 */
static struct omap_hwmod dra7xx_epwmss1_hwmod = {
	.name		= "epwmss1",
	.class		= &dra7xx_epwmss_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "l4_root_clk_div",
	.prcm		= {
		.omap4	= {
			.modulemode	= MODULEMODE_SWCTRL,
			.clkctrl_offs	= DRA7XX_CM_L4PER2_PWMSS2_CLKCTRL_OFFSET,
			.context_offs	= DRA7XX_RM_L4PER2_PWMSS2_CONTEXT_OFFSET,
		},
	},
};

/* epwmss2 */
static struct omap_hwmod dra7xx_epwmss2_hwmod = {
	.name		= "epwmss2",
	.class		= &dra7xx_epwmss_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "l4_root_clk_div",
	.prcm		= {
		.omap4	= {
			.modulemode	= MODULEMODE_SWCTRL,
			.clkctrl_offs	= DRA7XX_CM_L4PER2_PWMSS3_CLKCTRL_OFFSET,
			.context_offs	= DRA7XX_RM_L4PER2_PWMSS3_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'dma' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_dma_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x002c,
	.syss_offs	= 0x0028,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_EMUFREE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_dma_hwmod_class = {
	.name	= "dma",
	.sysc	= &dra7xx_dma_sysc,
};

/* dma dev_attr */
static struct omap_dma_dev_attr dma_dev_attr = {
	.dev_caps	= RESERVE_CHANNEL | DMA_LINKED_LCH | GLOBAL_PRIORITY |
			  IS_CSSA_32 | IS_CDSA_32 | IS_RW_PRIORITY,
	.lch_count	= 32,
};

/* dma_system */
static struct omap_hwmod dra7xx_dma_system_hwmod = {
	.name		= "dma_system",
	.class		= &dra7xx_dma_hwmod_class,
	.clkdm_name	= "dma_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DMA_DMA_SYSTEM_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_DMA_DMA_SYSTEM_CONTEXT_OFFSET,
		},
	},
	.dev_attr	= &dma_dev_attr,
};

/*
 * 'tpcc' class
 *
 */
static struct omap_hwmod_class dra7xx_tpcc_hwmod_class = {
	.name		= "tpcc",
};

static struct omap_hwmod dra7xx_tpcc_hwmod = {
	.name		= "tpcc",
	.class		= &dra7xx_tpcc_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_TPCC_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_TPCC_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'tptc' class
 *
 */
static struct omap_hwmod_class dra7xx_tptc_hwmod_class = {
	.name		= "tptc",
};

/* tptc0 */
static struct omap_hwmod dra7xx_tptc0_hwmod = {
	.name		= "tptc0",
	.class		= &dra7xx_tptc_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.main_clk	= "l3_iclk_div",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_TPTC1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_TPTC1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* tptc1 */
static struct omap_hwmod dra7xx_tptc1_hwmod = {
	.name		= "tptc1",
	.class		= &dra7xx_tptc_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.main_clk	= "l3_iclk_div",
	.prcm		= {
		.omap4	= {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_TPTC2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_TPTC2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'dss' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_dss_sysc = {
	.rev_offs	= 0x0000,
	.syss_offs	= 0x0014,
	.sysc_flags	= SYSS_HAS_RESET_STATUS,
};

static struct omap_hwmod_class dra7xx_dss_hwmod_class = {
	.name	= "dss",
	.sysc	= &dra7xx_dss_sysc,
	.reset	= omap_dss_reset,
};

/* dss */
static struct omap_hwmod_opt_clk dss_opt_clks[] = {
	{ .role = "dss_clk", .clk = "dss_dss_clk" },
	{ .role = "hdmi_phy_clk", .clk = "dss_48mhz_clk" },
	{ .role = "32khz_clk", .clk = "dss_32khz_clk" },
	{ .role = "video2_clk", .clk = "dss_video2_clk" },
	{ .role = "video1_clk", .clk = "dss_video1_clk" },
	{ .role = "hdmi_clk", .clk = "dss_hdmi_clk" },
	{ .role = "hdcp_clk", .clk = "dss_deshdcp_clk" },
};

static struct omap_hwmod dra7xx_dss_hwmod = {
	.name		= "dss_core",
	.class		= &dra7xx_dss_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.flags		= HWMOD_CONTROL_OPT_CLKS_IN_RESET,
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_DSS_DSS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= dss_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_opt_clks),
};

/*
 * 'dispc' class
 * display controller
 */

static struct omap_hwmod_class_sysconfig dra7xx_dispc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_ENAWAKEUP | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   MSTANDBY_FORCE | MSTANDBY_NO | MSTANDBY_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_dispc_hwmod_class = {
	.name	= "dispc",
	.sysc	= &dra7xx_dispc_sysc,
};

/* dss_dispc */
/* dss_dispc dev_attr */
static struct omap_dss_dispc_dev_attr dss_dispc_dev_attr = {
	.has_framedonetv_irq	= 1,
	.manager_count		= 4,
};

static struct omap_hwmod dra7xx_dss_dispc_hwmod = {
	.name		= "dss_dispc",
	.class		= &dra7xx_dispc_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.main_clk	= "dss_dss_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
	.dev_attr	= &dss_dispc_dev_attr,
	.parent_hwmod	= &dra7xx_dss_hwmod,
};

/*
 * 'hdmi' class
 * hdmi controller
 */

static struct omap_hwmod_class_sysconfig dra7xx_hdmi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_hdmi_hwmod_class = {
	.name	= "hdmi",
	.sysc	= &dra7xx_hdmi_sysc,
};

/* dss_hdmi */

static struct omap_hwmod_opt_clk dss_hdmi_opt_clks[] = {
	{ .role = "sys_clk", .clk = "dss_hdmi_clk" },
};

static struct omap_hwmod dra7xx_dss_hdmi_hwmod = {
	.name		= "dss_hdmi",
	.class		= &dra7xx_hdmi_hwmod_class,
	.clkdm_name	= "dss_clkdm",
	.main_clk	= "dss_48mhz_clk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_DSS_DSS_CLKCTRL_OFFSET,
			.flags = HWMOD_OMAP4_NO_CONTEXT_LOSS_BIT,
		},
	},
	.opt_clks	= dss_hdmi_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(dss_hdmi_opt_clks),
	.parent_hwmod	= &dra7xx_dss_hwmod,
};

/* AES (the 'P' (public) device) */
static struct omap_hwmod_class_sysconfig dra7xx_aes_sysc = {
	.rev_offs	= 0x0080,
	.sysc_offs	= 0x0084,
	.syss_offs	= 0x0088,
	.sysc_flags	= SYSS_HAS_RESET_STATUS,
};

static struct omap_hwmod_class dra7xx_aes_hwmod_class = {
	.name	= "aes",
	.sysc	= &dra7xx_aes_sysc,
};

/* AES1 */
static struct omap_hwmod dra7xx_aes1_hwmod = {
	.name		= "aes1",
	.class		= &dra7xx_aes_hwmod_class,
	.clkdm_name	= "l4sec_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4SEC_AES1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4SEC_AES1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* AES2 */
static struct omap_hwmod dra7xx_aes2_hwmod = {
	.name		= "aes2",
	.class		= &dra7xx_aes_hwmod_class,
	.clkdm_name	= "l4sec_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4SEC_AES2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4SEC_AES2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* sha0 HIB2 (the 'P' (public) device) */
static struct omap_hwmod_class_sysconfig dra7xx_sha0_sysc = {
	.rev_offs	= 0x100,
	.sysc_offs	= 0x110,
	.syss_offs	= 0x114,
	.sysc_flags	= SYSS_HAS_RESET_STATUS,
};

static struct omap_hwmod_class dra7xx_sha0_hwmod_class = {
	.name		= "sham",
	.sysc		= &dra7xx_sha0_sysc,
};

struct omap_hwmod dra7xx_sha0_hwmod = {
	.name		= "sham",
	.class		= &dra7xx_sha0_hwmod_class,
	.clkdm_name	= "l4sec_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm		= {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4SEC_SHA2MD51_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4SEC_SHA2MD51_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'elm' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_elm_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_CLOCKACTIVITY |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_elm_hwmod_class = {
	.name	= "elm",
	.sysc	= &dra7xx_elm_sysc,
};

/* elm */

static struct omap_hwmod dra7xx_elm_hwmod = {
	.name		= "elm",
	.class		= &dra7xx_elm_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_ELM_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_ELM_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'gpmc' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_gpmc_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_gpmc_hwmod_class = {
	.name	= "gpmc",
	.sysc	= &dra7xx_gpmc_sysc,
};

/* gpmc */

static struct omap_hwmod dra7xx_gpmc_hwmod = {
	.name		= "gpmc",
	.class		= &dra7xx_gpmc_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	/* Skip reset for CONFIG_OMAP_GPMC_DEBUG for bootloader timings */
	.flags		= DEBUG_OMAP_GPMC_HWMOD_FLAGS,
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_GPMC_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_GPMC_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'hdq1w' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_hdq1w_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0014,
	.syss_offs	= 0x0018,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_hdq1w_hwmod_class = {
	.name	= "hdq1w",
	.sysc	= &dra7xx_hdq1w_sysc,
};

/* hdq1w */

static struct omap_hwmod dra7xx_hdq1w_hwmod = {
	.name		= "hdq1w",
	.class		= &dra7xx_hdq1w_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.flags		= HWMOD_INIT_NO_RESET,
	.main_clk	= "func_12m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_HDQ1W_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_HDQ1W_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'mailbox' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_mailbox_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_RESET_STATUS | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_mailbox_hwmod_class = {
	.name	= "mailbox",
	.sysc	= &dra7xx_mailbox_sysc,
};

/* mailbox1 */
static struct omap_hwmod dra7xx_mailbox1_hwmod = {
	.name		= "mailbox1",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX1_CONTEXT_OFFSET,
		},
	},
};

/* mailbox2 */
static struct omap_hwmod dra7xx_mailbox2_hwmod = {
	.name		= "mailbox2",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX2_CONTEXT_OFFSET,
		},
	},
};

/* mailbox3 */
static struct omap_hwmod dra7xx_mailbox3_hwmod = {
	.name		= "mailbox3",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX3_CONTEXT_OFFSET,
		},
	},
};

/* mailbox4 */
static struct omap_hwmod dra7xx_mailbox4_hwmod = {
	.name		= "mailbox4",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX4_CONTEXT_OFFSET,
		},
	},
};

/* mailbox5 */
static struct omap_hwmod dra7xx_mailbox5_hwmod = {
	.name		= "mailbox5",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX5_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX5_CONTEXT_OFFSET,
		},
	},
};

/* mailbox6 */
static struct omap_hwmod dra7xx_mailbox6_hwmod = {
	.name		= "mailbox6",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX6_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX6_CONTEXT_OFFSET,
		},
	},
};

/* mailbox7 */
static struct omap_hwmod dra7xx_mailbox7_hwmod = {
	.name		= "mailbox7",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX7_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX7_CONTEXT_OFFSET,
		},
	},
};

/* mailbox8 */
static struct omap_hwmod dra7xx_mailbox8_hwmod = {
	.name		= "mailbox8",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX8_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX8_CONTEXT_OFFSET,
		},
	},
};

/* mailbox9 */
static struct omap_hwmod dra7xx_mailbox9_hwmod = {
	.name		= "mailbox9",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX9_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX9_CONTEXT_OFFSET,
		},
	},
};

/* mailbox10 */
static struct omap_hwmod dra7xx_mailbox10_hwmod = {
	.name		= "mailbox10",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX10_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX10_CONTEXT_OFFSET,
		},
	},
};

/* mailbox11 */
static struct omap_hwmod dra7xx_mailbox11_hwmod = {
	.name		= "mailbox11",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX11_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX11_CONTEXT_OFFSET,
		},
	},
};

/* mailbox12 */
static struct omap_hwmod dra7xx_mailbox12_hwmod = {
	.name		= "mailbox12",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX12_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX12_CONTEXT_OFFSET,
		},
	},
};

/* mailbox13 */
static struct omap_hwmod dra7xx_mailbox13_hwmod = {
	.name		= "mailbox13",
	.class		= &dra7xx_mailbox_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_MAILBOX13_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_MAILBOX13_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'mcspi' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_mcspi_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_mcspi_hwmod_class = {
	.name	= "mcspi",
	.sysc	= &dra7xx_mcspi_sysc,
};

/* mcspi1 */
static struct omap_hwmod dra7xx_mcspi1_hwmod = {
	.name		= "mcspi1",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* mcspi2 */
static struct omap_hwmod dra7xx_mcspi2_hwmod = {
	.name		= "mcspi2",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* mcspi3 */
static struct omap_hwmod dra7xx_mcspi3_hwmod = {
	.name		= "mcspi3",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* mcspi4 */
static struct omap_hwmod dra7xx_mcspi4_hwmod = {
	.name		= "mcspi4",
	.class		= &dra7xx_mcspi_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "func_48m_fclk",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_MCSPI4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_MCSPI4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'mcasp' class
 *
 */
static struct omap_hwmod_class_sysconfig dra7xx_mcasp_sysc = {
	.rev_offs	= 0,
	.sysc_offs	= 0x0004,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type3,
};

static struct omap_hwmod_class dra7xx_mcasp_hwmod_class = {
	.name	= "mcasp",
	.sysc	= &dra7xx_mcasp_sysc,
};

/* mcasp1 */
static struct omap_hwmod_opt_clk mcasp1_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp1_ahclkx_mux" },
	{ .role = "ahclkr", .clk = "mcasp1_ahclkr_mux" },
};

static struct omap_hwmod dra7xx_mcasp1_hwmod = {
	.name		= "mcasp1",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "mcasp1_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_MCASP1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_MCASP1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp1_opt_clks),
};

/* mcasp2 */
static struct omap_hwmod_opt_clk mcasp2_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp2_ahclkx_mux" },
	{ .role = "ahclkr", .clk = "mcasp2_ahclkr_mux" },
};

static struct omap_hwmod dra7xx_mcasp2_hwmod = {
	.name		= "mcasp2",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "mcasp2_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_MCASP2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_MCASP2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp2_opt_clks),
};

/* mcasp3 */
static struct omap_hwmod_opt_clk mcasp3_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp3_ahclkx_mux" },
};

static struct omap_hwmod dra7xx_mcasp3_hwmod = {
	.name		= "mcasp3",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "mcasp3_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_MCASP3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_MCASP3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp3_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp3_opt_clks),
};

/* mcasp4 */
static struct omap_hwmod_opt_clk mcasp4_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp4_ahclkx_mux" },
};

static struct omap_hwmod dra7xx_mcasp4_hwmod = {
	.name		= "mcasp4",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "mcasp4_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_MCASP4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_MCASP4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp4_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp4_opt_clks),
};

/* mcasp5 */
static struct omap_hwmod_opt_clk mcasp5_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp5_ahclkx_mux" },
};

static struct omap_hwmod dra7xx_mcasp5_hwmod = {
	.name		= "mcasp5",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "mcasp5_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_MCASP5_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_MCASP5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp5_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp5_opt_clks),
};

/* mcasp6 */
static struct omap_hwmod_opt_clk mcasp6_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp6_ahclkx_mux" },
};

static struct omap_hwmod dra7xx_mcasp6_hwmod = {
	.name		= "mcasp6",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "mcasp6_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_MCASP6_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_MCASP6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp6_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp6_opt_clks),
};

/* mcasp7 */
static struct omap_hwmod_opt_clk mcasp7_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp7_ahclkx_mux" },
};

static struct omap_hwmod dra7xx_mcasp7_hwmod = {
	.name		= "mcasp7",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "mcasp7_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_MCASP7_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_MCASP7_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp7_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp7_opt_clks),
};

/* mcasp8 */
static struct omap_hwmod_opt_clk mcasp8_opt_clks[] = {
	{ .role = "ahclkx", .clk = "mcasp8_ahclkx_mux" },
};

static struct omap_hwmod dra7xx_mcasp8_hwmod = {
	.name		= "mcasp8",
	.class		= &dra7xx_mcasp_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "mcasp8_aux_gfclk_mux",
	.flags		= HWMOD_OPT_CLKS_NEEDED,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_MCASP8_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_MCASP8_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.opt_clks	= mcasp8_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(mcasp8_opt_clks),
};

/*
 * 'mpu' class
 *
 */

static struct omap_hwmod_class dra7xx_mpu_hwmod_class = {
	.name	= "mpu",
};

/* mpu */
static struct omap_hwmod dra7xx_mpu_hwmod = {
	.name		= "mpu",
	.class		= &dra7xx_mpu_hwmod_class,
	.clkdm_name	= "mpu_clkdm",
	.flags		= HWMOD_INIT_NO_IDLE | HWMOD_INIT_NO_RESET,
	.main_clk	= "dpll_mpu_m2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_MPU_MPU_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_MPU_MPU_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'ocp2scp' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_ocp2scp_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_ocp2scp_hwmod_class = {
	.name	= "ocp2scp",
	.sysc	= &dra7xx_ocp2scp_sysc,
};

/* ocp2scp1 */
static struct omap_hwmod dra7xx_ocp2scp1_hwmod = {
	.name		= "ocp2scp1",
	.class		= &dra7xx_ocp2scp_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "l4_root_clk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_OCP2SCP1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_OCP2SCP1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* ocp2scp3 */
static struct omap_hwmod dra7xx_ocp2scp3_hwmod = {
	.name		= "ocp2scp3",
	.class		= &dra7xx_ocp2scp_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "l4_root_clk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_OCP2SCP3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_OCP2SCP3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'PCIE' class
 *
 */

/*
 * As noted in documentation for _reset() in omap_hwmod.c, the stock reset
 * functionality of OMAP HWMOD layer does not deassert the hardreset lines
 * associated with an IP automatically leaving the driver to handle that
 * by itself. This does not work for PCIeSS which needs the reset lines
 * deasserted for the driver to start accessing registers.
 *
 * We use a PCIeSS HWMOD class specific reset handler to deassert the hardreset
 * lines after asserting them.
 */
int dra7xx_pciess_reset(struct omap_hwmod *oh)
{
	int i;

	for (i = 0; i < oh->rst_lines_cnt; i++) {
		omap_hwmod_assert_hardreset(oh, oh->rst_lines[i].name);
		omap_hwmod_deassert_hardreset(oh, oh->rst_lines[i].name);
	}

	return 0;
}

static struct omap_hwmod_class dra7xx_pciess_hwmod_class = {
	.name	= "pcie",
	.reset	= dra7xx_pciess_reset,
};

/* pcie1 */
static struct omap_hwmod_rst_info dra7xx_pciess1_resets[] = {
	{ .name = "pcie", .rst_shift = 0 },
};

static struct omap_hwmod dra7xx_pciess1_hwmod = {
	.name		= "pcie1",
	.class		= &dra7xx_pciess_hwmod_class,
	.clkdm_name	= "pcie_clkdm",
	.rst_lines	= dra7xx_pciess1_resets,
	.rst_lines_cnt	= ARRAY_SIZE(dra7xx_pciess1_resets),
	.main_clk	= "l4_root_clk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_PCIESS1_CLKCTRL_OFFSET,
			.rstctrl_offs = DRA7XX_RM_L3INIT_PCIESS_RSTCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_PCIESS1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* pcie2 */
static struct omap_hwmod_rst_info dra7xx_pciess2_resets[] = {
	{ .name = "pcie", .rst_shift = 1 },
};

/* pcie2 */
static struct omap_hwmod dra7xx_pciess2_hwmod = {
	.name		= "pcie2",
	.class		= &dra7xx_pciess_hwmod_class,
	.clkdm_name	= "pcie_clkdm",
	.rst_lines	= dra7xx_pciess2_resets,
	.rst_lines_cnt	= ARRAY_SIZE(dra7xx_pciess2_resets),
	.main_clk	= "l4_root_clk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_PCIESS2_CLKCTRL_OFFSET,
			.rstctrl_offs = DRA7XX_RM_L3INIT_PCIESS_RSTCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_PCIESS2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'qspi' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_qspi_sysc = {
	.rev_offs	= 0,
	.sysc_offs	= 0x0010,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_qspi_hwmod_class = {
	.name	= "qspi",
	.sysc	= &dra7xx_qspi_sysc,
};

/* qspi */
static struct omap_hwmod dra7xx_qspi_hwmod = {
	.name		= "qspi",
	.class		= &dra7xx_qspi_hwmod_class,
	.clkdm_name	= "l4per2_clkdm",
	.main_clk	= "qspi_gfclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER2_QSPI_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER2_QSPI_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'rtcss' class
 *
 */
static struct omap_hwmod_class_sysconfig dra7xx_rtcss_sysc = {
	.rev_offs	= 0x0074,
	.sysc_offs	= 0x0078,
	.sysc_flags	= SYSC_HAS_SIDLEMODE,
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type3,
};

static struct omap_hwmod_class dra7xx_rtcss_hwmod_class = {
	.name	= "rtcss",
	.sysc	= &dra7xx_rtcss_sysc,
	.unlock	= &omap_hwmod_rtc_unlock,
	.lock	= &omap_hwmod_rtc_lock,
};

/* rtcss */
static struct omap_hwmod dra7xx_rtcss_hwmod = {
	.name		= "rtcss",
	.class		= &dra7xx_rtcss_hwmod_class,
	.clkdm_name	= "rtc_clkdm",
	.main_clk	= "sys_32k_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_RTC_RTCSS_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_RTC_RTCSS_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'sata' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_sata_sysc = {
	.rev_offs	= 0x00fc,
	.sysc_offs	= 0x0000,
	.sysc_flags	= (SYSC_HAS_MIDLEMODE | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_sata_hwmod_class = {
	.name	= "sata",
	.sysc	= &dra7xx_sata_sysc,
};

/* sata */

static struct omap_hwmod dra7xx_sata_hwmod = {
	.name		= "sata",
	.class		= &dra7xx_sata_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.flags		= HWMOD_SWSUP_SIDLE | HWMOD_SWSUP_MSTANDBY,
	.main_clk	= "func_48m_fclk",
	.mpu_rt_idx	= 1,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_SATA_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_SATA_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/*
 * 'smartreflex' class
 *
 */

/* The IP is not compliant to type1 / type2 scheme */
static struct omap_hwmod_class_sysconfig dra7xx_smartreflex_sysc = {
	.rev_offs	= -ENODEV,
	.sysc_offs	= 0x0038,
	.sysc_flags	= (SYSC_HAS_ENAWAKEUP | SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap36xx_sr_sysc_fields,
};

static struct omap_hwmod_class dra7xx_smartreflex_hwmod_class = {
	.name	= "smartreflex",
	.sysc	= &dra7xx_smartreflex_sysc,
};

/* smartreflex_core */
/* smartreflex_core dev_attr */
static struct omap_smartreflex_dev_attr smartreflex_core_dev_attr = {
	.sensor_voltdm_name	= "core",
};

static struct omap_hwmod dra7xx_smartreflex_core_hwmod = {
	.name		= "smartreflex_core",
	.class		= &dra7xx_smartreflex_hwmod_class,
	.clkdm_name	= "coreaon_clkdm",
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_COREAON_SMARTREFLEX_CORE_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_COREAON_SMARTREFLEX_CORE_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &smartreflex_core_dev_attr,
};

/* smartreflex_mpu */
/* smartreflex_mpu dev_attr */
static struct omap_smartreflex_dev_attr smartreflex_mpu_dev_attr = {
	.sensor_voltdm_name	= "mpu",
};

static struct omap_hwmod dra7xx_smartreflex_mpu_hwmod = {
	.name		= "smartreflex_mpu",
	.class		= &dra7xx_smartreflex_hwmod_class,
	.clkdm_name	= "coreaon_clkdm",
	.main_clk	= "wkupaon_iclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_COREAON_SMARTREFLEX_MPU_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_COREAON_SMARTREFLEX_MPU_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
	.dev_attr	= &smartreflex_mpu_dev_attr,
};

/*
 * 'spinlock' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_spinlock_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_AUTOIDLE | SYSC_HAS_ENAWAKEUP |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET |
			   SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_spinlock_hwmod_class = {
	.name	= "spinlock",
	.sysc	= &dra7xx_spinlock_sysc,
};

/* spinlock */
static struct omap_hwmod dra7xx_spinlock_hwmod = {
	.name		= "spinlock",
	.class		= &dra7xx_spinlock_hwmod_class,
	.clkdm_name	= "l4cfg_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4CFG_SPINLOCK_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4CFG_SPINLOCK_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'timer' class
 *
 * This class contains several variants: ['timer_1ms', 'timer_secure',
 * 'timer']
 */

static struct omap_hwmod_class_sysconfig dra7xx_timer_1ms_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_timer_1ms_hwmod_class = {
	.name	= "timer",
	.sysc	= &dra7xx_timer_1ms_sysc,
};

static struct omap_hwmod_class_sysconfig dra7xx_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_RESET_STATUS |
			   SYSC_HAS_SIDLEMODE | SYSC_HAS_SOFTRESET),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_timer_hwmod_class = {
	.name	= "timer",
	.sysc	= &dra7xx_timer_sysc,
};

/* timer1 */
static struct omap_hwmod dra7xx_timer1_hwmod = {
	.name		= "timer1",
	.class		= &dra7xx_timer_1ms_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "timer1_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_TIMER1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_TIMER1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer2 */
static struct omap_hwmod dra7xx_timer2_hwmod = {
	.name		= "timer2",
	.class		= &dra7xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer2_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer3 */
static struct omap_hwmod dra7xx_timer3_hwmod = {
	.name		= "timer3",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer3_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer4 */
static struct omap_hwmod dra7xx_timer4_hwmod = {
	.name		= "timer4",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer4_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer5 */
static struct omap_hwmod dra7xx_timer5_hwmod = {
	.name		= "timer5",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer5_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER5_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER5_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer6 */
static struct omap_hwmod dra7xx_timer6_hwmod = {
	.name		= "timer6",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer6_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER6_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER6_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer7 */
static struct omap_hwmod dra7xx_timer7_hwmod = {
	.name		= "timer7",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer7_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER7_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER7_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer8 */
static struct omap_hwmod dra7xx_timer8_hwmod = {
	.name		= "timer8",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "ipu_clkdm",
	.main_clk	= "timer8_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_IPU_TIMER8_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_IPU_TIMER8_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer9 */
static struct omap_hwmod dra7xx_timer9_hwmod = {
	.name		= "timer9",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer9_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER9_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER9_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer10 */
static struct omap_hwmod dra7xx_timer10_hwmod = {
	.name		= "timer10",
	.class		= &dra7xx_timer_1ms_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer10_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER10_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER10_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer11 */
static struct omap_hwmod dra7xx_timer11_hwmod = {
	.name		= "timer11",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per_clkdm",
	.main_clk	= "timer11_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER_TIMER11_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER_TIMER11_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer12 */
static struct omap_hwmod dra7xx_timer12_hwmod = {
	.name		= "timer12",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "secure_32k_clk_src_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_TIMER12_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_TIMER12_CONTEXT_OFFSET,
		},
	},
};

/* timer13 */
static struct omap_hwmod dra7xx_timer13_hwmod = {
	.name		= "timer13",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per3_clkdm",
	.main_clk	= "timer13_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER3_TIMER13_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER3_TIMER13_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer14 */
static struct omap_hwmod dra7xx_timer14_hwmod = {
	.name		= "timer14",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per3_clkdm",
	.main_clk	= "timer14_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER3_TIMER14_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER3_TIMER14_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer15 */
static struct omap_hwmod dra7xx_timer15_hwmod = {
	.name		= "timer15",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per3_clkdm",
	.main_clk	= "timer15_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER3_TIMER15_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER3_TIMER15_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* timer16 */
static struct omap_hwmod dra7xx_timer16_hwmod = {
	.name		= "timer16",
	.class		= &dra7xx_timer_hwmod_class,
	.clkdm_name	= "l4per3_clkdm",
	.main_clk	= "timer16_gfclk_mux",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4PER3_TIMER16_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4PER3_TIMER16_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};

/* DES (the 'P' (public) device) */
static struct omap_hwmod_class_sysconfig dra7xx_des_sysc = {
	.rev_offs	= 0x0030,
	.sysc_offs	= 0x0034,
	.syss_offs	= 0x0038,
	.sysc_flags	= SYSS_HAS_RESET_STATUS,
};

static struct omap_hwmod_class dra7xx_des_hwmod_class = {
	.name	= "des",
	.sysc	= &dra7xx_des_sysc,
};

/* DES */
static struct omap_hwmod dra7xx_des_hwmod = {
	.name		= "des",
	.class		= &dra7xx_des_hwmod_class,
	.clkdm_name	= "l4sec_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4SEC_DES3DES_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4SEC_DES3DES_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* rng */
static struct omap_hwmod_class_sysconfig dra7xx_rng_sysc = {
	.rev_offs       = 0x1fe0,
	.sysc_offs      = 0x1fe4,
	.sysc_flags     = SYSC_HAS_AUTOIDLE | SYSC_HAS_SIDLEMODE,
	.idlemodes      = SIDLE_FORCE | SIDLE_NO,
	.sysc_fields    = &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_rng_hwmod_class = {
	.name           = "rng",
	.sysc           = &dra7xx_rng_sysc,
};

static struct omap_hwmod dra7xx_rng_hwmod = {
	.name           = "rng",
	.class          = &dra7xx_rng_hwmod_class,
	.flags		= HWMOD_SWSUP_SIDLE,
	.clkdm_name     = "l4sec_clkdm",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L4SEC_RNG_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L4SEC_RNG_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'usb_otg_ss' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_usb_otg_ss_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.sysc_flags	= (SYSC_HAS_DMADISABLE | SYSC_HAS_MIDLEMODE |
			   SYSC_HAS_SIDLEMODE),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP | MSTANDBY_FORCE | MSTANDBY_NO |
			   MSTANDBY_SMART | MSTANDBY_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type2,
};

static struct omap_hwmod_class dra7xx_usb_otg_ss_hwmod_class = {
	.name	= "usb_otg_ss",
	.sysc	= &dra7xx_usb_otg_ss_sysc,
};

/* usb_otg_ss1 */
static struct omap_hwmod_opt_clk usb_otg_ss1_opt_clks[] = {
	{ .role = "refclk960m", .clk = "usb_otg_ss1_refclk960m" },
};

static struct omap_hwmod dra7xx_usb_otg_ss1_hwmod = {
	.name		= "usb_otg_ss1",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.flags		= HWMOD_CLKDM_NOAUTO,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS1_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_otg_ss1_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_otg_ss1_opt_clks),
};

/* usb_otg_ss2 */
static struct omap_hwmod_opt_clk usb_otg_ss2_opt_clks[] = {
	{ .role = "refclk960m", .clk = "usb_otg_ss2_refclk960m" },
};

static struct omap_hwmod dra7xx_usb_otg_ss2_hwmod = {
	.name		= "usb_otg_ss2",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.flags		= HWMOD_CLKDM_NOAUTO,
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
	.opt_clks	= usb_otg_ss2_opt_clks,
	.opt_clks_cnt	= ARRAY_SIZE(usb_otg_ss2_opt_clks),
};

/* usb_otg_ss3 */
static struct omap_hwmod dra7xx_usb_otg_ss3_hwmod = {
	.name		= "usb_otg_ss3",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS3_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS3_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/* usb_otg_ss4 */
static struct omap_hwmod dra7xx_usb_otg_ss4_hwmod = {
	.name		= "usb_otg_ss4",
	.class		= &dra7xx_usb_otg_ss_hwmod_class,
	.clkdm_name	= "l3init_clkdm",
	.main_clk	= "dpll_core_h13x2_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3INIT_USB_OTG_SS4_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3INIT_USB_OTG_SS4_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_HWCTRL,
		},
	},
};

/*
 * 'vcp' class
 *
 */

static struct omap_hwmod_class dra7xx_vcp_hwmod_class = {
	.name	= "vcp",
};

/* vcp1 */
static struct omap_hwmod dra7xx_vcp1_hwmod = {
	.name		= "vcp1",
	.class		= &dra7xx_vcp_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_VCP1_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_VCP1_CONTEXT_OFFSET,
		},
	},
};

/* vcp2 */
static struct omap_hwmod dra7xx_vcp2_hwmod = {
	.name		= "vcp2",
	.class		= &dra7xx_vcp_hwmod_class,
	.clkdm_name	= "l3main1_clkdm",
	.main_clk	= "l3_iclk_div",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_L3MAIN1_VCP2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_L3MAIN1_VCP2_CONTEXT_OFFSET,
		},
	},
};

/*
 * 'wd_timer' class
 *
 */

static struct omap_hwmod_class_sysconfig dra7xx_wd_timer_sysc = {
	.rev_offs	= 0x0000,
	.sysc_offs	= 0x0010,
	.syss_offs	= 0x0014,
	.sysc_flags	= (SYSC_HAS_EMUFREE | SYSC_HAS_SIDLEMODE |
			   SYSC_HAS_SOFTRESET | SYSS_HAS_RESET_STATUS),
	.idlemodes	= (SIDLE_FORCE | SIDLE_NO | SIDLE_SMART |
			   SIDLE_SMART_WKUP),
	.sysc_fields	= &omap_hwmod_sysc_type1,
};

static struct omap_hwmod_class dra7xx_wd_timer_hwmod_class = {
	.name		= "wd_timer",
	.sysc		= &dra7xx_wd_timer_sysc,
	.pre_shutdown	= &omap2_wd_timer_disable,
	.reset		= &omap2_wd_timer_reset,
};

/* wd_timer2 */
static struct omap_hwmod dra7xx_wd_timer2_hwmod = {
	.name		= "wd_timer2",
	.class		= &dra7xx_wd_timer_hwmod_class,
	.clkdm_name	= "wkupaon_clkdm",
	.main_clk	= "sys_32k_ck",
	.prcm = {
		.omap4 = {
			.clkctrl_offs = DRA7XX_CM_WKUPAON_WD_TIMER2_CLKCTRL_OFFSET,
			.context_offs = DRA7XX_RM_WKUPAON_WD_TIMER2_CONTEXT_OFFSET,
			.modulemode   = MODULEMODE_SWCTRL,
		},
	},
};


/*
 * Interfaces
 */

/* l3_main_1 -> dmm */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__dmm = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_dmm_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_SDMA,
};

/* l3_main_2 -> l3_instr */
static struct omap_hwmod_ocp_if dra7xx_l3_main_2__l3_instr = {
	.master		= &dra7xx_l3_main_2_hwmod,
	.slave		= &dra7xx_l3_instr_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> l3_main_1 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__l3_main_1 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* mpu -> l3_main_1 */
static struct omap_hwmod_ocp_if dra7xx_mpu__l3_main_1 = {
	.master		= &dra7xx_mpu_hwmod,
	.slave		= &dra7xx_l3_main_1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_1 -> l3_main_2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l3_main_2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l4_cfg -> l3_main_2 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__l3_main_2 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_l3_main_2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_cfg */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_cfg = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_cfg_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_per1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_per1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_per1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_per2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_per2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_per2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_per3 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_per3 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_per3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> l4_wkup */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__l4_wkup = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_l4_wkup_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> atl */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__atl = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_atl_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> bb2d */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__bb2d = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_bb2d_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> counter_32k */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__counter_32k = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_counter_32k_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> ctrl_module_wkup */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__ctrl_module_wkup = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_ctrl_module_wkup_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

static struct omap_hwmod_ocp_if dra7xx_l4_per2__cpgmac0 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_gmac_hwmod,
	.clk		= "dpll_gmac_ck",
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if dra7xx_gmac__mdio = {
	.master		= &dra7xx_gmac_hwmod,
	.slave		= &dra7xx_mdio_hwmod,
	.user		= OCP_USER_MPU,
};

/* l4_wkup -> dcan1 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__dcan1 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_dcan1_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> dcan2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__dcan2 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_dcan2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> dma_system */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__dma_system = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_dma_system_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> tpcc */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__tpcc = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_tpcc_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_1 -> tptc0 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__tptc0 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_tptc0_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_1 -> tptc1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__tptc1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_tptc1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU,
};

/* l3_main_1 -> dss */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__dss = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_dss_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> dispc */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__dispc = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_dss_dispc_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> dispc */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__hdmi = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_dss_hdmi_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> aes1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__aes1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_aes1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> aes2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__aes2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_aes2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> sha0 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__sha0 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_sha0_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp1 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp1_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> mcasp1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__mcasp1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_mcasp1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp2 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp2_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> mcasp2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__mcasp2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_mcasp2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp3 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp3_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> mcasp3 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__mcasp3 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_mcasp3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp4 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp4_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp5 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp5 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp5_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp6 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp6 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp6_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp7 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp7 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp7_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> mcasp8 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__mcasp8 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_mcasp8_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> elm */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__elm = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_elm_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> gpmc */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__gpmc = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_gpmc_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> hdq1w */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__hdq1w = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_hdq1w_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> mailbox1 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__mailbox1 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_mailbox1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox2 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox3 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox4 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox5 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox5 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox5_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox6 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox6 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox6_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox7 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox7 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox7_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox8 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox8 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox8_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox9 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox9 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox9_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox10 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox10 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox10_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox11 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox11 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox11_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox12 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox12 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox12_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> mailbox13 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__mailbox13 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_mailbox13_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi1 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> mcspi4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__mcspi4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_mcspi4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> mpu */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__mpu = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_mpu_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> ocp2scp1 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__ocp2scp1 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_ocp2scp1_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> ocp2scp3 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__ocp2scp3 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_ocp2scp3_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> pciess1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__pciess1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_pciess1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> pciess1 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__pciess1 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_pciess1_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> pciess2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__pciess2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_pciess2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> pciess2 */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__pciess2 = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_pciess2_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> qspi */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__qspi = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_qspi_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> rtcss */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__rtcss = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_rtcss_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> sata */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__sata = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_sata_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> smartreflex_core */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__smartreflex_core = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_smartreflex_core_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> smartreflex_mpu */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__smartreflex_mpu = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_smartreflex_mpu_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_cfg -> spinlock */
static struct omap_hwmod_ocp_if dra7xx_l4_cfg__spinlock = {
	.master		= &dra7xx_l4_cfg_hwmod,
	.slave		= &dra7xx_spinlock_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> timer1 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__timer1 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_timer1_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer2 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer3 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer3_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer4 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer4_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer5 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer5 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer5_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer6 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer6 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer6_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer7 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer7 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer7_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer8 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer8 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer8_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer9 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer9 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer9_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer10 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer10 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer10_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> timer11 */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__timer11 = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_timer11_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> timer12 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__timer12 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_timer12_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer13 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer13 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer13_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer14 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer14 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer14_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer15 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer15 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer15_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> timer16 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__timer16 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_timer16_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> des */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__des = {
	.master		= &dra7xx_l4_per1_hwmod,
	.slave		= &dra7xx_des_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per1 -> rng */
static struct omap_hwmod_ocp_if dra7xx_l4_per1__rng = {
	.master         = &dra7xx_l4_per1_hwmod,
	.slave          = &dra7xx_rng_hwmod,
	.user           = OCP_USER_MPU,
};

/* l4_per3 -> usb_otg_ss1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss1 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss1_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> usb_otg_ss2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss2 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss2_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> usb_otg_ss3 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss3 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss3_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per3 -> usb_otg_ss4 */
static struct omap_hwmod_ocp_if dra7xx_l4_per3__usb_otg_ss4 = {
	.master		= &dra7xx_l4_per3_hwmod,
	.slave		= &dra7xx_usb_otg_ss4_hwmod,
	.clk		= "dpll_core_h13x2_ck",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> vcp1 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__vcp1 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_vcp1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> vcp1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__vcp1 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_vcp1_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l3_main_1 -> vcp2 */
static struct omap_hwmod_ocp_if dra7xx_l3_main_1__vcp2 = {
	.master		= &dra7xx_l3_main_1_hwmod,
	.slave		= &dra7xx_vcp2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> vcp2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__vcp2 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_vcp2_hwmod,
	.clk		= "l3_iclk_div",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_wkup -> wd_timer2 */
static struct omap_hwmod_ocp_if dra7xx_l4_wkup__wd_timer2 = {
	.master		= &dra7xx_l4_wkup_hwmod,
	.slave		= &dra7xx_wd_timer2_hwmod,
	.clk		= "wkupaon_iclk_mux",
	.user		= OCP_USER_MPU | OCP_USER_SDMA,
};

/* l4_per2 -> epwmss0 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__epwmss0 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_epwmss0_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU,
};

/* l4_per2 -> epwmss1 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__epwmss1 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_epwmss1_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU,
};

/* l4_per2 -> epwmss2 */
static struct omap_hwmod_ocp_if dra7xx_l4_per2__epwmss2 = {
	.master		= &dra7xx_l4_per2_hwmod,
	.slave		= &dra7xx_epwmss2_hwmod,
	.clk		= "l4_root_clk_div",
	.user		= OCP_USER_MPU,
};

static struct omap_hwmod_ocp_if *dra7xx_hwmod_ocp_ifs[] __initdata = {
	&dra7xx_l3_main_1__dmm,
	&dra7xx_l3_main_2__l3_instr,
	&dra7xx_l4_cfg__l3_main_1,
	&dra7xx_mpu__l3_main_1,
	&dra7xx_l3_main_1__l3_main_2,
	&dra7xx_l4_cfg__l3_main_2,
	&dra7xx_l3_main_1__l4_cfg,
	&dra7xx_l3_main_1__l4_per1,
	&dra7xx_l3_main_1__l4_per2,
	&dra7xx_l3_main_1__l4_per3,
	&dra7xx_l3_main_1__l4_wkup,
	&dra7xx_l4_per2__atl,
	&dra7xx_l3_main_1__bb2d,
	&dra7xx_l4_wkup__counter_32k,
	&dra7xx_l4_wkup__ctrl_module_wkup,
	&dra7xx_l4_wkup__dcan1,
	&dra7xx_l4_per2__dcan2,
	&dra7xx_l4_per2__cpgmac0,
	&dra7xx_l4_per2__mcasp1,
	&dra7xx_l3_main_1__mcasp1,
	&dra7xx_l4_per2__mcasp2,
	&dra7xx_l3_main_1__mcasp2,
	&dra7xx_l4_per2__mcasp3,
	&dra7xx_l3_main_1__mcasp3,
	&dra7xx_l4_per2__mcasp4,
	&dra7xx_l4_per2__mcasp5,
	&dra7xx_l4_per2__mcasp6,
	&dra7xx_l4_per2__mcasp7,
	&dra7xx_l4_per2__mcasp8,
	&dra7xx_gmac__mdio,
	&dra7xx_l4_cfg__dma_system,
	&dra7xx_l3_main_1__tpcc,
	&dra7xx_l3_main_1__tptc0,
	&dra7xx_l3_main_1__tptc1,
	&dra7xx_l3_main_1__dss,
	&dra7xx_l3_main_1__dispc,
	&dra7xx_l3_main_1__hdmi,
	&dra7xx_l3_main_1__aes1,
	&dra7xx_l3_main_1__aes2,
	&dra7xx_l3_main_1__sha0,
	&dra7xx_l4_per1__elm,
	&dra7xx_l3_main_1__gpmc,
	&dra7xx_l4_per1__hdq1w,
	&dra7xx_l4_cfg__mailbox1,
	&dra7xx_l4_per3__mailbox2,
	&dra7xx_l4_per3__mailbox3,
	&dra7xx_l4_per3__mailbox4,
	&dra7xx_l4_per3__mailbox5,
	&dra7xx_l4_per3__mailbox6,
	&dra7xx_l4_per3__mailbox7,
	&dra7xx_l4_per3__mailbox8,
	&dra7xx_l4_per3__mailbox9,
	&dra7xx_l4_per3__mailbox10,
	&dra7xx_l4_per3__mailbox11,
	&dra7xx_l4_per3__mailbox12,
	&dra7xx_l4_per3__mailbox13,
	&dra7xx_l4_per1__mcspi1,
	&dra7xx_l4_per1__mcspi2,
	&dra7xx_l4_per1__mcspi3,
	&dra7xx_l4_per1__mcspi4,
	&dra7xx_l4_cfg__mpu,
	&dra7xx_l4_cfg__ocp2scp1,
	&dra7xx_l4_cfg__ocp2scp3,
	&dra7xx_l3_main_1__pciess1,
	&dra7xx_l4_cfg__pciess1,
	&dra7xx_l3_main_1__pciess2,
	&dra7xx_l4_cfg__pciess2,
	&dra7xx_l3_main_1__qspi,
	&dra7xx_l4_cfg__sata,
	&dra7xx_l4_cfg__smartreflex_core,
	&dra7xx_l4_cfg__smartreflex_mpu,
	&dra7xx_l4_cfg__spinlock,
	&dra7xx_l4_wkup__timer1,
	&dra7xx_l4_per1__timer2,
	&dra7xx_l4_per1__timer3,
	&dra7xx_l4_per1__timer4,
	&dra7xx_l4_per3__timer5,
	&dra7xx_l4_per3__timer6,
	&dra7xx_l4_per3__timer7,
	&dra7xx_l4_per3__timer8,
	&dra7xx_l4_per1__timer9,
	&dra7xx_l4_per1__timer10,
	&dra7xx_l4_per1__timer11,
	&dra7xx_l4_per3__timer13,
	&dra7xx_l4_per3__timer14,
	&dra7xx_l4_per3__timer15,
	&dra7xx_l4_per3__timer16,
	&dra7xx_l4_per1__des,
	&dra7xx_l4_per3__usb_otg_ss1,
	&dra7xx_l4_per3__usb_otg_ss2,
	&dra7xx_l4_per3__usb_otg_ss3,
	&dra7xx_l3_main_1__vcp1,
	&dra7xx_l4_per2__vcp1,
	&dra7xx_l3_main_1__vcp2,
	&dra7xx_l4_per2__vcp2,
	&dra7xx_l4_wkup__wd_timer2,
	&dra7xx_l4_per2__epwmss0,
	&dra7xx_l4_per2__epwmss1,
	&dra7xx_l4_per2__epwmss2,
	NULL,
};

/* GP-only hwmod links */
static struct omap_hwmod_ocp_if *dra7xx_gp_hwmod_ocp_ifs[] __initdata = {
	&dra7xx_l4_wkup__timer12,
	&dra7xx_l4_per1__rng,
	NULL,
};

/* SoC variant specific hwmod links */
static struct omap_hwmod_ocp_if *dra76x_hwmod_ocp_ifs[] __initdata = {
	&dra7xx_l4_per3__usb_otg_ss4,
	NULL,
};

static struct omap_hwmod_ocp_if *acd_76x_hwmod_ocp_ifs[] __initdata = {
	NULL,
};

static struct omap_hwmod_ocp_if *dra74x_hwmod_ocp_ifs[] __initdata = {
	&dra7xx_l4_per3__usb_otg_ss4,
	NULL,
};

static struct omap_hwmod_ocp_if *dra72x_hwmod_ocp_ifs[] __initdata = {
	NULL,
};

static struct omap_hwmod_ocp_if *rtc_hwmod_ocp_ifs[] __initdata = {
	&dra7xx_l4_per3__rtcss,
	NULL,
};

int __init dra7xx_hwmod_init(void)
{
	int ret;

	omap_hwmod_init();
	ret = omap_hwmod_register_links(dra7xx_hwmod_ocp_ifs);

	if (!ret && soc_is_dra74x()) {
		ret = omap_hwmod_register_links(dra74x_hwmod_ocp_ifs);
		if (!ret)
			ret = omap_hwmod_register_links(rtc_hwmod_ocp_ifs);
	} else if (!ret && soc_is_dra72x()) {
		ret = omap_hwmod_register_links(dra72x_hwmod_ocp_ifs);
		if (!ret && !of_machine_is_compatible("ti,dra718"))
			ret = omap_hwmod_register_links(rtc_hwmod_ocp_ifs);
	} else if (!ret && soc_is_dra76x()) {
		ret = omap_hwmod_register_links(dra76x_hwmod_ocp_ifs);

		if (!ret && soc_is_dra76x_acd()) {
			ret = omap_hwmod_register_links(acd_76x_hwmod_ocp_ifs);
		} else if (!ret && soc_is_dra76x_abz()) {
			ret = omap_hwmod_register_links(rtc_hwmod_ocp_ifs);
		}
	}

	if (!ret && omap_type() == OMAP2_DEVICE_TYPE_GP)
		ret = omap_hwmod_register_links(dra7xx_gp_hwmod_ocp_ifs);

	return ret;
}
