// SPDX-Lincense-Identifier: GPL 2.0
/*
 * R8A77980 processor support - PFC hardware block.
 *
 * Copyright (C) 2018 Renesas Electronics Corp.
 * Copyright (C) 2018 Cogent Embedded, Inc.
 *
 * This file is based on the drivers/pinctrl/sh-pfc/pfc-r8a7795.c
 *
 * R-Car Gen3 processor support - PFC hardware block.
 *
 * Copyright (C) 2015 Renesas Electronics Corporation
 */

#include <linux/io.h>
#include <linux/kernel.h>

#include "core.h"
#include "sh_pfc.h"

#define CPU_ALL_PORT(fn, sfx)	\
	PORT_GP_CFG_22(0, fn, sfx, SH_PFC_PIN_CFG_IO_VOLTAGE),	\
	PORT_GP_28(1, fn, sfx),	\
	PORT_GP_CFG_30(2, fn, sfx, SH_PFC_PIN_CFG_IO_VOLTAGE),	\
	PORT_GP_CFG_17(3, fn, sfx, SH_PFC_PIN_CFG_IO_VOLTAGE), \
	PORT_GP_25(4, fn, sfx),	\
	PORT_GP_15(5, fn, sfx)

/*
 * F_() : just information
 * FM() : macro for FN_xxx / xxx_MARK
 */

/* GPSR0 */
#define GPSR0_21	F_(DU_EXODDF_DU_ODDF_DISP_CDE,	IP2_23_20)
#define GPSR0_20	F_(DU_EXVSYNC_DU_VSYNC,		IP2_19_16)
#define GPSR0_19	F_(DU_EXHSYNC_DU_HSYNC,		IP2_15_12)
#define GPSR0_18	F_(DU_DOTCLKOUT,		IP2_11_8)
#define GPSR0_17	F_(DU_DB7,			IP2_7_4)
#define GPSR0_16	F_(DU_DB6,			IP2_3_0)
#define GPSR0_15	F_(DU_DB5,			IP1_31_28)
#define GPSR0_14	F_(DU_DB4,			IP1_27_24)
#define GPSR0_13	F_(DU_DB3,			IP1_23_20)
#define GPSR0_12	F_(DU_DB2,			IP1_19_16)
#define GPSR0_11	F_(DU_DG7,			IP1_15_12)
#define GPSR0_10	F_(DU_DG6,			IP1_11_8)
#define GPSR0_9		F_(DU_DG5,			IP1_7_4)
#define GPSR0_8		F_(DU_DG4,			IP1_3_0)
#define GPSR0_7		F_(DU_DG3,			IP0_31_28)
#define GPSR0_6		F_(DU_DG2,			IP0_27_24)
#define GPSR0_5		F_(DU_DR7,			IP0_23_20)
#define GPSR0_4		F_(DU_DR6,			IP0_19_16)
#define GPSR0_3		F_(DU_DR5,			IP0_15_12)
#define GPSR0_2		F_(DU_DR4,			IP0_11_8)
#define GPSR0_1		F_(DU_DR3,			IP0_7_4)
#define GPSR0_0		F_(DU_DR2,			IP0_3_0)

/* GPSR1 */
#define GPSR1_27	F_(DIGRF_CLKOUT,	IP8_31_28)
#define GPSR1_26	F_(DIGRF_CLKIN,		IP8_27_24)
#define GPSR1_25	F_(CANFD_CLK_A,		IP8_23_20)
#define GPSR1_24	F_(CANFD1_RX,		IP8_19_16)
#define GPSR1_23	F_(CANFD1_TX,		IP8_15_12)
#define GPSR1_22	F_(CANFD0_RX_A,		IP8_11_8)
#define GPSR1_21	F_(CANFD0_TX_A,		IP8_7_4)
#define GPSR1_20	F_(AVB_AVTP_CAPTURE,	IP8_3_0)
#define GPSR1_19	F_(AVB_AVTP_MATCH,	IP7_31_28)
#define GPSR1_18	FM(AVB_LINK)
#define GPSR1_17	FM(AVB_PHY_INT)
#define GPSR1_16	FM(AVB_MAGIC)
#define GPSR1_15	FM(AVB_MDC)
#define GPSR1_14	FM(AVB_MDIO)
#define GPSR1_13	FM(AVB_TXCREFCLK)
#define GPSR1_12	FM(AVB_TD3)
#define GPSR1_11	FM(AVB_TD2)
#define GPSR1_10	FM(AVB_TD1)
#define GPSR1_9		FM(AVB_TD0)
#define GPSR1_8		FM(AVB_TXC)
#define GPSR1_7		FM(AVB_TX_CTL)
#define GPSR1_6		FM(AVB_RD3)
#define GPSR1_5		FM(AVB_RD2)
#define GPSR1_4		FM(AVB_RD1)
#define GPSR1_3		FM(AVB_RD0)
#define GPSR1_2		FM(AVB_RXC)
#define GPSR1_1		FM(AVB_RX_CTL)
#define GPSR1_0		F_(IRQ0,		IP2_27_24)

/* GPSR2 */
#define GPSR2_29	F_(FSO_TOE_N,  		IP10_19_16)
#define GPSR2_28	F_(FSO_CFE_1_N,		IP10_15_12)
#define GPSR2_27	F_(FSO_CFE_0_N,		IP10_11_8)
#define GPSR2_26	F_(SDA3,		IP10_7_4)
#define GPSR2_25	F_(SCL3,		IP10_3_0)
#define GPSR2_24	F_(MSIOF0_SS2,		IP9_31_28)
#define GPSR2_23	F_(MSIOF0_SS1,		IP9_27_24)
#define GPSR2_22	F_(MSIOF0_SYNC,		IP9_23_20)
#define GPSR2_21	F_(MSIOF0_SCK,		IP9_19_16)
#define GPSR2_20	F_(MSIOF0_TXD,		IP9_15_12)
#define GPSR2_19	F_(MSIOF0_RXD,		IP9_11_8)
#define GPSR2_18	F_(IRQ5,		IP9_7_4)
#define GPSR2_17	F_(IRQ4,		IP9_3_0)
#define GPSR2_16	F_(VI0_FIELD,		IP4_31_28)
#define GPSR2_15	F_(VI0_DATA11,		IP4_27_24)
#define GPSR2_14	F_(VI0_DATA10,		IP4_23_20)
#define GPSR2_13	F_(VI0_DATA9,		IP4_19_16)
#define GPSR2_12	F_(VI0_DATA8,		IP4_15_12)
#define GPSR2_11	F_(VI0_DATA7,		IP4_11_8)
#define GPSR2_10	F_(VI0_DATA6,		IP4_7_4)
#define GPSR2_9		F_(VI0_DATA5,		IP4_3_0)
#define GPSR2_8		F_(VI0_DATA4,		IP3_31_28)
#define GPSR2_7		F_(VI0_DATA3,		IP3_27_24)
#define GPSR2_6		F_(VI0_DATA2,		IP3_23_20)
#define GPSR2_5		F_(VI0_DATA1,		IP3_19_16)
#define GPSR2_4		F_(VI0_DATA0,		IP3_15_12)
#define GPSR2_3		F_(VI0_VSYNC_N,		IP3_11_8)
#define GPSR2_2		F_(VI0_HSYNC_N,		IP3_7_4)
#define GPSR2_1		F_(VI0_CLKENB,		IP3_3_0)
#define GPSR2_0		F_(VI0_CLK,		IP2_31_28)

/* GPSR3 */
#define GPSR3_16	F_(VI1_FIELD,		IP7_3_0)
#define GPSR3_15	F_(VI1_DATA11,		IP6_31_28)
#define GPSR3_14	F_(VI1_DATA10,		IP6_27_24)
#define GPSR3_13	F_(VI1_DATA9,		IP6_23_20)
#define GPSR3_12	F_(VI1_DATA8,		IP6_19_16)
#define GPSR3_11	F_(VI1_DATA7,		IP6_15_12)
#define GPSR3_10	F_(VI1_DATA6,		IP6_11_8)
#define GPSR3_9		F_(VI1_DATA5,		IP6_7_4)
#define GPSR3_8		F_(VI1_DATA4,		IP6_3_0)
#define GPSR3_7		F_(VI1_DATA3,		IP5_31_28)
#define GPSR3_6		F_(VI1_DATA2,		IP5_27_24)
#define GPSR3_5		F_(VI1_DATA1,		IP5_23_20)
#define GPSR3_4		F_(VI1_DATA0,		IP5_19_16)
#define GPSR3_3		F_(VI1_VSYNC_N,		IP5_15_12)
#define GPSR3_2		F_(VI1_HSYNC_N,		IP5_11_8)
#define GPSR3_1		F_(VI1_CLKENB,		IP5_7_4)
#define GPSR3_0		F_(VI1_CLK,		IP5_3_0)

/* GPSR4 */
#define GPSR4_24	FM(GETHER_LINK_A)
#define GPSR4_23	FM(GETHER_PHY_INT_A)
#define GPSR4_22	FM(GETHER_MAGIC)
#define GPSR4_21	FM(GETHER_MDC_A)
#define GPSR4_20	FM(GETHER_MDIO_A)
#define GPSR4_19	FM(GETHER_TXCREFCLK_MEGA)
#define GPSR4_18	FM(GETHER_TXCREFCLK)
#define GPSR4_17	FM(GETHER_TD3)
#define GPSR4_16	FM(GETHER_TD2)
#define GPSR4_15	FM(GETHER_TD1)
#define GPSR4_14	FM(GETHER_TD0)
#define GPSR4_13	FM(GETHER_TXC)
#define GPSR4_12	FM(GETHER_TX_CTL)
#define GPSR4_11	FM(GETHER_RD3)
#define GPSR4_10	FM(GETHER_RD2)
#define GPSR4_9		FM(GETHER_RD1)
#define GPSR4_8		FM(GETHER_RD0)
#define GPSR4_7		FM(GETHER_RXC)
#define GPSR4_6		FM(GETHER_RX_CTL)
#define GPSR4_5		F_(SDA2,		IP7_27_24)
#define GPSR4_4		F_(SCL2,		IP7_23_20)
#define GPSR4_3		F_(SDA1,		IP7_19_16)
#define GPSR4_2		F_(SCL1,		IP7_15_12)
#define GPSR4_1		F_(SDA0,		IP7_11_8)
#define GPSR4_0		F_(SCL0,		IP7_7_4)

/* GPSR5 */
#define GPSR5_14	FM(RPC_INT_N)
#define GPSR5_13	FM(RPC_WP_N)
#define GPSR5_12	FM(RPC_RESET_N)
#define GPSR5_11	FM(QSPI1_SSL)
#define GPSR5_10	FM(QSPI1_IO3)
#define GPSR5_9		FM(QSPI1_IO2)
#define GPSR5_8		FM(QSPI1_MISO_IO1)
#define GPSR5_7		FM(QSPI1_MOSI_IO0)
#define GPSR5_6		FM(QSPI1_SPCLK)
#define GPSR5_5		FM(QSPI0_SSL)
#define GPSR5_4		FM(QSPI0_IO3)
#define GPSR5_3		FM(QSPI0_IO2)
#define GPSR5_2		FM(QSPI0_MISO_IO1)
#define GPSR5_1		FM(QSPI0_MOSI_IO0)
#define GPSR5_0		FM(QSPI0_SPCLK)


/* IPSRx */		/* 0 */				/* 1 */			/* 2 */			/* 3 */		/* 4 */		/* 5 */		/* 6 - F */
#define IP0_3_0		FM(DU_DR2)			FM(SCK4)		FM(GETHER_RMII_CRS_DV)	FM(A0)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP0_7_4		FM(DU_DR3)			FM(RX4)			FM(GETHER_RMII_RX_ER)	FM(A1)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP0_11_8	FM(DU_DR4)			FM(TX4)			FM(GETHER_RMII_RXD0)	FM(A2)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP0_15_12	FM(DU_DR5)			FM(CTS4_N)		FM(GETHER_RMII_RXD1)	FM(A3)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP0_19_16	FM(DU_DR6)			FM(RTS4_N_TANS)		FM(GETHER_RMII_TXD_EN)	FM(A4)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP0_23_20	FM(DU_DR7)			F_(0, 0)		FM(GETHER_RMII_TXD0)	FM(A5)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP0_27_24	FM(DU_DG2)			F_(0, 0)		FM(GETHER_RMII_TXD1)	FM(A6)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP0_31_28	FM(DU_DG3)			FM(CPG_CPCKOUT)		FM(GETHER_RMII_REFCLK)	FM(A7)		FM(PWMFSW0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_3_0		FM(DU_DG4)			FM(SCL5)		F_(0, 0)		FM(A8)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_7_4		FM(DU_DG5)			FM(SDA5)		FM(GETHER_MDC_B)	FM(A9)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_11_8	FM(DU_DG6)			FM(SCIF_CLK_A)		FM(GETHER_MDIO_B)	FM(A10)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_15_12	FM(DU_DG7)			FM(HRX0_A)		F_(0, 0)		FM(A11)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_19_16	FM(DU_DB2)			FM(HSCK0_A)		F_(0, 0)		FM(A12)		FM(IRQ1)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_23_20	FM(DU_DB3)			FM(HRTS0_N_A)		F_(0, 0)		FM(A13)		FM(IRQ2)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_27_24	FM(DU_DB4)			FM(HCTS0_N_A)		F_(0, 0)		FM(A14)		FM(IRQ3)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP1_31_28	FM(DU_DB5)			FM(HTX0_A)		FM(PWM0_A)		FM(A15)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_3_0		FM(DU_DB6)			FM(MSIOF3_RXD)		F_(0, 0)		FM(A16)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_7_4		FM(DU_DB7)			FM(MSIOF3_TXD)		F_(0, 0)		FM(A17)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_11_8	FM(DU_DOTCLKOUT)		FM(MSIOF3_SS1)		FM(GETHER_LINK_B)	FM(A18)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_15_12	FM(DU_EXHSYNC_DU_HSYNC)		FM(MSIOF3_SS2)		FM(GETHER_PHY_INT_B)	FM(A19)		FM(FXR_TXENA_N)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_19_16	FM(DU_EXVSYNC_DU_VSYNC)		FM(MSIOF3_SCK)		F_(0, 0)		F_(0, 0)	FM(FXR_TXENB_N)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_23_20	FM(DU_EXODDF_DU_ODDF_DISP_CDE)	FM(MSIOF3_SYNC)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_27_24	FM(IRQ0)			FM(CC5_OSCOUT)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP2_31_28	FM(VI0_CLK)			FM(MSIOF2_SCK)		FM(SCK3)		F_(0, 0)	FM(HSCK3)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_3_0		FM(VI0_CLKENB)			FM(MSIOF2_RXD)		FM(RX3)			FM(RD_WR_N)	FM(HCTS3_N)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_7_4		FM(VI0_HSYNC_N)			FM(MSIOF2_TXD)		FM(TX3)			F_(0, 0)	FM(HRTS3_N)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_11_8	FM(VI0_VSYNC_N)			FM(MSIOF2_SYNC)		FM(CTS3_N)		F_(0, 0)	FM(HTX3)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_15_12	FM(VI0_DATA0)			FM(MSIOF2_SS1)		FM(RTS3_N_TANS)		F_(0, 0)	FM(HRX3)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_19_16	FM(VI0_DATA1)			FM(MSIOF2_SS2)		FM(SCK1)		F_(0, 0)	FM(SPEEDIN_A)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_23_20	FM(VI0_DATA2)			FM(AVB_AVTP_PPS)	F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_27_24	FM(VI0_DATA3)			FM(HSCK1)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP3_31_28	FM(VI0_DATA4)			FM(HRTS1_N)		FM(RX1_A)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_3_0		FM(VI0_DATA5)			FM(HCTS1_N)		FM(TX1_A)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_7_4		FM(VI0_DATA6)			FM(HTX1)		FM(CTS1_N)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_11_8	FM(VI0_DATA7)			FM(HRX1)		FM(RTS1_N_TANS)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_15_12	FM(VI0_DATA8)			FM(HSCK2)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_19_16	FM(VI0_DATA9)			FM(HCTS2_N)		FM(PWM1_A)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_23_20	FM(VI0_DATA10)			FM(HRTS2_N)		FM(PWM2_A)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_27_24	FM(VI0_DATA11)			FM(HTX2)		FM(PWM3_A)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP4_31_28	FM(VI0_FIELD)			FM(HRX2)		FM(PWM4_A)		FM(CS1_N)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_3_0		FM(VI1_CLK)			FM(MSIOF1_RXD)		F_(0, 0)		FM(CS0_N)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_7_4		FM(VI1_CLKENB)			FM(MSIOF1_TXD)		F_(0, 0)		FM(D0)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_11_8	FM(VI1_HSYNC_N)			FM(MSIOF1_SCK)		F_(0, 0)		FM(D1)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_15_12	FM(VI1_VSYNC_N)			FM(MSIOF1_SYNC)		F_(0, 0)		FM(D2)		F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_19_16	FM(VI1_DATA0)			FM(MSIOF1_SS1)		F_(0, 0)		FM(D3)		FM(MMC_WP)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_23_20	FM(VI1_DATA1)			FM(MSIOF1_SS2)		F_(0, 0)		FM(D4)		FM(MMC_CD)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_27_24	FM(VI1_DATA2)			FM(CANFD0_TX_B)		F_(0, 0)		FM(D5)		FM(MMC_DS)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP5_31_28	FM(VI1_DATA3)			FM(CANFD0_RX_B)		F_(0, 0)		FM(D6)		FM(MMC_CMD)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_3_0		FM(VI1_DATA4)			FM(CANFD_CLK_B)		F_(0, 0)		FM(D7)		FM(MMC_D0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_7_4		FM(VI1_DATA5)			F_(0, 0)		F_(0, 0)		FM(D8)		FM(MMC_D1)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_11_8	FM(VI1_DATA6)			F_(0, 0)		F_(0, 0)		FM(D9)		FM(MMC_D2)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_15_12	FM(VI1_DATA7)			F_(0, 0)		F_(0, 0)		FM(D10)		FM(MMC_D3)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_19_16	FM(VI1_DATA8)			F_(0, 0)		F_(0, 0)		FM(D11)		FM(MMC_CLK)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_23_20	FM(VI1_DATA9)			FM(TCLK1_A)		F_(0, 0)		FM(D12)		FM(MMC_D4)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_27_24	FM(VI1_DATA10)			FM(TCLK2_A)		F_(0, 0)		FM(D13)		FM(MMC_D5)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP6_31_28	FM(VI1_DATA11)			FM(SCL4)		F_(0, 0)		FM(D14)		FM(MMC_D6)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_3_0		FM(VI1_FIELD)			FM(SDA4)		F_(0, 0)		FM(D15)		FM(MMC_D7)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_7_4		FM(SCL0)			F_(0, 0)		F_(0, 0)		FM(CLKOUT)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_11_8	FM(SDA0)			F_(0, 0)		F_(0, 0)		FM(BS_N)	FM(SCK0)	FM(HSCK0_B)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_15_12	FM(SCL1)			F_(0, 0)		FM(TPU0TO2)		FM(RD_N)	FM(CTS0_N)	FM(HCTS0_N_B)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_19_16	FM(SDA1)			F_(0, 0)		FM(TPU0TO3)		FM(WE0_N)	FM(RTS0_N_TANS)	FM(HRTS0_N_B)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_23_20	FM(SCL2)			F_(0, 0)		F_(0, 0)		FM(WE1_N)	FM(RX0)		FM(HRX0_B)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_27_24	FM(SDA2)			F_(0, 0)		F_(0, 0)		FM(EX_WAIT0)	FM(TX0)		FM(HTX0_B)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP7_31_28	FM(AVB_AVTP_MATCH)		FM(TPU0TO0)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_3_0		FM(AVB_AVTP_CAPTURE)		FM(TPU0TO1)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_7_4		FM(CANFD0_TX_A)			FM(FXR_TXDA)		FM(PWM0_B)		FM(DU_DISP)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_11_8	FM(CANFD0_RX_A)			FM(RXDA_EXTFXR)		FM(PWM1_B)		FM(DU_CDE)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_15_12	FM(CANFD1_TX)			FM(FXR_TXDB)		FM(PWM2_B)		FM(TCLK1_B)	FM(TX1_B)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_19_16	FM(CANFD1_RX)			FM(RXDB_EXTFXR)		FM(PWM3_B)		FM(TCLK2_B)	FM(RX1_B)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_23_20	FM(CANFD_CLK_A) 		FM(CLK_EXTFXR)		FM(PWM4_B)		FM(SPEEDIN_B)	FM(SCIF_CLK_B)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_27_24	FM(DIGRF_CLKIN)			FM(DIGRF_CLKEN_IN)	F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP8_31_28	FM(DIGRF_CLKOUT)		FM(DIGRF_CLKEN_OUT)	F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_3_0		FM(IRQ4)			F_(0, 0)		F_(0, 0)		FM(VI0_DATA12)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_7_4 	FM(IRQ5)			F_(0, 0)		F_(0, 0)		FM(VI0_DATA13)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_11_8	FM(MSIOF0_RXD)			FM(DU_DR0)		F_(0, 0)		FM(VI0_DATA14)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_15_12	FM(MSIOF0_TXD)			FM(DU_DR1)		F_(0, 0)		FM(VI0_DATA15)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_19_16	FM(MSIOF0_SCK)			FM(DU_DG0)		F_(0, 0)		FM(VI0_DATA16)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_23_20	FM(MSIOF0_SYNC)			FM(DU_DG1)		F_(0, 0)		FM(VI0_DATA17)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_27_24	FM(MSIOF0_SS1)			FM(DU_DB0)		FM(TCLK3)		FM(VI0_DATA18)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP9_31_28	FM(MSIOF0_SS2)			FM(DU_DB1)		FM(TCLK4)		FM(VI0_DATA19)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_3_0	FM(SCL3)			F_(0, 0)		F_(0, 0)		FM(VI0_DATA20)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_7_4	FM(SDA3)			F_(0, 0)		F_(0, 0)		FM(VI0_DATA21)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_11_8	FM(FSO_CFE_0_N)			F_(0, 0)		F_(0, 0)		FM(VI0_DATA22)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_15_12	FM(FSO_CFE_1_N)			F_(0, 0)		F_(0, 0)		FM(VI0_DATA23)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_19_16	FM(FSO_TOE_N)			F_(0, 0)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_23_20	F_(0, 0)			F_(0, 0)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_27_24	F_(0, 0)			F_(0, 0)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)
#define IP10_31_28	F_(0, 0)			F_(0, 0)		F_(0, 0)		F_(0, 0)	F_(0, 0)	F_(0, 0)	F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0) F_(0, 0)

#define PINMUX_GPSR	\
\
				GPSR2_29 \
				GPSR2_28 \
		GPSR1_27	GPSR2_27 \
		GPSR1_26	GPSR2_26 \
		GPSR1_25	GPSR2_25 \
		GPSR1_24	GPSR2_24			GPSR4_24 \
		GPSR1_23	GPSR2_23			GPSR4_23 \
		GPSR1_22	GPSR2_22			GPSR4_22 \
GPSR0_21	GPSR1_21	GPSR2_21			GPSR4_21 \
GPSR0_20	GPSR1_20	GPSR2_20			GPSR4_20 \
GPSR0_19	GPSR1_19	GPSR2_19			GPSR4_19 \
GPSR0_18	GPSR1_18	GPSR2_18			GPSR4_18 \
GPSR0_17	GPSR1_17	GPSR2_17			GPSR4_17 \
GPSR0_16	GPSR1_16	GPSR2_16	GPSR3_16	GPSR4_16 \
GPSR0_15	GPSR1_15	GPSR2_15	GPSR3_15	GPSR4_15 \
GPSR0_14	GPSR1_14	GPSR2_14	GPSR3_14	GPSR4_14	GPSR5_14 \
GPSR0_13	GPSR1_13	GPSR2_13	GPSR3_13	GPSR4_13	GPSR5_13 \
GPSR0_12	GPSR1_12	GPSR2_12	GPSR3_12	GPSR4_12	GPSR5_12 \
GPSR0_11	GPSR1_11	GPSR2_11	GPSR3_11	GPSR4_11	GPSR5_11 \
GPSR0_10	GPSR1_10	GPSR2_10	GPSR3_10	GPSR4_10	GPSR5_10 \
GPSR0_9		GPSR1_9		GPSR2_9		GPSR3_9		GPSR4_9		GPSR5_9 \
GPSR0_8		GPSR1_8		GPSR2_8		GPSR3_8		GPSR4_8		GPSR5_8 \
GPSR0_7		GPSR1_7		GPSR2_7		GPSR3_7		GPSR4_7		GPSR5_7 \
GPSR0_6		GPSR1_6		GPSR2_6		GPSR3_6		GPSR4_6		GPSR5_6 \
GPSR0_5		GPSR1_5		GPSR2_5		GPSR3_5		GPSR4_5		GPSR5_5 \
GPSR0_4		GPSR1_4		GPSR2_4		GPSR3_4		GPSR4_4		GPSR5_4 \
GPSR0_3		GPSR1_3		GPSR2_3		GPSR3_3		GPSR4_3		GPSR5_3 \
GPSR0_2		GPSR1_2		GPSR2_2		GPSR3_2		GPSR4_2		GPSR5_2 \
GPSR0_1		GPSR1_1		GPSR2_1		GPSR3_1		GPSR4_1		GPSR5_1 \
GPSR0_0		GPSR1_0		GPSR2_0		GPSR3_0		GPSR4_0		GPSR5_0

#define PINMUX_IPSR	\
\
FM(IP0_3_0)	IP0_3_0		FM(IP1_3_0)	IP1_3_0		FM(IP2_3_0)	IP2_3_0		FM(IP3_3_0)	IP3_3_0 \
FM(IP0_7_4)	IP0_7_4		FM(IP1_7_4)	IP1_7_4		FM(IP2_7_4)	IP2_7_4		FM(IP3_7_4)	IP3_7_4 \
FM(IP0_11_8)	IP0_11_8	FM(IP1_11_8)	IP1_11_8	FM(IP2_11_8)	IP2_11_8	FM(IP3_11_8)	IP3_11_8 \
FM(IP0_15_12)	IP0_15_12	FM(IP1_15_12)	IP1_15_12	FM(IP2_15_12)	IP2_15_12	FM(IP3_15_12)	IP3_15_12 \
FM(IP0_19_16)	IP0_19_16	FM(IP1_19_16)	IP1_19_16	FM(IP2_19_16)	IP2_19_16	FM(IP3_19_16)	IP3_19_16 \
FM(IP0_23_20)	IP0_23_20	FM(IP1_23_20)	IP1_23_20	FM(IP2_23_20)	IP2_23_20	FM(IP3_23_20)	IP3_23_20 \
FM(IP0_27_24)	IP0_27_24	FM(IP1_27_24)	IP1_27_24	FM(IP2_27_24)	IP2_27_24	FM(IP3_27_24)	IP3_27_24 \
FM(IP0_31_28)	IP0_31_28	FM(IP1_31_28)	IP1_31_28	FM(IP2_31_28)	IP2_31_28	FM(IP3_31_28)	IP3_31_28 \
\
FM(IP4_3_0)	IP4_3_0		FM(IP5_3_0)	IP5_3_0		FM(IP6_3_0)	IP6_3_0		FM(IP7_3_0)	IP7_3_0 \
FM(IP4_7_4)	IP4_7_4		FM(IP5_7_4)	IP5_7_4		FM(IP6_7_4)	IP6_7_4		FM(IP7_7_4)	IP7_7_4 \
FM(IP4_11_8)	IP4_11_8	FM(IP5_11_8)	IP5_11_8	FM(IP6_11_8)	IP6_11_8	FM(IP7_11_8)	IP7_11_8 \
FM(IP4_15_12)	IP4_15_12	FM(IP5_15_12)	IP5_15_12	FM(IP6_15_12)	IP6_15_12	FM(IP7_15_12)	IP7_15_12 \
FM(IP4_19_16)	IP4_19_16	FM(IP5_19_16)	IP5_19_16	FM(IP6_19_16)	IP6_19_16	FM(IP7_19_16)	IP7_19_16 \
FM(IP4_23_20)	IP4_23_20	FM(IP5_23_20)	IP5_23_20	FM(IP6_23_20)	IP6_23_20	FM(IP7_23_20)	IP7_23_20 \
FM(IP4_27_24)	IP4_27_24	FM(IP5_27_24)	IP5_27_24	FM(IP6_27_24)	IP6_27_24	FM(IP7_27_24)	IP7_27_24 \
FM(IP4_31_28)	IP4_31_28	FM(IP5_31_28)	IP5_31_28	FM(IP6_31_28)	IP6_31_28	FM(IP7_31_28)	IP7_31_28 \
\
FM(IP8_3_0)	IP8_3_0		FM(IP9_3_0)	IP9_3_0		FM(IP10_3_0)	IP10_3_0 \
FM(IP8_7_4)	IP8_7_4		FM(IP9_7_4)	IP9_7_4		FM(IP10_7_4)	IP10_7_4 \
FM(IP8_11_8)	IP8_11_8	FM(IP9_11_8)	IP9_11_8	FM(IP10_11_8)	IP10_11_8 \
FM(IP8_15_12)	IP8_15_12	FM(IP9_15_12)	IP9_15_12	FM(IP10_15_12)	IP10_15_12 \
FM(IP8_19_16)	IP8_19_16	FM(IP9_19_16)	IP9_19_16	FM(IP10_19_16)	IP10_19_16 \
FM(IP8_23_20)	IP8_23_20	FM(IP9_23_20)	IP9_23_20	FM(IP10_23_20)	IP10_23_20 \
FM(IP8_27_24)	IP8_27_24	FM(IP9_27_24)	IP9_27_24	FM(IP10_27_24)	IP10_27_24 \
FM(IP8_31_28)	IP8_31_28	FM(IP9_31_28)	IP9_31_28	FM(IP10_31_28)	IP10_31_28

/* MOD_SEL0 */		/* 0 */			/* 1 */
#define MOD_SEL0_11	FM(SEL_CANFD0_0)	FM(SEL_CANFD0_1)
#define MOD_SEL0_10	FM(SEL_GETHER_0)	FM(SEL_GETHER_1)
#define MOD_SEL0_9	FM(SEL_HSCIF0_0)	FM(SEL_HSCIF0_1)
#define MOD_SEL0_8	FM(SEL_PWM0_0)		FM(SEL_PWM0_1)
#define MOD_SEL0_7	FM(SEL_PWM1_0)		FM(SEL_PWM1_1)
#define MOD_SEL0_6	FM(SEL_PWM2_0)		FM(SEL_PWM2_1)
#define MOD_SEL0_5	FM(SEL_PWM3_0)		FM(SEL_PWM3_1)
#define MOD_SEL0_4	FM(SEL_PWM4_0)		FM(SEL_PWM4_1)
#define MOD_SEL0_2	FM(SEL_RSP_0)		FM(SEL_RSP_1)
#define MOD_SEL0_1	FM(SEL_SCIF1_0)		FM(SEL_SCIF1_1)
#define MOD_SEL0_0	FM(SEL_TMU_0)		FM(SEL_TMU_1)

#define PINMUX_MOD_SELS \
\
MOD_SEL0_11 \
MOD_SEL0_10 \
MOD_SEL0_9 \
MOD_SEL0_8 \
MOD_SEL0_7 \
MOD_SEL0_6 \
MOD_SEL0_5 \
MOD_SEL0_4 \
MOD_SEL0_2 \
MOD_SEL0_1 \
MOD_SEL0_0

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA),
	PINMUX_DATA_END,

#define F_(x, y)
#define FM(x)   FN_##x,
	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN),
	PINMUX_GPSR
	PINMUX_IPSR
	PINMUX_MOD_SELS
	PINMUX_FUNCTION_END,
#undef F_
#undef FM

#define F_(x, y)
#define FM(x)	x##_MARK,
	PINMUX_MARK_BEGIN,
	PINMUX_GPSR
	PINMUX_IPSR
	PINMUX_MOD_SELS
	PINMUX_MARK_END,
#undef F_
#undef FM
};

static const u16 pinmux_data[] = {
	PINMUX_DATA_GP_ALL(),

	PINMUX_SINGLE(AVB_RX_CTL),
	PINMUX_SINGLE(AVB_RXC),
	PINMUX_SINGLE(AVB_RD0),
	PINMUX_SINGLE(AVB_RD1),
	PINMUX_SINGLE(AVB_RD2),
	PINMUX_SINGLE(AVB_RD3),
	PINMUX_SINGLE(AVB_TX_CTL),
	PINMUX_SINGLE(AVB_TXC),
	PINMUX_SINGLE(AVB_TD0),
	PINMUX_SINGLE(AVB_TD1),
	PINMUX_SINGLE(AVB_TD2),
	PINMUX_SINGLE(AVB_TD3),
	PINMUX_SINGLE(AVB_TXCREFCLK),
	PINMUX_SINGLE(AVB_MDIO),
	PINMUX_SINGLE(AVB_MDC),
	PINMUX_SINGLE(AVB_MAGIC),
	PINMUX_SINGLE(AVB_PHY_INT),
	PINMUX_SINGLE(AVB_LINK),

	PINMUX_SINGLE(GETHER_RX_CTL),
	PINMUX_SINGLE(GETHER_RXC),
	PINMUX_SINGLE(GETHER_RD0),
	PINMUX_SINGLE(GETHER_RD1),
	PINMUX_SINGLE(GETHER_RD2),
	PINMUX_SINGLE(GETHER_RD3),
	PINMUX_SINGLE(GETHER_TX_CTL),
	PINMUX_SINGLE(GETHER_TXC),
	PINMUX_SINGLE(GETHER_TD0),
	PINMUX_SINGLE(GETHER_TD1),
	PINMUX_SINGLE(GETHER_TD2),
	PINMUX_SINGLE(GETHER_TD3),
	PINMUX_SINGLE(GETHER_TXCREFCLK),
	PINMUX_SINGLE(GETHER_TXCREFCLK_MEGA),
	PINMUX_SINGLE(GETHER_MDIO_A),
	PINMUX_SINGLE(GETHER_MDC_A),
	PINMUX_SINGLE(GETHER_MAGIC),
	PINMUX_SINGLE(GETHER_PHY_INT_A),
	PINMUX_SINGLE(GETHER_LINK_A),

	PINMUX_SINGLE(QSPI0_SPCLK),
	PINMUX_SINGLE(QSPI0_MOSI_IO0),
	PINMUX_SINGLE(QSPI0_MISO_IO1),
	PINMUX_SINGLE(QSPI0_IO2),
	PINMUX_SINGLE(QSPI0_IO3),
	PINMUX_SINGLE(QSPI0_SSL),
	PINMUX_SINGLE(QSPI1_SPCLK),
	PINMUX_SINGLE(QSPI1_MOSI_IO0),
	PINMUX_SINGLE(QSPI1_MISO_IO1),
	PINMUX_SINGLE(QSPI1_IO2),
	PINMUX_SINGLE(QSPI1_IO3),
	PINMUX_SINGLE(QSPI1_SSL),
	PINMUX_SINGLE(RPC_RESET_N),
	PINMUX_SINGLE(RPC_WP_N),
	PINMUX_SINGLE(RPC_INT_N),

	/* IPSR0 */
	PINMUX_IPSR_GPSR(IP0_3_0,	DU_DR2),
	PINMUX_IPSR_GPSR(IP0_3_0,	SCK4),
	PINMUX_IPSR_GPSR(IP0_3_0,	GETHER_RMII_CRS_DV),
	PINMUX_IPSR_GPSR(IP0_3_0,	A0),

	PINMUX_IPSR_GPSR(IP0_7_4,	DU_DR3),
	PINMUX_IPSR_GPSR(IP0_7_4,	RX4),
	PINMUX_IPSR_GPSR(IP0_7_4,	GETHER_RMII_RX_ER),
	PINMUX_IPSR_GPSR(IP0_7_4,	A1),

	PINMUX_IPSR_GPSR(IP0_11_8,	DU_DR4),
	PINMUX_IPSR_GPSR(IP0_11_8,	TX4),
	PINMUX_IPSR_GPSR(IP0_11_8,	GETHER_RMII_RXD0),
	PINMUX_IPSR_GPSR(IP0_11_8,	A2),

	PINMUX_IPSR_GPSR(IP0_15_12,	DU_DR5),
	PINMUX_IPSR_GPSR(IP0_15_12,	CTS4_N),
	PINMUX_IPSR_GPSR(IP0_15_12,	GETHER_RMII_RXD1),
	PINMUX_IPSR_GPSR(IP0_15_12,	A3),

	PINMUX_IPSR_GPSR(IP0_19_16,	DU_DR6),
	PINMUX_IPSR_GPSR(IP0_19_16,	RTS4_N_TANS),
	PINMUX_IPSR_GPSR(IP0_19_16,	GETHER_RMII_TXD_EN),
	PINMUX_IPSR_GPSR(IP0_19_16,	A4),

	PINMUX_IPSR_GPSR(IP0_23_20,	DU_DR7),
	PINMUX_IPSR_GPSR(IP0_23_20,	GETHER_RMII_TXD0),
	PINMUX_IPSR_GPSR(IP0_23_20,	A5),

	PINMUX_IPSR_GPSR(IP0_27_24,	DU_DG2),
	PINMUX_IPSR_GPSR(IP0_27_24,	GETHER_RMII_TXD1),
	PINMUX_IPSR_GPSR(IP0_27_24,	A6),

	PINMUX_IPSR_GPSR(IP0_31_28,	DU_DG3),
	PINMUX_IPSR_GPSR(IP0_31_28,	CPG_CPCKOUT),
	PINMUX_IPSR_GPSR(IP0_31_28,	GETHER_RMII_REFCLK),
	PINMUX_IPSR_GPSR(IP0_31_28,	A7),
	PINMUX_IPSR_GPSR(IP0_31_28,	PWMFSW0),

	/* IPSR1 */
	PINMUX_IPSR_GPSR(IP1_3_0,	DU_DG4),
	PINMUX_IPSR_GPSR(IP1_3_0,	SCL5),
	PINMUX_IPSR_GPSR(IP1_3_0,	A8),

	PINMUX_IPSR_GPSR(IP1_7_4,	DU_DG5),
	PINMUX_IPSR_GPSR(IP1_7_4,	SDA5),
	PINMUX_IPSR_MSEL(IP1_7_4,	GETHER_MDC_B, SEL_GETHER_1),
	PINMUX_IPSR_GPSR(IP1_7_4,	A9),

	PINMUX_IPSR_GPSR(IP1_11_8,	DU_DG6),
	PINMUX_IPSR_MSEL(IP1_11_8,	SCIF_CLK_A, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP1_11_8,	GETHER_MDIO_B, SEL_GETHER_1),
	PINMUX_IPSR_GPSR(IP1_11_8,	A10),

	PINMUX_IPSR_GPSR(IP1_15_12,	DU_DG7),
	PINMUX_IPSR_MSEL(IP1_15_12,	HRX0_A, SEL_HSCIF0_0),
	PINMUX_IPSR_GPSR(IP1_15_12,	A11),

	PINMUX_IPSR_GPSR(IP1_19_16,	DU_DB2),
	PINMUX_IPSR_MSEL(IP1_19_16,	HSCK0_A, SEL_HSCIF0_0),
	PINMUX_IPSR_GPSR(IP1_19_16,	A12),
	PINMUX_IPSR_GPSR(IP1_19_16,	IRQ1),

	PINMUX_IPSR_GPSR(IP1_23_20,	DU_DB3),
	PINMUX_IPSR_MSEL(IP1_23_20,	HRTS0_N_A, SEL_HSCIF0_0),
	PINMUX_IPSR_GPSR(IP1_23_20,	A13),
	PINMUX_IPSR_GPSR(IP1_23_20,	IRQ2),

	PINMUX_IPSR_GPSR(IP1_27_24,	DU_DB4),
	PINMUX_IPSR_MSEL(IP1_27_24,	HCTS0_N_A, SEL_HSCIF0_0),
	PINMUX_IPSR_GPSR(IP1_27_24,	A14),
	PINMUX_IPSR_GPSR(IP1_27_24,	IRQ3),

	PINMUX_IPSR_GPSR(IP1_31_28,	DU_DB5),
	PINMUX_IPSR_MSEL(IP1_31_28,	HTX0_A, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP1_31_28,	PWM0_A, SEL_PWM0_0),
	PINMUX_IPSR_GPSR(IP1_31_28,	A15),

	/* IPSR2 */
	PINMUX_IPSR_GPSR(IP2_3_0,	DU_DB6),
	PINMUX_IPSR_GPSR(IP2_3_0,	MSIOF3_RXD),
	PINMUX_IPSR_GPSR(IP2_3_0,	A16),

	PINMUX_IPSR_GPSR(IP2_7_4,	DU_DB7),
	PINMUX_IPSR_GPSR(IP2_7_4,	MSIOF3_TXD),
	PINMUX_IPSR_GPSR(IP2_7_4,	A17),

	PINMUX_IPSR_GPSR(IP2_11_8,	DU_DOTCLKOUT),
	PINMUX_IPSR_GPSR(IP2_11_8,	MSIOF3_SS1),
	PINMUX_IPSR_MSEL(IP2_11_8,	GETHER_LINK_B, SEL_GETHER_1),
	PINMUX_IPSR_GPSR(IP2_11_8,	A18),

	PINMUX_IPSR_GPSR(IP2_15_12,	DU_EXHSYNC_DU_HSYNC),
	PINMUX_IPSR_GPSR(IP2_15_12,	MSIOF3_SS2),
	PINMUX_IPSR_MSEL(IP2_15_12,	GETHER_PHY_INT_B, SEL_GETHER_1),
	PINMUX_IPSR_GPSR(IP2_15_12,	A19),
	PINMUX_IPSR_GPSR(IP2_15_12,	FXR_TXENA_N),

	PINMUX_IPSR_GPSR(IP2_19_16,	DU_EXVSYNC_DU_VSYNC),
	PINMUX_IPSR_GPSR(IP2_19_16,	MSIOF3_SCK),
	PINMUX_IPSR_GPSR(IP2_19_16,	FXR_TXENB_N),

	PINMUX_IPSR_GPSR(IP2_23_20,	DU_EXODDF_DU_ODDF_DISP_CDE),
	PINMUX_IPSR_GPSR(IP2_23_20,	MSIOF3_SYNC),

	PINMUX_IPSR_GPSR(IP2_27_24,	IRQ0),
	PINMUX_IPSR_GPSR(IP2_27_24,	CC5_OSCOUT),

	PINMUX_IPSR_GPSR(IP2_31_28,	VI0_CLK),
	PINMUX_IPSR_GPSR(IP2_31_28,	MSIOF2_SCK),
	PINMUX_IPSR_GPSR(IP2_31_28,	SCK3),
	PINMUX_IPSR_GPSR(IP2_31_28,	HSCK3),

	/* IPSR3 */
	PINMUX_IPSR_GPSR(IP3_3_0,	VI0_CLKENB),
	PINMUX_IPSR_GPSR(IP3_3_0,	MSIOF2_RXD),
	PINMUX_IPSR_GPSR(IP3_3_0,	RX3),
	PINMUX_IPSR_GPSR(IP3_3_0,	RD_WR_N),
	PINMUX_IPSR_GPSR(IP3_3_0,	HCTS3_N),

	PINMUX_IPSR_GPSR(IP3_7_4,	VI0_HSYNC_N),
	PINMUX_IPSR_GPSR(IP3_7_4,	MSIOF2_TXD),
	PINMUX_IPSR_GPSR(IP3_7_4,	TX3),
	PINMUX_IPSR_GPSR(IP3_7_4,	HRTS3_N),

	PINMUX_IPSR_GPSR(IP3_11_8,	VI0_VSYNC_N),
	PINMUX_IPSR_GPSR(IP3_11_8,	MSIOF2_SYNC),
	PINMUX_IPSR_GPSR(IP3_11_8,	CTS3_N),
	PINMUX_IPSR_GPSR(IP3_11_8,	HTX3),

	PINMUX_IPSR_GPSR(IP3_15_12,	VI0_DATA0),
	PINMUX_IPSR_GPSR(IP3_15_12,	MSIOF2_SS1),
	PINMUX_IPSR_GPSR(IP3_15_12,	RTS3_N_TANS),
	PINMUX_IPSR_GPSR(IP3_15_12,	HRX3),

	PINMUX_IPSR_GPSR(IP3_19_16,	VI0_DATA1),
	PINMUX_IPSR_GPSR(IP3_19_16,	MSIOF2_SS2),
	PINMUX_IPSR_GPSR(IP3_19_16,	SCK1),
	PINMUX_IPSR_MSEL(IP3_19_16,	SPEEDIN_A, SEL_RSP_0),

	PINMUX_IPSR_GPSR(IP3_23_20,	VI0_DATA2),
	PINMUX_IPSR_GPSR(IP3_23_20,	AVB_AVTP_PPS),

	PINMUX_IPSR_GPSR(IP3_27_24,	VI0_DATA3),
	PINMUX_IPSR_GPSR(IP3_27_24,	HSCK1),

	PINMUX_IPSR_GPSR(IP3_31_28,	VI0_DATA4),
	PINMUX_IPSR_GPSR(IP3_31_28,	HRTS1_N),
	PINMUX_IPSR_MSEL(IP3_31_28,	RX1_A, SEL_SCIF1_0),

	/* IPSR4 */
	PINMUX_IPSR_GPSR(IP4_3_0,	VI0_DATA5),
	PINMUX_IPSR_GPSR(IP4_3_0,	HCTS1_N),
	PINMUX_IPSR_MSEL(IP4_3_0,	TX1_A, SEL_SCIF1_0),

	PINMUX_IPSR_GPSR(IP4_7_4,	VI0_DATA6),
	PINMUX_IPSR_GPSR(IP4_7_4,	HTX1),
	PINMUX_IPSR_GPSR(IP4_7_4,	CTS1_N),

	PINMUX_IPSR_GPSR(IP4_11_8,	VI0_DATA7),
	PINMUX_IPSR_GPSR(IP4_11_8,	HRX1),
	PINMUX_IPSR_GPSR(IP4_11_8,	RTS1_N_TANS),

	PINMUX_IPSR_GPSR(IP4_15_12,	VI0_DATA8),
	PINMUX_IPSR_GPSR(IP4_15_12,	HSCK2),

	PINMUX_IPSR_GPSR(IP4_19_16,	VI0_DATA9),
	PINMUX_IPSR_GPSR(IP4_19_16,	HCTS2_N),
	PINMUX_IPSR_MSEL(IP4_19_16,	PWM1_A, SEL_PWM1_0),

	PINMUX_IPSR_GPSR(IP4_23_20,	VI0_DATA10),
	PINMUX_IPSR_GPSR(IP4_23_20,	HRTS2_N),
	PINMUX_IPSR_MSEL(IP4_23_20,	PWM2_A, SEL_PWM2_0),

	PINMUX_IPSR_GPSR(IP4_27_24,	VI0_DATA11),
	PINMUX_IPSR_GPSR(IP4_27_24,	HTX2),
	PINMUX_IPSR_MSEL(IP4_27_24,	PWM3_A, SEL_PWM3_0),

	PINMUX_IPSR_GPSR(IP4_31_28,	VI0_FIELD),
	PINMUX_IPSR_GPSR(IP4_31_28,	HRX2),
	PINMUX_IPSR_MSEL(IP4_31_28,	PWM4_A, SEL_PWM4_0),
	PINMUX_IPSR_GPSR(IP4_31_28,	CS1_N),

	/* IPSR5 */
	PINMUX_IPSR_GPSR(IP5_3_0,	VI1_CLK),
	PINMUX_IPSR_GPSR(IP5_3_0,	MSIOF1_RXD),
	PINMUX_IPSR_GPSR(IP5_3_0,	CS0_N),

	PINMUX_IPSR_GPSR(IP5_7_4,	VI1_CLKENB),
	PINMUX_IPSR_GPSR(IP5_7_4,	MSIOF1_TXD),
	PINMUX_IPSR_GPSR(IP5_7_4,	D0),

	PINMUX_IPSR_GPSR(IP5_11_8,	VI1_HSYNC_N),
	PINMUX_IPSR_GPSR(IP5_11_8,	MSIOF1_SCK),
	PINMUX_IPSR_GPSR(IP5_11_8,	D1),

	PINMUX_IPSR_GPSR(IP5_15_12,	VI1_VSYNC_N),
	PINMUX_IPSR_GPSR(IP5_15_12,	MSIOF1_SYNC),
	PINMUX_IPSR_GPSR(IP5_15_12,	D2),

	PINMUX_IPSR_GPSR(IP5_19_16,	VI1_DATA0),
	PINMUX_IPSR_GPSR(IP5_19_16,	MSIOF1_SS1),
	PINMUX_IPSR_GPSR(IP5_19_16,	D3),
	PINMUX_IPSR_GPSR(IP5_19_16,	MMC_WP),

	PINMUX_IPSR_GPSR(IP5_23_20,	VI1_DATA1),
	PINMUX_IPSR_GPSR(IP5_23_20,	MSIOF1_SS2),
	PINMUX_IPSR_GPSR(IP5_23_20,	D4),
	PINMUX_IPSR_GPSR(IP5_23_20,	MMC_CD),

	PINMUX_IPSR_GPSR(IP5_27_24,	VI1_DATA2),
	PINMUX_IPSR_MSEL(IP5_27_24,	CANFD0_TX_B, SEL_CANFD0_1),
	PINMUX_IPSR_GPSR(IP5_27_24,	D5),
	PINMUX_IPSR_GPSR(IP5_27_24,	MMC_DS),

	PINMUX_IPSR_GPSR(IP5_31_28,	VI1_DATA3),
	PINMUX_IPSR_MSEL(IP5_31_28,	CANFD0_RX_B, SEL_CANFD0_1),
	PINMUX_IPSR_GPSR(IP5_31_28,	D6),
	PINMUX_IPSR_GPSR(IP5_31_28,	MMC_CMD),

	/* IPSR6 */
	PINMUX_IPSR_GPSR(IP6_3_0,	VI1_DATA4),
	PINMUX_IPSR_MSEL(IP6_3_0,	CANFD_CLK_B, SEL_CANFD0_1),
	PINMUX_IPSR_GPSR(IP6_3_0,	D7),
	PINMUX_IPSR_GPSR(IP6_3_0,	MMC_D0),

	PINMUX_IPSR_GPSR(IP6_7_4,	VI1_DATA5),
	PINMUX_IPSR_GPSR(IP6_7_4,	D8),
	PINMUX_IPSR_GPSR(IP6_7_4,	MMC_D1),

	PINMUX_IPSR_GPSR(IP6_11_8,	VI1_DATA6),
	PINMUX_IPSR_GPSR(IP6_11_8,	D9),
	PINMUX_IPSR_GPSR(IP6_11_8,	MMC_D2),

	PINMUX_IPSR_GPSR(IP6_15_12,	VI1_DATA7),
	PINMUX_IPSR_GPSR(IP6_15_12,	D10),
	PINMUX_IPSR_GPSR(IP6_15_12,	MMC_D3),

	PINMUX_IPSR_GPSR(IP6_19_16,	VI1_DATA8),
	PINMUX_IPSR_GPSR(IP6_19_16,	D11),
	PINMUX_IPSR_GPSR(IP6_19_16,	MMC_CLK),

	PINMUX_IPSR_GPSR(IP6_23_20,	VI1_DATA9),
	PINMUX_IPSR_MSEL(IP6_23_20,	TCLK1_A, SEL_TMU_0),
	PINMUX_IPSR_GPSR(IP6_23_20,	D12),
	PINMUX_IPSR_GPSR(IP6_23_20,	MMC_D4),

	PINMUX_IPSR_GPSR(IP6_27_24,	VI1_DATA10),
	PINMUX_IPSR_MSEL(IP6_27_24,	TCLK2_A, SEL_TMU_0),
	PINMUX_IPSR_GPSR(IP6_27_24,	D13),
	PINMUX_IPSR_GPSR(IP6_27_24,	MMC_D5),

	PINMUX_IPSR_GPSR(IP6_31_28,	VI1_DATA11),
	PINMUX_IPSR_GPSR(IP6_31_28,	SCL4),
	PINMUX_IPSR_GPSR(IP6_31_28,	D14),
	PINMUX_IPSR_GPSR(IP6_31_28,	MMC_D6),

	/* IPSR7 */
	PINMUX_IPSR_GPSR(IP7_3_0,	VI1_FIELD),
	PINMUX_IPSR_GPSR(IP7_3_0,	SDA4),
	PINMUX_IPSR_GPSR(IP7_3_0,	D15),
	PINMUX_IPSR_GPSR(IP7_3_0,	MMC_D7),

	PINMUX_IPSR_GPSR(IP7_7_4,	SCL0),
	PINMUX_IPSR_GPSR(IP7_7_4,	CLKOUT),

	PINMUX_IPSR_GPSR(IP7_11_8,	SDA0),
	PINMUX_IPSR_GPSR(IP7_11_8,	BS_N),
	PINMUX_IPSR_GPSR(IP7_11_8,	SCK0),
	PINMUX_IPSR_MSEL(IP7_11_8,	HSCK0_B, SEL_HSCIF0_1),

	PINMUX_IPSR_GPSR(IP7_15_12,	SCL1),
	PINMUX_IPSR_GPSR(IP7_15_12,	TPU0TO2),
	PINMUX_IPSR_GPSR(IP7_15_12,	RD_N),
	PINMUX_IPSR_GPSR(IP7_15_12,	CTS0_N),
	PINMUX_IPSR_GPSR(IP7_15_12,	HCTS0_N_B),

	PINMUX_IPSR_GPSR(IP7_19_16,	SDA1),
	PINMUX_IPSR_GPSR(IP7_19_16,	TPU0TO3),
	PINMUX_IPSR_GPSR(IP7_19_16,	WE0_N),
	PINMUX_IPSR_GPSR(IP7_19_16,	RTS0_N_TANS),
	PINMUX_IPSR_MSEL(IP1_23_20,	HRTS0_N_B, SEL_HSCIF0_1),

	PINMUX_IPSR_GPSR(IP7_23_20,	SCL2),
	PINMUX_IPSR_GPSR(IP7_23_20,	WE1_N),
	PINMUX_IPSR_GPSR(IP7_23_20,	RX0),
	PINMUX_IPSR_MSEL(IP7_23_20,	HRX0_B, SEL_HSCIF0_1),

	PINMUX_IPSR_GPSR(IP7_27_24,	SDA2),
	PINMUX_IPSR_GPSR(IP7_27_24,	EX_WAIT0),
	PINMUX_IPSR_GPSR(IP7_27_24,	TX0),
	PINMUX_IPSR_MSEL(IP7_27_24,	HTX0_B, SEL_HSCIF0_1),

	PINMUX_IPSR_GPSR(IP7_31_28,	AVB_AVTP_MATCH),
	PINMUX_IPSR_GPSR(IP7_31_28,	TPU0TO0),

	/* IPSR8 */
	PINMUX_IPSR_GPSR(IP8_3_0,	AVB_AVTP_CAPTURE),
	PINMUX_IPSR_GPSR(IP8_3_0,	TPU0TO1),

	PINMUX_IPSR_MSEL(IP8_7_4,	CANFD0_TX_A, SEL_CANFD0_0),
	PINMUX_IPSR_GPSR(IP8_7_4,	FXR_TXDA),
	PINMUX_IPSR_MSEL(IP8_7_4,	PWM0_B, SEL_PWM0_1),
	PINMUX_IPSR_GPSR(IP8_7_4,	DU_DISP),

	PINMUX_IPSR_MSEL(IP8_11_8,	CANFD0_RX_A, SEL_CANFD0_0),
	PINMUX_IPSR_GPSR(IP8_11_8,	RXDA_EXTFXR),
	PINMUX_IPSR_MSEL(IP8_11_8,	PWM1_B, SEL_PWM1_1),
	PINMUX_IPSR_GPSR(IP8_11_8,	DU_CDE),

	PINMUX_IPSR_GPSR(IP8_15_12,	CANFD1_TX),
	PINMUX_IPSR_GPSR(IP8_15_12,	FXR_TXDB),
	PINMUX_IPSR_MSEL(IP8_15_12,	PWM2_B, SEL_PWM2_1),
	PINMUX_IPSR_MSEL(IP8_15_12,	TCLK1_B, SEL_TMU_1),
	PINMUX_IPSR_MSEL(IP8_15_12,	TX1_B, SEL_SCIF1_1),

	PINMUX_IPSR_GPSR(IP8_19_16,	CANFD1_RX),
	PINMUX_IPSR_GPSR(IP8_19_16,	RXDB_EXTFXR),
	PINMUX_IPSR_MSEL(IP8_19_16,	PWM3_B, SEL_PWM3_1),
	PINMUX_IPSR_MSEL(IP8_19_16,	TCLK2_B, SEL_TMU_1),
	PINMUX_IPSR_MSEL(IP8_19_16,	RX1_B, SEL_SCIF1_1),

	PINMUX_IPSR_MSEL(IP8_23_20,	CANFD_CLK_A, SEL_CANFD0_0),
	PINMUX_IPSR_GPSR(IP8_23_20,	CLK_EXTFXR),
	PINMUX_IPSR_MSEL(IP8_23_20,	PWM4_B, SEL_PWM4_1),
	PINMUX_IPSR_MSEL(IP8_23_20,	SPEEDIN_B, SEL_RSP_1),
	PINMUX_IPSR_MSEL(IP8_23_20,	SCIF_CLK_B, SEL_HSCIF0_1),

	PINMUX_IPSR_GPSR(IP8_27_24,	DIGRF_CLKIN),
	PINMUX_IPSR_GPSR(IP8_27_24,	DIGRF_CLKEN_IN),

	PINMUX_IPSR_GPSR(IP8_31_28,	DIGRF_CLKOUT),
	PINMUX_IPSR_GPSR(IP8_31_28,	DIGRF_CLKEN_OUT),

	/* IPSR9 */
	PINMUX_IPSR_GPSR(IP9_3_0,	IRQ4),
	PINMUX_IPSR_GPSR(IP9_3_0,	VI0_DATA12),

	PINMUX_IPSR_GPSR(IP9_7_4,	IRQ5),
	PINMUX_IPSR_GPSR(IP9_7_4,	VI0_DATA13),

	PINMUX_IPSR_GPSR(IP9_11_8,	MSIOF0_RXD),
	PINMUX_IPSR_GPSR(IP9_11_8,	DU_DR0),
	PINMUX_IPSR_GPSR(IP9_11_8,	VI0_DATA14),

	PINMUX_IPSR_GPSR(IP9_15_12,	MSIOF0_TXD),
	PINMUX_IPSR_GPSR(IP9_15_12,	DU_DR1),
	PINMUX_IPSR_GPSR(IP9_15_12,	VI0_DATA15),

	PINMUX_IPSR_GPSR(IP9_19_16,	MSIOF0_SCK),
	PINMUX_IPSR_GPSR(IP9_19_16,	DU_DG0),
	PINMUX_IPSR_GPSR(IP9_19_16,	VI0_DATA16),

	PINMUX_IPSR_GPSR(IP9_23_20,	MSIOF0_SYNC),
	PINMUX_IPSR_GPSR(IP9_23_20,	DU_DG1),
	PINMUX_IPSR_GPSR(IP9_23_20,	VI0_DATA17),

	PINMUX_IPSR_GPSR(IP9_27_24,	MSIOF0_SS1),
	PINMUX_IPSR_GPSR(IP9_27_24,	DU_DB0),
	PINMUX_IPSR_GPSR(IP9_27_24,	TCLK3),
	PINMUX_IPSR_GPSR(IP9_27_24,	VI0_DATA18),

	PINMUX_IPSR_GPSR(IP9_31_28,	MSIOF0_SS2),
	PINMUX_IPSR_GPSR(IP9_31_28,	DU_DB1),
	PINMUX_IPSR_GPSR(IP9_31_28,	TCLK4),
	PINMUX_IPSR_GPSR(IP9_31_28,	VI0_DATA19),

	/* IPSR10 */
	PINMUX_IPSR_GPSR(IP10_3_0,	SCL3),
	PINMUX_IPSR_GPSR(IP10_3_0,	VI0_DATA20),

	PINMUX_IPSR_GPSR(IP10_7_4,	SDA3),
	PINMUX_IPSR_GPSR(IP10_7_4,	VI0_DATA21),

	PINMUX_IPSR_GPSR(IP10_11_8,	FSO_CFE_0_N),
	PINMUX_IPSR_GPSR(IP10_11_8,	VI0_DATA22),

	PINMUX_IPSR_GPSR(IP10_15_12,	FSO_CFE_1_N),
	PINMUX_IPSR_GPSR(IP10_15_12,	VI0_DATA23),

	PINMUX_IPSR_GPSR(IP10_19_16,	FSO_TOE_N),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	PINMUX_GPIO_GP_ALL(),
};

/* - AVB -------------------------------------------------------------------- */
static const unsigned int avb_link_pins[] = {
	/* AVB_LINK */
	RCAR_GP_PIN(1, 18),
};
static const unsigned int avb_link_mux[] = {
	AVB_LINK_MARK,
};
static const unsigned int avb_magic_pins[] = {
	/* AVB_MAGIC */
	RCAR_GP_PIN(1, 16),
};
static const unsigned int avb_magic_mux[] = {
	AVB_MAGIC_MARK,
};
static const unsigned int avb_phy_int_pins[] = {
	/* AVB_PHY_INT */
	RCAR_GP_PIN(1, 17),
};
static const unsigned int avb_phy_int_mux[] = {
	AVB_PHY_INT_MARK,
};
static const unsigned int avb_mdio_pins[] = {
	/* AVB_MDC, AVB_MDIO */
	RCAR_GP_PIN(1, 15), RCAR_GP_PIN(1, 14),
};
static const unsigned int avb_mdio_mux[] = {
	AVB_MDC_MARK, AVB_MDIO_MARK,
};
static const unsigned int avb_rgmii_pins[] = {
	/*
	 * AVB_TX_CTL, AVB_TXC, AVB_TD0, AVB_TD1, AVB_TD2, AVB_TD3,
	 * AVB_RX_CTL, AVB_RXC, AVB_RD0, AVB_RD1, AVB_RD2, AVB_RD3,
	 */
	RCAR_GP_PIN(1, 7), RCAR_GP_PIN(1, 8),
	RCAR_GP_PIN(1, 9), RCAR_GP_PIN(1, 10),
	RCAR_GP_PIN(1, 11), RCAR_GP_PIN(1, 12),
	RCAR_GP_PIN(1, 1), RCAR_GP_PIN(1, 2),
	RCAR_GP_PIN(1, 3), RCAR_GP_PIN(1, 4),
	RCAR_GP_PIN(1, 5), RCAR_GP_PIN(1, 6),
};
static const unsigned int avb_rgmii_mux[] = {
	AVB_TX_CTL_MARK, AVB_TXC_MARK,
	AVB_TD0_MARK, AVB_TD1_MARK, AVB_TD2_MARK, AVB_TD3_MARK,
	AVB_RX_CTL_MARK, AVB_RXC_MARK,
	AVB_RD0_MARK, AVB_RD1_MARK, AVB_RD2_MARK, AVB_RD3_MARK,
};
static const unsigned int avb_txcrefclk_pins[] = {
	/* AVB_TXCREFCLK */
	RCAR_GP_PIN(1, 13),
};
static const unsigned int avb_txcrefclk_mux[] = {
	AVB_TXCREFCLK_MARK,
};
static const unsigned int avb_avtp_pps_pins[] = {
	/* AVB_AVTP_PPS */
	RCAR_GP_PIN(2, 6),
};
static const unsigned int avb_avtp_pps_mux[] = {
	AVB_AVTP_PPS_MARK,
};
static const unsigned int avb_avtp_capture_pins[] = {
	/* AVB_AVTP_CAPTURE */
	RCAR_GP_PIN(1, 20),
};
static const unsigned int avb_avtp_capture_mux[] = {
	AVB_AVTP_CAPTURE_MARK,
};
static const unsigned int avb_avtp_match_pins[] = {
	/* AVB_AVTP_MATCH */
	RCAR_GP_PIN(1, 19),
};
static const unsigned int avb_avtp_match_mux[] = {
	AVB_AVTP_MATCH_MARK,
};

/* - CANFD0 ----------------------------------------------------------------- */
static const unsigned int canfd0_data_a_pins[] = {
	/* CANFD0_TX, CANFD0_RX */
	RCAR_GP_PIN(1, 21), RCAR_GP_PIN(1, 22),
};
static const unsigned int canfd0_data_a_mux[] = {
	CANFD0_TX_A_MARK, CANFD0_RX_A_MARK,
};
static const unsigned int canfd0_data_b_pins[] = {
	/* CANFD0_TX, CANFD0_RX */
	RCAR_GP_PIN(3, 6), RCAR_GP_PIN(3, 7),
};
static const unsigned int canfd0_data_b_mux[] = {
	CANFD0_TX_B_MARK, CANFD0_RX_B_MARK,
};

/* - CANFD1 ----------------------------------------------------------------- */
static const unsigned int canfd1_data_pins[] = {
	/* CANFD1_TX, CANFD1_RX */
	RCAR_GP_PIN(1, 23), RCAR_GP_PIN(1, 24),
};
static const unsigned int canfd1_data_mux[] = {
	CANFD1_TX_MARK, CANFD1_RX_MARK,
};

/* - CANFD Clock ------------------------------------------------------------ */
static const unsigned int canfd_clk_a_pins[] = {
	/* CANFD_CLK */
	RCAR_GP_PIN(1, 25),
};
static const unsigned int canfd_clk_a_mux[] = {
	CANFD_CLK_A_MARK,
};
static const unsigned int canfd_clk_b_pins[] = {
	/* CANFD_CLK */
	RCAR_GP_PIN(3, 8),
};
static const unsigned int canfd_clk_b_mux[] = {
	CANFD_CLK_B_MARK,
};

/* - DU --------------------------------------------------------------------- */
static const unsigned int du_rgb666_pins[] = {
	/* DU_DR[7:2], DU_DG[7:2], DU_DB[7:2] */
	RCAR_GP_PIN(0, 5), RCAR_GP_PIN(0, 4), RCAR_GP_PIN(0, 3),
	RCAR_GP_PIN(0, 2), RCAR_GP_PIN(0, 1), RCAR_GP_PIN(0, 0),
	RCAR_GP_PIN(0, 11), RCAR_GP_PIN(0, 10), RCAR_GP_PIN(0, 9),
	RCAR_GP_PIN(0, 8), RCAR_GP_PIN(0, 7), RCAR_GP_PIN(0, 6),
	RCAR_GP_PIN(0, 17), RCAR_GP_PIN(0, 16), RCAR_GP_PIN(0, 15),
	RCAR_GP_PIN(0, 14), RCAR_GP_PIN(0, 13), RCAR_GP_PIN(0, 12),
};
static const unsigned int du_rgb666_mux[] = {
	DU_DR7_MARK, DU_DR6_MARK, DU_DR5_MARK,
	DU_DR4_MARK, DU_DR3_MARK, DU_DR2_MARK,
	DU_DG7_MARK, DU_DG6_MARK, DU_DG5_MARK,
	DU_DG4_MARK, DU_DG3_MARK, DU_DG2_MARK,
	DU_DB7_MARK, DU_DB6_MARK, DU_DB5_MARK,
	DU_DB4_MARK, DU_DB3_MARK, DU_DB2_MARK,
};
static const unsigned int du_rgb888_pins[] = {
	/* DU_DR[7:0], DU_DG[7:0], DU_DB[7:0] */
	RCAR_GP_PIN(0, 5), RCAR_GP_PIN(0, 4), RCAR_GP_PIN(0, 3),
	RCAR_GP_PIN(0, 2), RCAR_GP_PIN(0, 1), RCAR_GP_PIN(0, 0),
	RCAR_GP_PIN(2, 20), RCAR_GP_PIN(2, 19),
	RCAR_GP_PIN(0, 11), RCAR_GP_PIN(0, 10), RCAR_GP_PIN(0, 9),
	RCAR_GP_PIN(0, 8), RCAR_GP_PIN(0, 7), RCAR_GP_PIN(0, 6),
	RCAR_GP_PIN(2, 22), RCAR_GP_PIN(2, 21),
	RCAR_GP_PIN(0, 17), RCAR_GP_PIN(0, 16), RCAR_GP_PIN(0, 15),
	RCAR_GP_PIN(0, 14), RCAR_GP_PIN(0, 13), RCAR_GP_PIN(0, 12),
	RCAR_GP_PIN(2, 24), RCAR_GP_PIN(2, 23),
};
static const unsigned int du_rgb888_mux[] = {
	DU_DR7_MARK, DU_DR6_MARK, DU_DR5_MARK,
	DU_DR4_MARK, DU_DR3_MARK, DU_DR2_MARK,
	DU_DR1_MARK, DU_DR0_MARK,
	DU_DG7_MARK, DU_DG6_MARK, DU_DG5_MARK,
	DU_DG4_MARK, DU_DG3_MARK, DU_DG2_MARK,
	DU_DG1_MARK, DU_DG0_MARK,
	DU_DB7_MARK, DU_DB6_MARK, DU_DB5_MARK,
	DU_DB4_MARK, DU_DB3_MARK, DU_DB2_MARK,
	DU_DB1_MARK, DU_DB0_MARK,
};
static const unsigned int du_clk_out_pins[] = {
	/* DU_DOTCLKOUT */
	RCAR_GP_PIN(0, 18),
};
static const unsigned int du_clk_out_mux[] = {
	DU_DOTCLKOUT_MARK,
};
static const unsigned int du_sync_pins[] = {
	/* DU_EXVSYNC/DU_VSYNC, DU_EXHSYNC/DU_HSYNC */
	RCAR_GP_PIN(0, 20), RCAR_GP_PIN(0, 19),
};
static const unsigned int du_sync_mux[] = {
	DU_EXVSYNC_DU_VSYNC_MARK, DU_EXHSYNC_DU_HSYNC_MARK,
};
static const unsigned int du_oddf_pins[] = {
	/* DU_EXODDF/DU_ODDF/DISP/CDE */
	RCAR_GP_PIN(0, 21),
};
static const unsigned int du_oddf_mux[] = {
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK,
};
static const unsigned int du_cde_pins[] = {
	/* DU_CDE */
	RCAR_GP_PIN(1, 22),
};
static const unsigned int du_cde_mux[] = {
	DU_CDE_MARK,
};
static const unsigned int du_disp_pins[] = {
	/* DU_DISP */
	RCAR_GP_PIN(1, 21),
};
static const unsigned int du_disp_mux[] = {
	DU_DISP_MARK,
};

/* - GETHER ----------------------------------------------------------------- */
static const unsigned int gether_link_a_pins[] = {
	/* GETHER_LINK */
	RCAR_GP_PIN(4, 24),
};
static const unsigned int gether_link_a_mux[] = {
	GETHER_LINK_A_MARK,
};
static const unsigned int gether_phy_int_a_pins[] = {
	/* GETHER_PHY_INT */
	RCAR_GP_PIN(4, 23),
};
static const unsigned int gether_phy_int_a_mux[] = {
	GETHER_PHY_INT_A_MARK,
};
static const unsigned int gether_mdio_a_pins[] = {
	/* GETHER_MDC, GETHER_MDIO */
	RCAR_GP_PIN(4, 21), RCAR_GP_PIN(4, 20),
};
static const unsigned int gether_mdio_a_mux[] = {
	GETHER_MDC_A_MARK, GETHER_MDIO_A_MARK,
};
static const unsigned int gether_link_b_pins[] = {
	/* GETHER_LINK */
	RCAR_GP_PIN(0, 18),
};
static const unsigned int gether_link_b_mux[] = {
	GETHER_LINK_B_MARK,
};
static const unsigned int gether_phy_int_b_pins[] = {
	/* GETHER_PHY_INT */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int gether_phy_int_b_mux[] = {
	GETHER_PHY_INT_B_MARK,
};
static const unsigned int gether_mdio_b_mux[] = {
	GETHER_MDC_B_MARK, GETHER_MDIO_B_MARK,
};
static const unsigned int gether_mdio_b_pins[] = {
	/* GETHER_MDC, GETHER_MDIO */
	RCAR_GP_PIN(0, 9), RCAR_GP_PIN(0, 10),
};
static const unsigned int gether_magic_pins[] = {
	/* GETHER_MAGIC */
	RCAR_GP_PIN(4, 22),
};
static const unsigned int gether_magic_mux[] = {
	GETHER_MAGIC_MARK,
};
static const unsigned int gether_rgmii_pins[] = {
	/*
	 * GETHER_TX_CTL, GETHER_TXC,
	 * GETHER_TD0, GETHER_TD1, GETHER_TD2, GETHER_TD3,
	 * GETHER_RX_CTL, GETHER_RXC,
	 * GETHER_RD0, GETHER_RD1, GETHER_RD2, GETHER_RD3,
	 */
	RCAR_GP_PIN(4, 12), RCAR_GP_PIN(4, 13),
	RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 15),
	RCAR_GP_PIN(4, 16), RCAR_GP_PIN(4, 17),
	RCAR_GP_PIN(4, 6), RCAR_GP_PIN(4, 7),
	RCAR_GP_PIN(4, 8), RCAR_GP_PIN(4, 9),
	RCAR_GP_PIN(4, 10), RCAR_GP_PIN(4, 11),
};
static const unsigned int gether_rgmii_mux[] = {
	GETHER_TX_CTL_MARK, GETHER_TXC_MARK,
	GETHER_TD0_MARK, GETHER_TD1_MARK,
	GETHER_TD2_MARK, GETHER_TD3_MARK,
	GETHER_RX_CTL_MARK, GETHER_RXC_MARK,
	GETHER_RD0_MARK, AVB_RD1_MARK,
	GETHER_RD2_MARK, AVB_RD3_MARK,
};
static const unsigned int gether_txcrefclk_pins[] = {
	/* GETHER_TXCREFCLK */
	RCAR_GP_PIN(4, 18),
};
static const unsigned int gether_txcrefclk_mux[] = {
	GETHER_TXCREFCLK_MARK,
};
static const unsigned int gether_txcrefclk_mega_pins[] = {
	/* GETHER_TXCREFCLK_MEGA */
	RCAR_GP_PIN(4, 19),
};
static const unsigned int gether_txcrefclk_mega_mux[] = {
	GETHER_TXCREFCLK_MEGA_MARK,
};
static const unsigned int gether_rmii_pins[] = {
	/*
	 * GETHER_RMII_CRS_DV, GETHER_RMII_RX_ER,
	 * GETHER_RMII_RXD0, GETHER_RMII_RXD1,
	 * GETHER_RMII_TXD_EN, GETHER_RMII_TXD0,
	 * GETHER_RMII_TXD1, GETHER_RMII_REFCLK
	 */
	RCAR_GP_PIN(0, 0), RCAR_GP_PIN(0, 1),
	RCAR_GP_PIN(0, 2), RCAR_GP_PIN(0, 3),
	RCAR_GP_PIN(0, 4), RCAR_GP_PIN(0, 5),
	RCAR_GP_PIN(0, 6), RCAR_GP_PIN(0, 7),
};
static const unsigned int gether_rmii_mux[] = {
	GETHER_RMII_CRS_DV_MARK, GETHER_RMII_RX_ER_MARK,
	GETHER_RMII_RXD0_MARK, GETHER_RMII_RXD1_MARK,
	GETHER_RMII_TXD_EN_MARK, GETHER_RMII_TXD0_MARK,
	GETHER_RMII_TXD1_MARK, GETHER_RMII_REFCLK_MARK,
};

/* - HSCIF0 ----------------------------------------------------------------- */
static const unsigned int hscif0_data_a_pins[] = {
	/* HRX0, HTX0 */
	RCAR_GP_PIN(0, 11), RCAR_GP_PIN(0, 15),
};
static const unsigned int hscif0_data_a_mux[] = {
	HRX0_A_MARK, HTX0_A_MARK,
};
static const unsigned int hscif0_clk_a_pins[] = {
	/* HSCK0 */
	RCAR_GP_PIN(0, 12),
};
static const unsigned int hscif0_clk_a_mux[] = {
	HSCK0_A_MARK,
};
static const unsigned int hscif0_ctrl_a_pins[] = {
	/* HRTS0#, HCTS0# */
	RCAR_GP_PIN(0, 13), RCAR_GP_PIN(0, 14),
};
static const unsigned int hscif0_ctrl_a_mux[] = {
	HRTS0_N_A_MARK, HCTS0_N_A_MARK,
};
static const unsigned int hscif0_data_b_pins[] = {
	/* HRX0, HTX0 */
	RCAR_GP_PIN(4, 4), RCAR_GP_PIN(4, 5),
};
static const unsigned int hscif0_data_b_mux[] = {
	HRX0_B_MARK, HTX0_B_MARK,
};
static const unsigned int hscif0_clk_b_pins[] = {
	/* HSCK0 */
	RCAR_GP_PIN(4, 1),
};
static const unsigned int hscif0_clk_b_mux[] = {
	HSCK0_B_MARK,
};
static const unsigned int hscif0_ctrl_b_pins[] = {
	/* HRTS0#, HCTS0# */
	RCAR_GP_PIN(4, 3), RCAR_GP_PIN(4, 2),
};
static const unsigned int hscif0_ctrl_b_mux[] = {
	HRTS0_N_B_MARK, HCTS0_N_B_MARK,
};

/* - HSCIF1 ----------------------------------------------------------------- */
static const unsigned int hscif1_data_pins[] = {
	/* HRX1, HTX1 */
	RCAR_GP_PIN(2, 11), RCAR_GP_PIN(2, 10),
};
static const unsigned int hscif1_data_mux[] = {
	HRX1_MARK, HTX1_MARK,
};
static const unsigned int hscif1_clk_pins[] = {
	/* HSCK1 */
	RCAR_GP_PIN(2, 7),
};
static const unsigned int hscif1_clk_mux[] = {
	HSCK1_MARK,
};
static const unsigned int hscif1_ctrl_pins[] = {
	/* HRTS1#, HCTS1# */
	RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 9),
};
static const unsigned int hscif1_ctrl_mux[] = {
	HRTS1_N_MARK, HCTS1_N_MARK,
};

/* - HSCIF2 ----------------------------------------------------------------- */
static const unsigned int hscif2_data_pins[] = {
	/* HRX2, HTX2 */
	RCAR_GP_PIN(2, 16), RCAR_GP_PIN(2, 15),
};
static const unsigned int hscif2_data_mux[] = {
	HRX2_MARK, HTX2_MARK,
};
static const unsigned int hscif2_clk_pins[] = {
	/* HSCK2 */
	RCAR_GP_PIN(2, 12),
};
static const unsigned int hscif2_clk_mux[] = {
	HSCK2_MARK,
};
static const unsigned int hscif2_ctrl_pins[] = {
	/* HRTS2#, HCTS2# */
	RCAR_GP_PIN(2, 14), RCAR_GP_PIN(2, 13),
};
static const unsigned int hscif2_ctrl_mux[] = {
	HRTS2_N_MARK, HCTS2_N_MARK,
};

/* - HSCIF3 ----------------------------------------------------------------- */
static const unsigned int hscif3_data_pins[] = {
	/* HRX3, HTX3 */
	RCAR_GP_PIN(2, 4), RCAR_GP_PIN(2, 3),
};
static const unsigned int hscif3_data_mux[] = {
	HRX3_MARK, HTX3_MARK,
};
static const unsigned int hscif3_clk_pins[] = {
	/* HSCK3 */
	RCAR_GP_PIN(2, 0),
};
static const unsigned int hscif3_clk_mux[] = {
	HSCK3_MARK,
};
static const unsigned int hscif3_ctrl_pins[] = {
	/* HRTS3#, HCTS3# */
	RCAR_GP_PIN(2, 2), RCAR_GP_PIN(2, 1),
};
static const unsigned int hscif3_ctrl_mux[] = {
	HRTS3_N_MARK, HCTS3_N_MARK,
};

/* - I2C0 ------------------------------------------------------------------- */
static const unsigned int i2c0_pins[] = {
	/* SDA0, SCL0 */
	RCAR_GP_PIN(4, 1), RCAR_GP_PIN(4, 0),
};
static const unsigned int i2c0_mux[] = {
	SDA0_MARK, SCL0_MARK,
};

/* - I2C1 ------------------------------------------------------------------- */
static const unsigned int i2c1_pins[] = {
	/* SDA1, SCL1 */
	RCAR_GP_PIN(4, 3), RCAR_GP_PIN(4, 2),
};
static const unsigned int i2c1_mux[] = {
	SDA1_MARK, SCL1_MARK,
};

/* - I2C2 ------------------------------------------------------------------- */
static const unsigned int i2c2_pins[] = {
	/* SDA2, SCL2 */
	RCAR_GP_PIN(4, 5), RCAR_GP_PIN(4, 4),
};
static const unsigned int i2c2_mux[] = {
	SDA2_MARK, SCL2_MARK,
};

/* - I2C3 ------------------------------------------------------------------- */
static const unsigned int i2c3_pins[] = {
	/* SDA3, SCL3 */
	RCAR_GP_PIN(2, 26), RCAR_GP_PIN(2, 25),
};
static const unsigned int i2c3_mux[] = {
	SDA3_MARK, SCL3_MARK,
};

/* - I2C4 ------------------------------------------------------------------- */
static const unsigned int i2c4_pins[] = {
	/* SDA4, SCL4 */
	RCAR_GP_PIN(3, 16), RCAR_GP_PIN(3, 15),
};
static const unsigned int i2c4_mux[] = {
	SDA4_MARK, SCL4_MARK,
};

/* - I2C5 ------------------------------------------------------------------- */
static const unsigned int i2c5_pins[] = {
	/* SDA5, SCL5 */
	RCAR_GP_PIN(0, 9), RCAR_GP_PIN(0, 8),
};
static const unsigned int i2c5_mux[] = {
	SDA5_MARK, SCL5_MARK,
};

/* - INTC-EX ---------------------------------------------------------------- */
static const unsigned int intc_ex_irq0_pins[] = {
	/* IRQ0 */
	RCAR_GP_PIN(1, 0),
};
static const unsigned int intc_ex_irq0_mux[] = {
	IRQ0_MARK,
};
static const unsigned int intc_ex_irq1_pins[] = {
	/* IRQ1 */
	RCAR_GP_PIN(0, 12),
};
static const unsigned int intc_ex_irq1_mux[] = {
	IRQ1_MARK,
};
static const unsigned int intc_ex_irq2_pins[] = {
	/* IRQ2 */
	RCAR_GP_PIN(0, 13),
};
static const unsigned int intc_ex_irq2_mux[] = {
	IRQ2_MARK,
};
static const unsigned int intc_ex_irq3_pins[] = {
	/* IRQ3 */
	RCAR_GP_PIN(0, 14),
};
static const unsigned int intc_ex_irq3_mux[] = {
	IRQ3_MARK,
};
static const unsigned int intc_ex_irq4_pins[] = {
	/* IRQ4 */
	RCAR_GP_PIN(2, 17),
};
static const unsigned int intc_ex_irq4_mux[] = {
	IRQ4_MARK,
};
static const unsigned int intc_ex_irq5_pins[] = {
	/* IRQ5 */
	RCAR_GP_PIN(2, 18),
};
static const unsigned int intc_ex_irq5_mux[] = {
	IRQ5_MARK,
};

/* - MMC -------------------------------------------------------------------- */
static const unsigned int mmc_data1_pins[] = {
	/* MMC_D0 */
	RCAR_GP_PIN(3, 8),
};
static const unsigned int mmc_data1_mux[] = {
	MMC_D0_MARK,
};
static const unsigned int mmc_data4_pins[] = {
	/* MMC_D[0:3] */
	RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
};
static const unsigned int mmc_data4_mux[] = {
	MMC_D0_MARK, MMC_D1_MARK,
	MMC_D2_MARK, MMC_D3_MARK,
};
static const unsigned int mmc_data8_pins[] = {
	/* MMC_D[0:7] */
	RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
	RCAR_GP_PIN(3, 13), RCAR_GP_PIN(3, 14),
	RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 16),
};
static const unsigned int mmc_data8_mux[] = {
	MMC_D0_MARK, MMC_D1_MARK,
	MMC_D2_MARK, MMC_D3_MARK,
	MMC_D4_MARK, MMC_D5_MARK,
	MMC_D6_MARK, MMC_D7_MARK,
};
static const unsigned int mmc_ctrl_pins[] = {
	/* MMC_CLK, MMC_CMD */
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 7),
};
static const unsigned int mmc_ctrl_mux[] = {
	MMC_CLK_MARK, MMC_CMD_MARK,
};
static const unsigned int mmc_cd_pins[] = {
	/* MMC_CD */
	RCAR_GP_PIN(3, 5),
};
static const unsigned int mmc_cd_mux[] = {
	MMC_CD_MARK,
};
static const unsigned int mmc_wp_pins[] = {
	/* MMC_WP */
	RCAR_GP_PIN(3, 4),
};
static const unsigned int mmc_wp_mux[] = {
	MMC_WP_MARK,
};
static const unsigned int mmc_ds_pins[] = {
	/* MMC_DS */
	RCAR_GP_PIN(3, 6),
};
static const unsigned int mmc_ds_mux[] = {
	MMC_DS_MARK,
};

/* - MSIOF0 ----------------------------------------------------------------- */
static const unsigned int msiof0_clk_pins[] = {
	/* MSIOF0_SCK */
	RCAR_GP_PIN(2, 21),
};
static const unsigned int msiof0_clk_mux[] = {
	MSIOF0_SCK_MARK,
};
static const unsigned int msiof0_sync_pins[] = {
	/* MSIOF0_SYNC */
	RCAR_GP_PIN(2, 22),
};
static const unsigned int msiof0_sync_mux[] = {
	MSIOF0_SYNC_MARK,
};
static const unsigned int msiof0_ss1_pins[] = {
	/* MSIOF0_SS1 */
	RCAR_GP_PIN(2, 23),
};
static const unsigned int msiof0_ss1_mux[] = {
	MSIOF0_SS1_MARK,
};
static const unsigned int msiof0_ss2_pins[] = {
	/* MSIOF0_SS2 */
	RCAR_GP_PIN(2, 24),
};
static const unsigned int msiof0_ss2_mux[] = {
	MSIOF0_SS2_MARK,
};
static const unsigned int msiof0_txd_pins[] = {
	/* MSIOF0_TXD */
	RCAR_GP_PIN(2, 20),
};
static const unsigned int msiof0_txd_mux[] = {
	MSIOF0_TXD_MARK,
};
static const unsigned int msiof0_rxd_pins[] = {
	/* MSIOF0_RXD */
	RCAR_GP_PIN(2, 19),
};
static const unsigned int msiof0_rxd_mux[] = {
	MSIOF0_RXD_MARK,
};

/* - MSIOF1 ----------------------------------------------------------------- */
static const unsigned int msiof1_clk_pins[] = {
	/* MSIOF1_SCK */
	RCAR_GP_PIN(3, 2),
};
static const unsigned int msiof1_clk_mux[] = {
	MSIOF1_SCK_MARK,
};
static const unsigned int msiof1_sync_pins[] = {
	/* MSIOF1_SYNC */
	RCAR_GP_PIN(3, 3),
};
static const unsigned int msiof1_sync_mux[] = {
	MSIOF1_SYNC_MARK,
};
static const unsigned int msiof1_ss1_pins[] = {
	/* MSIOF1_SS1 */
	RCAR_GP_PIN(3, 4),
};
static const unsigned int msiof1_ss1_mux[] = {
	MSIOF1_SS1_MARK,
};
static const unsigned int msiof1_ss2_pins[] = {
	/* MSIOF1_SS2 */
	RCAR_GP_PIN(3, 5),
};
static const unsigned int msiof1_ss2_mux[] = {
	MSIOF1_SS2_MARK,
};
static const unsigned int msiof1_txd_pins[] = {
	/* MSIOF1_TXD */
	RCAR_GP_PIN(3, 1),
};
static const unsigned int msiof1_txd_mux[] = {
	MSIOF1_TXD_MARK,
};
static const unsigned int msiof1_rxd_pins[] = {
	/* MSIOF1_RXD */
	RCAR_GP_PIN(3, 0),
};
static const unsigned int msiof1_rxd_mux[] = {
	MSIOF1_RXD_MARK,
};

/* - MSIOF2 ----------------------------------------------------------------- */
static const unsigned int msiof2_clk_pins[] = {
	/* MSIOF2_SCK */
	RCAR_GP_PIN(2, 0),
};
static const unsigned int msiof2_clk_mux[] = {
	MSIOF2_SCK_MARK,
};
static const unsigned int msiof2_sync_pins[] = {
	/* MSIOF2_SYNC */
	RCAR_GP_PIN(2, 3),
};
static const unsigned int msiof2_sync_mux[] = {
	MSIOF2_SYNC_MARK,
};
static const unsigned int msiof2_ss1_pins[] = {
	/* MSIOF2_SS1 */
	RCAR_GP_PIN(2, 4),
};
static const unsigned int msiof2_ss1_mux[] = {
	MSIOF2_SS1_MARK,
};
static const unsigned int msiof2_ss2_pins[] = {
	/* MSIOF2_SS2 */
	RCAR_GP_PIN(2, 5),
};
static const unsigned int msiof2_ss2_mux[] = {
	MSIOF2_SS2_MARK,
};
static const unsigned int msiof2_txd_pins[] = {
	/* MSIOF2_TXD */
	RCAR_GP_PIN(2, 2),
};
static const unsigned int msiof2_txd_mux[] = {
	MSIOF2_TXD_MARK,
};
static const unsigned int msiof2_rxd_pins[] = {
	/* MSIOF2_RXD */
	RCAR_GP_PIN(2, 1),
};
static const unsigned int msiof2_rxd_mux[] = {
	MSIOF2_RXD_MARK,
};

/* - MSIOF3 ----------------------------------------------------------------- */
static const unsigned int msiof3_clk_pins[] = {
	/* MSIOF3_SCK */
	RCAR_GP_PIN(0, 20),
};
static const unsigned int msiof3_clk_mux[] = {
	MSIOF3_SCK_MARK,
};
static const unsigned int msiof3_sync_pins[] = {
	/* MSIOF3_SYNC */
	RCAR_GP_PIN(0, 21),
};
static const unsigned int msiof3_sync_mux[] = {
	MSIOF3_SYNC_MARK,
};
static const unsigned int msiof3_ss1_pins[] = {
	/* MSIOF3_SS1 */
	RCAR_GP_PIN(0, 18),
};
static const unsigned int msiof3_ss1_mux[] = {
	MSIOF3_SS1_MARK,
};
static const unsigned int msiof3_ss2_pins[] = {
	/* MSIOF3_SS2 */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int msiof3_ss2_mux[] = {
	MSIOF3_SS2_MARK,
};
static const unsigned int msiof3_txd_pins[] = {
	/* MSIOF3_TXD */
	RCAR_GP_PIN(0, 17),
};
static const unsigned int msiof3_txd_mux[] = {
	MSIOF3_TXD_MARK,
};
static const unsigned int msiof3_rxd_pins[] = {
	/* MSIOF3_RXD */
	RCAR_GP_PIN(0, 16),
};
static const unsigned int msiof3_rxd_mux[] = {
	MSIOF3_RXD_MARK,
};

/* - PWM0 ------------------------------------------------------------------- */
static const unsigned int pwm0_a_pins[] = {
	/* PWM0 */
	RCAR_GP_PIN(0, 15),
};
static const unsigned int pwm0_a_mux[] = {
	PWM0_A_MARK,
};
static const unsigned int pwm0_b_pins[] = {
	/* PWM0 */
	RCAR_GP_PIN(1, 21),
};
static const unsigned int pwm0_b_mux[] = {
	PWM0_B_MARK,
};

/* - PWM1 ------------------------------------------------------------------- */
static const unsigned int pwm1_a_pins[] = {
	/* PWM1 */
	RCAR_GP_PIN(2, 13),
};
static const unsigned int pwm1_a_mux[] = {
	PWM1_A_MARK,
};
static const unsigned int pwm1_b_pins[] = {
	/* PWM1 */
	RCAR_GP_PIN(1, 22),
};
static const unsigned int pwm1_b_mux[] = {
	PWM1_B_MARK,
};

/* - PWM2 ------------------------------------------------------------------- */
static const unsigned int pwm2_a_pins[] = {
	/* PWM2 */
	RCAR_GP_PIN(2, 14),
};
static const unsigned int pwm2_a_mux[] = {
	PWM2_A_MARK,
};
static const unsigned int pwm2_b_pins[] = {
	/* PWM2 */
	RCAR_GP_PIN(1, 23),
};
static const unsigned int pwm2_b_mux[] = {
	PWM2_B_MARK,
};

/* - PWM3 ------------------------------------------------------------------- */
static const unsigned int pwm3_a_pins[] = {
	/* PWM3 */
	RCAR_GP_PIN(2, 15),
};
static const unsigned int pwm3_a_mux[] = {
	PWM3_A_MARK,
};
static const unsigned int pwm3_b_pins[] = {
	/* PWM3 */
	RCAR_GP_PIN(1, 24),
};
static const unsigned int pwm3_b_mux[] = {
	PWM3_B_MARK,
};

/* - PWM4 ------------------------------------------------------------------- */
static const unsigned int pwm4_a_pins[] = {
	/* PWM4 */
	RCAR_GP_PIN(2, 16),
};
static const unsigned int pwm4_a_mux[] = {
	PWM4_A_MARK,
};
static const unsigned int pwm4_b_pins[] = {
	/* PWM4 */
	RCAR_GP_PIN(1, 25),
};
static const unsigned int pwm4_b_mux[] = {
	PWM4_B_MARK,
};

/* - SCIF0 ------------------------------------------------------------------ */
static const unsigned int scif0_data_pins[] = {
	/* RX0, TX0 */
	RCAR_GP_PIN(4, 4), RCAR_GP_PIN(4, 5),
};
static const unsigned int scif0_data_mux[] = {
	RX0_MARK, TX0_MARK,
};
static const unsigned int scif0_clk_pins[] = {
	/* SCK0 */
	RCAR_GP_PIN(4, 1),
};
static const unsigned int scif0_clk_mux[] = {
	SCK0_MARK,
};
static const unsigned int scif0_ctrl_pins[] = {
	/* RTS0#/TANS, CTS0# */
	RCAR_GP_PIN(4, 3), RCAR_GP_PIN(4, 2),
};
static const unsigned int scif0_ctrl_mux[] = {
	RTS0_N_TANS_MARK, CTS0_N_MARK,
};

/* - SCIF1 ------------------------------------------------------------------ */
static const unsigned int scif1_data_a_pins[] = {
	/* RX1, TX1 */
	RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 9),
};
static const unsigned int scif1_data_a_mux[] = {
	RX1_A_MARK, TX1_A_MARK,
};
static const unsigned int scif1_clk_pins[] = {
	/* SCK1 */
	RCAR_GP_PIN(2, 5),
};
static const unsigned int scif1_clk_mux[] = {
	SCK1_MARK,
};
static const unsigned int scif1_ctrl_pins[] = {
	/* RTS1#/TANS, CTS1# */
	RCAR_GP_PIN(2, 11), RCAR_GP_PIN(2, 10),
};
static const unsigned int scif1_ctrl_mux[] = {
	RTS1_N_TANS_MARK, CTS1_N_MARK,
};
static const unsigned int scif1_data_b_pins[] = {
	/* RX1, TX1 */
	RCAR_GP_PIN(1, 24), RCAR_GP_PIN(1, 23),
};
static const unsigned int scif1_data_b_mux[] = {
	RX1_B_MARK, TX1_B_MARK,
};

/* - SCIF3 ------------------------------------------------------------------ */
static const unsigned int scif3_data_pins[] = {
	/* RX3, TX3 */
	RCAR_GP_PIN(2, 1), RCAR_GP_PIN(2, 2),
};
static const unsigned int scif3_data_mux[] = {
	RX3_MARK, TX3_MARK,
};
static const unsigned int scif3_clk_pins[] = {
	/* SCK3 */
	RCAR_GP_PIN(2, 0),
};
static const unsigned int scif3_clk_mux[] = {
	SCK3_MARK,
};
static const unsigned int scif3_ctrl_pins[] = {
	/* RTS3#/TANS, CTS3# */
	RCAR_GP_PIN(2, 4), RCAR_GP_PIN(2, 3),
};
static const unsigned int scif3_ctrl_mux[] = {
	RTS3_N_TANS_MARK, CTS3_N_MARK,
};

/* - SCIF4 ------------------------------------------------------------------ */
static const unsigned int scif4_data_pins[] = {
	/* RX4, TX4 */
	RCAR_GP_PIN(0, 1), RCAR_GP_PIN(0, 2),
};
static const unsigned int scif4_data_mux[] = {
	RX4_MARK, TX4_MARK,
};
static const unsigned int scif4_clk_pins[] = {
	/* SCK4 */
	RCAR_GP_PIN(0, 0),
};
static const unsigned int scif4_clk_mux[] = {
	SCK4_MARK,
};
static const unsigned int scif4_ctrl_pins[] = {
	/* RTS4#/TANS, CTS4# */
	RCAR_GP_PIN(0, 4), RCAR_GP_PIN(0, 3),
};
static const unsigned int scif4_ctrl_mux[] = {
	RTS4_N_TANS_MARK, CTS4_N_MARK,
};

/* - SCIF Clock ------------------------------------------------------------- */
static const unsigned int scif_clk_a_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(0, 10),
};
static const unsigned int scif_clk_a_mux[] = {
	SCIF_CLK_A_MARK,
};
static const unsigned int scif_clk_b_pins[] = {
	/* SCIF_CLK */
	RCAR_GP_PIN(1, 25),
};
static const unsigned int scif_clk_b_mux[] = {
	SCIF_CLK_B_MARK,
};

/* - TMU -------------------------------------------------------------------- */
static const unsigned int tmu_tclk1_a_pins[] = {
	/* TCLK1 */
	RCAR_GP_PIN(3, 13),
};
static const unsigned int tmu_tclk1_a_mux[] = {
	TCLK1_A_MARK,
};
static const unsigned int tmu_tclk1_b_pins[] = {
	/* TCLK1 */
	RCAR_GP_PIN(1, 23),
};
static const unsigned int tmu_tclk1_b_mux[] = {
	TCLK1_B_MARK,
};
static const unsigned int tmu_tclk2_a_pins[] = {
	/* TCLK2 */
	RCAR_GP_PIN(3, 14),
};
static const unsigned int tmu_tclk2_a_mux[] = {
	TCLK2_A_MARK,
};
static const unsigned int tmu_tclk2_b_pins[] = {
	/* TCLK2 */
	RCAR_GP_PIN(1, 24),
};
static const unsigned int tmu_tclk2_b_mux[] = {
	TCLK2_B_MARK,
};

/* - TPU ------------------------------------------------------------------- */
static const unsigned int tpu_to0_pins[] = {
	/* TPU0TO0 */
	RCAR_GP_PIN(1, 19),
};
static const unsigned int tpu_to0_mux[] = {
	TPU0TO0_MARK,
};
static const unsigned int tpu_to1_pins[] = {
	/* TPU0TO1 */
	RCAR_GP_PIN(1, 20),
};
static const unsigned int tpu_to1_mux[] = {
	TPU0TO1_MARK,
};
static const unsigned int tpu_to2_pins[] = {
	/* TPU0TO2 */
	RCAR_GP_PIN(4, 2),
};
static const unsigned int tpu_to2_mux[] = {
	TPU0TO2_MARK,
};
static const unsigned int tpu_to3_pins[] = {
	/* TPU0TO3 */
	RCAR_GP_PIN(4, 3),
};
static const unsigned int tpu_to3_mux[] = {
	TPU0TO3_MARK,
};

/* - VIN0 ------------------------------------------------------------------- */
static const union vin_data vin0_data_pins = {
	.data24 = {
		RCAR_GP_PIN(2, 4), RCAR_GP_PIN(2, 5),
		RCAR_GP_PIN(2, 6), RCAR_GP_PIN(2, 7),
		RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 9),
		RCAR_GP_PIN(2, 10), RCAR_GP_PIN(2, 11),
		RCAR_GP_PIN(2, 12), RCAR_GP_PIN(2, 13),
		RCAR_GP_PIN(2, 14), RCAR_GP_PIN(2, 15),
		RCAR_GP_PIN(2, 17), RCAR_GP_PIN(2, 18),
		RCAR_GP_PIN(2, 19), RCAR_GP_PIN(2, 20),
		RCAR_GP_PIN(2, 21), RCAR_GP_PIN(2, 22),
		RCAR_GP_PIN(2, 23), RCAR_GP_PIN(2, 24),
		RCAR_GP_PIN(2, 25), RCAR_GP_PIN(2, 26),
		RCAR_GP_PIN(2, 27), RCAR_GP_PIN(2, 28),
	},
};
static const union vin_data vin0_data_mux = {
	.data24 = {
		VI0_DATA0_MARK, VI0_DATA1_MARK,
		VI0_DATA2_MARK, VI0_DATA3_MARK,
		VI0_DATA4_MARK, VI0_DATA5_MARK,
		VI0_DATA6_MARK, VI0_DATA7_MARK,
		VI0_DATA8_MARK, VI0_DATA9_MARK,
		VI0_DATA10_MARK, VI0_DATA11_MARK,
		VI0_DATA12_MARK, VI0_DATA13_MARK,
		VI0_DATA14_MARK, VI0_DATA15_MARK,
		VI0_DATA16_MARK, VI0_DATA17_MARK,
		VI0_DATA18_MARK, VI0_DATA19_MARK,
		VI0_DATA20_MARK, VI0_DATA21_MARK,
		VI0_DATA22_MARK, VI0_DATA23_MARK,
	},
};
static const unsigned int vin0_data18_pins[] = {
	RCAR_GP_PIN(2, 6), RCAR_GP_PIN(2, 7),
	RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 9),
	RCAR_GP_PIN(2, 10), RCAR_GP_PIN(2, 11),
	RCAR_GP_PIN(2, 14), RCAR_GP_PIN(2, 15),
	RCAR_GP_PIN(2, 17), RCAR_GP_PIN(2, 18),
	RCAR_GP_PIN(2, 19), RCAR_GP_PIN(2, 20),
	RCAR_GP_PIN(2, 23), RCAR_GP_PIN(2, 24),
	RCAR_GP_PIN(2, 25), RCAR_GP_PIN(2, 26),
	RCAR_GP_PIN(2, 27), RCAR_GP_PIN(2, 28),
};
static const unsigned int vin0_data18_mux[] = {
	VI0_DATA2_MARK, VI0_DATA3_MARK,
	VI0_DATA4_MARK, VI0_DATA5_MARK,
	VI0_DATA6_MARK, VI0_DATA7_MARK,
	VI0_DATA10_MARK, VI0_DATA11_MARK,
	VI0_DATA12_MARK, VI0_DATA13_MARK,
	VI0_DATA14_MARK, VI0_DATA15_MARK,
	VI0_DATA18_MARK, VI0_DATA19_MARK,
	VI0_DATA20_MARK, VI0_DATA21_MARK,
	VI0_DATA22_MARK, VI0_DATA23_MARK,
};
static const unsigned int vin0_sync_pins[] = {
	/* VI0_VSYNC#, VI0_HSYNC# */
	RCAR_GP_PIN(2, 3), RCAR_GP_PIN(2, 2),
};
static const unsigned int vin0_sync_mux[] = {
	VI0_VSYNC_N_MARK, VI0_HSYNC_N_MARK,
};
static const unsigned int vin0_field_pins[] = {
	/* VI0_FIELD */
	RCAR_GP_PIN(2, 16),
};
static const unsigned int vin0_field_mux[] = {
	VI0_FIELD_MARK,
};
static const unsigned int vin0_clkenb_pins[] = {
	/* VI0_CLKENB */
	RCAR_GP_PIN(2, 1),
};
static const unsigned int vin0_clkenb_mux[] = {
	VI0_CLKENB_MARK,
};
static const unsigned int vin0_clk_pins[] = {
	/* VI0_CLK */
	RCAR_GP_PIN(2, 0),
};
static const unsigned int vin0_clk_mux[] = {
	VI0_CLK_MARK,
};

/* - VIN1 ------------------------------------------------------------------- */
static const unsigned int vin1_data8_pins[] = {
	RCAR_GP_PIN(3, 4), RCAR_GP_PIN(3, 5),
	RCAR_GP_PIN(3, 6), RCAR_GP_PIN(3, 7),
	RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
};
static const unsigned int vin1_data8_mux[] = {
	VI1_DATA0_MARK, VI1_DATA1_MARK,
	VI1_DATA2_MARK, VI1_DATA3_MARK,
	VI1_DATA4_MARK, VI1_DATA5_MARK,
	VI1_DATA6_MARK, VI1_DATA7_MARK,
};
static const unsigned int vin1_data10_pins[] = {
	RCAR_GP_PIN(3, 4), RCAR_GP_PIN(3, 5),
	RCAR_GP_PIN(3, 6), RCAR_GP_PIN(3, 7),
	RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13),
};
static const unsigned int vin1_data10_mux[] = {
	VI1_DATA0_MARK, VI1_DATA1_MARK,
	VI1_DATA2_MARK, VI1_DATA3_MARK,
	VI1_DATA4_MARK, VI1_DATA5_MARK,
	VI1_DATA6_MARK, VI1_DATA7_MARK,
	VI1_DATA8_MARK, VI1_DATA9_MARK,
};
static const unsigned int vin1_data12_pins[] = {
	RCAR_GP_PIN(3, 4), RCAR_GP_PIN(3, 5),
	RCAR_GP_PIN(3, 6), RCAR_GP_PIN(3, 7),
	RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13),
	RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 15),
};
static const unsigned int vin1_data12_mux[] = {
	VI1_DATA0_MARK, VI1_DATA1_MARK,
	VI1_DATA2_MARK, VI1_DATA3_MARK,
	VI1_DATA4_MARK, VI1_DATA5_MARK,
	VI1_DATA6_MARK, VI1_DATA7_MARK,
	VI1_DATA8_MARK,  VI1_DATA9_MARK,
	VI1_DATA10_MARK, VI1_DATA11_MARK,
};
static const unsigned int vin1_sync_pins[] = {
	/* VI1_VSYNC#, VI1_HSYNC# */
	 RCAR_GP_PIN(3, 3), RCAR_GP_PIN(3, 2),
};
static const unsigned int vin1_sync_mux[] = {
	VI1_VSYNC_N_MARK, VI1_HSYNC_N_MARK,
};
static const unsigned int vin1_field_pins[] = {
	/* VI1_FIELD */
	RCAR_GP_PIN(3, 16),
};
static const unsigned int vin1_field_mux[] = {
	VI1_FIELD_MARK,
};
static const unsigned int vin1_clkenb_pins[] = {
	/* VI1_CLKENB */
	RCAR_GP_PIN(3, 1),
};
static const unsigned int vin1_clkenb_mux[] = {
	VI1_CLKENB_MARK,
};
static const unsigned int vin1_clk_pins[] = {
	/* VI1_CLK */
	RCAR_GP_PIN(3, 0),
};
static const unsigned int vin1_clk_mux[] = {
	VI1_CLK_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(avb_link),
	SH_PFC_PIN_GROUP(avb_magic),
	SH_PFC_PIN_GROUP(avb_phy_int),
	SH_PFC_PIN_GROUP(avb_mdio),
	SH_PFC_PIN_GROUP(avb_rgmii),
	SH_PFC_PIN_GROUP(avb_txcrefclk),
	SH_PFC_PIN_GROUP(avb_avtp_pps),
	SH_PFC_PIN_GROUP(avb_avtp_capture),
	SH_PFC_PIN_GROUP(avb_avtp_match),
	SH_PFC_PIN_GROUP(canfd0_data_a),
	SH_PFC_PIN_GROUP(canfd0_data_b),
	SH_PFC_PIN_GROUP(canfd1_data),
	SH_PFC_PIN_GROUP(canfd_clk_a),
	SH_PFC_PIN_GROUP(canfd_clk_b),
	SH_PFC_PIN_GROUP(du_rgb666),
	SH_PFC_PIN_GROUP(du_rgb888),
	SH_PFC_PIN_GROUP(du_clk_out),
	SH_PFC_PIN_GROUP(du_sync),
	SH_PFC_PIN_GROUP(du_oddf),
	SH_PFC_PIN_GROUP(du_cde),
	SH_PFC_PIN_GROUP(du_disp),
	SH_PFC_PIN_GROUP(gether_link_a),
	SH_PFC_PIN_GROUP(gether_phy_int_a),
	SH_PFC_PIN_GROUP(gether_mdio_a),
	SH_PFC_PIN_GROUP(gether_link_b),
	SH_PFC_PIN_GROUP(gether_phy_int_b),
	SH_PFC_PIN_GROUP(gether_mdio_b),
	SH_PFC_PIN_GROUP(gether_magic),
	SH_PFC_PIN_GROUP(gether_rgmii),
	SH_PFC_PIN_GROUP(gether_txcrefclk),
	SH_PFC_PIN_GROUP(gether_txcrefclk_mega),
	SH_PFC_PIN_GROUP(gether_rmii),
	SH_PFC_PIN_GROUP(hscif0_data_a),
	SH_PFC_PIN_GROUP(hscif0_clk_a),
	SH_PFC_PIN_GROUP(hscif0_ctrl_a),
	SH_PFC_PIN_GROUP(hscif0_data_b),
	SH_PFC_PIN_GROUP(hscif0_clk_b),
	SH_PFC_PIN_GROUP(hscif0_ctrl_b),
	SH_PFC_PIN_GROUP(hscif1_data),
	SH_PFC_PIN_GROUP(hscif1_clk),
	SH_PFC_PIN_GROUP(hscif1_ctrl),
	SH_PFC_PIN_GROUP(hscif2_data),
	SH_PFC_PIN_GROUP(hscif2_clk),
	SH_PFC_PIN_GROUP(hscif2_ctrl),
	SH_PFC_PIN_GROUP(hscif3_data),
	SH_PFC_PIN_GROUP(hscif3_clk),
	SH_PFC_PIN_GROUP(hscif3_ctrl),
	SH_PFC_PIN_GROUP(i2c0),
	SH_PFC_PIN_GROUP(i2c1),
	SH_PFC_PIN_GROUP(i2c2),
	SH_PFC_PIN_GROUP(i2c3),
	SH_PFC_PIN_GROUP(i2c4),
	SH_PFC_PIN_GROUP(i2c5),
	SH_PFC_PIN_GROUP(intc_ex_irq0),
	SH_PFC_PIN_GROUP(intc_ex_irq1),
	SH_PFC_PIN_GROUP(intc_ex_irq2),
	SH_PFC_PIN_GROUP(intc_ex_irq3),
	SH_PFC_PIN_GROUP(intc_ex_irq4),
	SH_PFC_PIN_GROUP(intc_ex_irq5),
	SH_PFC_PIN_GROUP(mmc_data1),
	SH_PFC_PIN_GROUP(mmc_data4),
	SH_PFC_PIN_GROUP(mmc_data8),
	SH_PFC_PIN_GROUP(mmc_ctrl),
	SH_PFC_PIN_GROUP(mmc_cd),
	SH_PFC_PIN_GROUP(mmc_wp),
	SH_PFC_PIN_GROUP(mmc_ds),
	SH_PFC_PIN_GROUP(msiof0_clk),
	SH_PFC_PIN_GROUP(msiof0_sync),
	SH_PFC_PIN_GROUP(msiof0_ss1),
	SH_PFC_PIN_GROUP(msiof0_ss2),
	SH_PFC_PIN_GROUP(msiof0_txd),
	SH_PFC_PIN_GROUP(msiof0_rxd),
	SH_PFC_PIN_GROUP(msiof1_clk),
	SH_PFC_PIN_GROUP(msiof1_sync),
	SH_PFC_PIN_GROUP(msiof1_ss1),
	SH_PFC_PIN_GROUP(msiof1_ss2),
	SH_PFC_PIN_GROUP(msiof1_txd),
	SH_PFC_PIN_GROUP(msiof1_rxd),
	SH_PFC_PIN_GROUP(msiof2_clk),
	SH_PFC_PIN_GROUP(msiof2_sync),
	SH_PFC_PIN_GROUP(msiof2_ss1),
	SH_PFC_PIN_GROUP(msiof2_ss2),
	SH_PFC_PIN_GROUP(msiof2_txd),
	SH_PFC_PIN_GROUP(msiof2_rxd),
	SH_PFC_PIN_GROUP(msiof3_clk),
	SH_PFC_PIN_GROUP(msiof3_sync),
	SH_PFC_PIN_GROUP(msiof3_ss1),
	SH_PFC_PIN_GROUP(msiof3_ss2),
	SH_PFC_PIN_GROUP(msiof3_txd),
	SH_PFC_PIN_GROUP(msiof3_rxd),
	SH_PFC_PIN_GROUP(pwm0_a),
	SH_PFC_PIN_GROUP(pwm0_b),
	SH_PFC_PIN_GROUP(pwm1_a),
	SH_PFC_PIN_GROUP(pwm1_b),
	SH_PFC_PIN_GROUP(pwm2_a),
	SH_PFC_PIN_GROUP(pwm2_b),
	SH_PFC_PIN_GROUP(pwm3_a),
	SH_PFC_PIN_GROUP(pwm3_b),
	SH_PFC_PIN_GROUP(pwm4_a),
	SH_PFC_PIN_GROUP(pwm4_b),
	SH_PFC_PIN_GROUP(scif0_data),
	SH_PFC_PIN_GROUP(scif0_clk),
	SH_PFC_PIN_GROUP(scif0_ctrl),
	SH_PFC_PIN_GROUP(scif1_data_a),
	SH_PFC_PIN_GROUP(scif1_clk),
	SH_PFC_PIN_GROUP(scif1_ctrl),
	SH_PFC_PIN_GROUP(scif1_data_b),
	SH_PFC_PIN_GROUP(scif3_data),
	SH_PFC_PIN_GROUP(scif3_clk),
	SH_PFC_PIN_GROUP(scif3_ctrl),
	SH_PFC_PIN_GROUP(scif4_data),
	SH_PFC_PIN_GROUP(scif4_clk),
	SH_PFC_PIN_GROUP(scif4_ctrl),
	SH_PFC_PIN_GROUP(scif_clk_a),
	SH_PFC_PIN_GROUP(scif_clk_b),
	SH_PFC_PIN_GROUP(tmu_tclk1_a),
	SH_PFC_PIN_GROUP(tmu_tclk1_b),
	SH_PFC_PIN_GROUP(tmu_tclk2_a),
	SH_PFC_PIN_GROUP(tmu_tclk2_b),
	SH_PFC_PIN_GROUP(tpu_to0),
	SH_PFC_PIN_GROUP(tpu_to1),
	SH_PFC_PIN_GROUP(tpu_to2),
	SH_PFC_PIN_GROUP(tpu_to3),
	VIN_DATA_PIN_GROUP(vin0_data, 8),
	VIN_DATA_PIN_GROUP(vin0_data, 10),
	VIN_DATA_PIN_GROUP(vin0_data, 12),
	VIN_DATA_PIN_GROUP(vin0_data, 16),
	SH_PFC_PIN_GROUP(vin0_data18),
	VIN_DATA_PIN_GROUP(vin0_data, 20),
	VIN_DATA_PIN_GROUP(vin0_data, 24),
	SH_PFC_PIN_GROUP(vin0_sync),
	SH_PFC_PIN_GROUP(vin0_field),
	SH_PFC_PIN_GROUP(vin0_clkenb),
	SH_PFC_PIN_GROUP(vin0_clk),
	SH_PFC_PIN_GROUP(vin1_data8),
	SH_PFC_PIN_GROUP(vin1_data10),
	SH_PFC_PIN_GROUP(vin1_data12),
	SH_PFC_PIN_GROUP(vin1_sync),
	SH_PFC_PIN_GROUP(vin1_field),
	SH_PFC_PIN_GROUP(vin1_clkenb),
	SH_PFC_PIN_GROUP(vin1_clk),
};

static const char * const avb_groups[] = {
	"avb_link",
	"avb_magic",
	"avb_phy_int",
	"avb_mdio",
	"avb_rgmii",
	"avb_txcrefclk",
	"avb_avtp_pps",
	"avb_avtp_capture",
	"avb_avtp_match",
};

static const char * const canfd0_groups[] = {
	"canfd0_data_a",
	"canfd0_data_b",
};

static const char * const canfd1_groups[] = {
	"canfd1_data",
};

static const char * const canfd_clk_groups[] = {
	"canfd_clk_a",
	"canfd_clk_b",
};

static const char * const du_groups[] = {
	"du_rgb666",
	"du_rgb888",
	"du_clk_out",
	"du_sync",
	"du_oddf",
	"du_cde",
	"du_disp",
};

static const char * const gether_groups[] = {
	"gether_link_a",
	"gether_phy_int_a",
	"gether_mdio_a",
	"gether_link_b",
	"gether_phy_int_b",
	"gether_mdio_b",
	"gether_magic",
	"gether_rgmii",
	"gether_txcrefclk",
	"gether_txcrefclk_mega",
	"gether_rmii",
};

static const char * const hscif0_groups[] = {
	"hscif0_data_a",
	"hscif0_clk_a",
	"hscif0_ctrl_a",
	"hscif0_data_b",
	"hscif0_clk_b",
	"hscif0_ctrl_b",
};

static const char * const hscif1_groups[] = {
	"hscif1_data",
	"hscif1_clk",
	"hscif1_ctrl",
};

static const char * const hscif2_groups[] = {
	"hscif2_data",
	"hscif2_clk",
	"hscif2_ctrl",
};

static const char * const hscif3_groups[] = {
	"hscif3_data",
	"hscif3_clk",
	"hscif3_ctrl",
};

static const char * const i2c0_groups[] = {
	"i2c0",
};

static const char * const i2c1_groups[] = {
	"i2c1",
};

static const char * const i2c2_groups[] = {
	"i2c2",
};

static const char * const i2c3_groups[] = {
	"i2c3",
};

static const char * const i2c4_groups[] = {
	"i2c4",
};

static const char * const i2c5_groups[] = {
	"i2c5",
};

static const char * const intc_ex_groups[] = {
	"intc_ex_irq0",
	"intc_ex_irq1",
	"intc_ex_irq2",
	"intc_ex_irq3",
	"intc_ex_irq4",
	"intc_ex_irq5",
};

static const char * const mmc_groups[] = {
	"mmc_data1",
	"mmc_data4",
	"mmc_data8",
	"mmc_ctrl",
	"mmc_cd",
	"mmc_wp",
	"mmc_ds",
};

static const char * const msiof0_groups[] = {
	"msiof0_clk",
	"msiof0_sync",
	"msiof0_ss1",
	"msiof0_ss2",
	"msiof0_txd",
	"msiof0_rxd",
};

static const char * const msiof1_groups[] = {
	"msiof1_clk",
	"msiof1_sync",
	"msiof1_ss1",
	"msiof1_ss2",
	"msiof1_txd",
	"msiof1_rxd",
};

static const char * const msiof2_groups[] = {
	"msiof2_clk",
	"msiof2_sync",
	"msiof2_ss1",
	"msiof2_ss2",
	"msiof2_txd",
	"msiof2_rxd",
};

static const char * const msiof3_groups[] = {
	"msiof3_clk",
	"msiof3_sync",
	"msiof3_ss1",
	"msiof3_ss2",
	"msiof3_txd",
	"msiof3_rxd",
};

static const char * const pwm0_groups[] = {
	"pwm0_a",
	"pwm0_b",
};

static const char * const pwm1_groups[] = {
	"pwm1_a",
	"pwm1_b",
};

static const char * const pwm2_groups[] = {
	"pwm2_a",
	"pwm2_b",
};

static const char * const pwm3_groups[] = {
	"pwm3_a",
	"pwm3_b",
};

static const char * const pwm4_groups[] = {
	"pwm4_a",
	"pwm4_b",
};

static const char * const scif0_groups[] = {
	"scif0_data",
	"scif0_clk",
	"scif0_ctrl",
};

static const char * const scif1_groups[] = {
	"scif1_data_a",
	"scif1_clk",
	"scif1_ctrl",
	"scif1_data_b",
};

static const char * const scif3_groups[] = {
	"scif3_data",
	"scif3_clk",
	"scif3_ctrl",
};

static const char * const scif4_groups[] = {
	"scif4_data",
	"scif4_clk",
	"scif4_ctrl",
};

static const char * const scif_clk_groups[] = {
	"scif_clk_a",
	"scif_clk_b",
};

static const char * const tmu_groups[] = {
	"tmu_tclk1_a",
	"tmu_tclk1_b",
	"tmu_tclk2_a",
	"tmu_tclk2_b",
};

static const char * const tpu_groups[] = {
	"tpu_to0",
	"tpu_to1",
	"tpu_to2",
	"tpu_to3",
};

static const char * const vin0_groups[] = {
	"vin0_data8",
	"vin0_data10",
	"vin0_data12",
	"vin0_data16",
	"vin0_data18",
	"vin0_data20",
	"vin0_data24",
	"vin0_sync",
	"vin0_field",
	"vin0_clkenb",
	"vin0_clk",
};

static const char * const vin1_groups[] = {
	"vin1_data8",
	"vin1_data10",
	"vin1_data12",
	"vin1_sync",
	"vin1_field",
	"vin1_clkenb",
	"vin1_clk",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(avb),
	SH_PFC_FUNCTION(canfd0),
	SH_PFC_FUNCTION(canfd1),
	SH_PFC_FUNCTION(canfd_clk),
	SH_PFC_FUNCTION(du),
	SH_PFC_FUNCTION(gether),
	SH_PFC_FUNCTION(hscif0),
	SH_PFC_FUNCTION(hscif1),
	SH_PFC_FUNCTION(hscif2),
	SH_PFC_FUNCTION(hscif3),
	SH_PFC_FUNCTION(i2c0),
	SH_PFC_FUNCTION(i2c1),
	SH_PFC_FUNCTION(i2c2),
	SH_PFC_FUNCTION(i2c3),
	SH_PFC_FUNCTION(i2c4),
	SH_PFC_FUNCTION(i2c5),
	SH_PFC_FUNCTION(intc_ex),
	SH_PFC_FUNCTION(mmc),
	SH_PFC_FUNCTION(msiof0),
	SH_PFC_FUNCTION(msiof1),
	SH_PFC_FUNCTION(msiof2),
	SH_PFC_FUNCTION(msiof3),
	SH_PFC_FUNCTION(pwm0),
	SH_PFC_FUNCTION(pwm1),
	SH_PFC_FUNCTION(pwm2),
	SH_PFC_FUNCTION(pwm3),
	SH_PFC_FUNCTION(pwm4),
	SH_PFC_FUNCTION(scif0),
	SH_PFC_FUNCTION(scif1),
	SH_PFC_FUNCTION(scif3),
	SH_PFC_FUNCTION(scif4),
	SH_PFC_FUNCTION(scif_clk),
	SH_PFC_FUNCTION(tmu),
	SH_PFC_FUNCTION(tpu),
	SH_PFC_FUNCTION(vin0),
	SH_PFC_FUNCTION(vin1),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
#define F_(x, y)	FN_##y
#define FM(x)		FN_##x
	{ PINMUX_CFG_REG("GPSR0", 0xe6060100, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_0_21_FN,	GPSR0_21,
		GP_0_20_FN,	GPSR0_20,
		GP_0_19_FN,	GPSR0_19,
		GP_0_18_FN,	GPSR0_18,
		GP_0_17_FN,	GPSR0_17,
		GP_0_16_FN,	GPSR0_16,
		GP_0_15_FN,	GPSR0_15,
		GP_0_14_FN,	GPSR0_14,
		GP_0_13_FN,	GPSR0_13,
		GP_0_12_FN,	GPSR0_12,
		GP_0_11_FN,	GPSR0_11,
		GP_0_10_FN,	GPSR0_10,
		GP_0_9_FN,	GPSR0_9,
		GP_0_8_FN,	GPSR0_8,
		GP_0_7_FN,	GPSR0_7,
		GP_0_6_FN,	GPSR0_6,
		GP_0_5_FN,	GPSR0_5,
		GP_0_4_FN,	GPSR0_4,
		GP_0_3_FN,	GPSR0_3,
		GP_0_2_FN,	GPSR0_2,
		GP_0_1_FN,	GPSR0_1,
		GP_0_0_FN,	GPSR0_0, }
	},
	{ PINMUX_CFG_REG("GPSR1", 0xe6060104, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_1_27_FN,	GPSR1_27,
		GP_1_26_FN,	GPSR1_26,
		GP_1_25_FN,	GPSR1_25,
		GP_1_24_FN,	GPSR1_24,
		GP_1_23_FN,	GPSR1_23,
		GP_1_22_FN,	GPSR1_22,
		GP_1_21_FN,	GPSR1_21,
		GP_1_20_FN,	GPSR1_20,
		GP_1_19_FN,	GPSR1_19,
		GP_1_18_FN,	GPSR1_18,
		GP_1_17_FN,	GPSR1_17,
		GP_1_16_FN,	GPSR1_16,
		GP_1_15_FN,	GPSR1_15,
		GP_1_14_FN,	GPSR1_14,
		GP_1_13_FN,	GPSR1_13,
		GP_1_12_FN,	GPSR1_12,
		GP_1_11_FN,	GPSR1_11,
		GP_1_10_FN,	GPSR1_10,
		GP_1_9_FN,	GPSR1_9,
		GP_1_8_FN,	GPSR1_8,
		GP_1_7_FN,	GPSR1_7,
		GP_1_6_FN,	GPSR1_6,
		GP_1_5_FN,	GPSR1_5,
		GP_1_4_FN,	GPSR1_4,
		GP_1_3_FN,	GPSR1_3,
		GP_1_2_FN,	GPSR1_2,
		GP_1_1_FN,	GPSR1_1,
		GP_1_0_FN,	GPSR1_0, }
	},
	{ PINMUX_CFG_REG("GPSR2", 0xe6060108, 32, 1) {
		0, 0,
		0, 0,
		GP_2_29_FN,	GPSR2_29,
		GP_2_28_FN,	GPSR2_28,
		GP_2_27_FN,	GPSR2_27,
		GP_2_26_FN,	GPSR2_26,
		GP_2_25_FN,	GPSR2_25,
		GP_2_24_FN,	GPSR2_24,
		GP_2_23_FN,	GPSR2_23,
		GP_2_22_FN,	GPSR2_22,
		GP_2_21_FN,	GPSR2_21,
		GP_2_20_FN,	GPSR2_20,
		GP_2_19_FN,	GPSR2_19,
		GP_2_18_FN,	GPSR2_18,
		GP_2_17_FN,	GPSR2_17,
		GP_2_16_FN,	GPSR2_16,
		GP_2_15_FN,	GPSR2_15,
		GP_2_14_FN,	GPSR2_14,
		GP_2_13_FN,	GPSR2_13,
		GP_2_12_FN,	GPSR2_12,
		GP_2_11_FN,	GPSR2_11,
		GP_2_10_FN,	GPSR2_10,
		GP_2_9_FN,	GPSR2_9,
		GP_2_8_FN,	GPSR2_8,
		GP_2_7_FN,	GPSR2_7,
		GP_2_6_FN,	GPSR2_6,
		GP_2_5_FN,	GPSR2_5,
		GP_2_4_FN,	GPSR2_4,
		GP_2_3_FN,	GPSR2_3,
		GP_2_2_FN,	GPSR2_2,
		GP_2_1_FN,	GPSR2_1,
		GP_2_0_FN,	GPSR2_0, }
	},
	{ PINMUX_CFG_REG("GPSR3", 0xe606010c, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_3_16_FN,	GPSR3_16,
		GP_3_15_FN,	GPSR3_15,
		GP_3_14_FN,	GPSR3_14,
		GP_3_13_FN,	GPSR3_13,
		GP_3_12_FN,	GPSR3_12,
		GP_3_11_FN,	GPSR3_11,
		GP_3_10_FN,	GPSR3_10,
		GP_3_9_FN,	GPSR3_9,
		GP_3_8_FN,	GPSR3_8,
		GP_3_7_FN,	GPSR3_7,
		GP_3_6_FN,	GPSR3_6,
		GP_3_5_FN,	GPSR3_5,
		GP_3_4_FN,	GPSR3_4,
		GP_3_3_FN,	GPSR3_3,
		GP_3_2_FN,	GPSR3_2,
		GP_3_1_FN,	GPSR3_1,
		GP_3_0_FN,	GPSR3_0, }
	},
	{ PINMUX_CFG_REG("GPSR4", 0xe6060110, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_4_24_FN,	GPSR4_24,
		GP_4_23_FN,	GPSR4_23,
		GP_4_22_FN,	GPSR4_22,
		GP_4_21_FN,	GPSR4_21,
		GP_4_20_FN,	GPSR4_20,
		GP_4_19_FN,	GPSR4_19,
		GP_4_18_FN,	GPSR4_18,
		GP_4_17_FN,	GPSR4_17,
		GP_4_16_FN,	GPSR4_16,
		GP_4_15_FN,	GPSR4_15,
		GP_4_14_FN,	GPSR4_14,
		GP_4_13_FN,	GPSR4_13,
		GP_4_12_FN,	GPSR4_12,
		GP_4_11_FN,	GPSR4_11,
		GP_4_10_FN,	GPSR4_10,
		GP_4_9_FN,	GPSR4_9,
		GP_4_8_FN,	GPSR4_8,
		GP_4_7_FN,	GPSR4_7,
		GP_4_6_FN,	GPSR4_6,
		GP_4_5_FN,	GPSR4_5,
		GP_4_4_FN,	GPSR4_4,
		GP_4_3_FN,	GPSR4_3,
		GP_4_2_FN,	GPSR4_2,
		GP_4_1_FN,	GPSR4_1,
		GP_4_0_FN,	GPSR4_0, }
	},
	{ PINMUX_CFG_REG("GPSR5", 0xe6060114, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_5_14_FN,	GPSR5_14,
		GP_5_13_FN,	GPSR5_13,
		GP_5_12_FN,	GPSR5_12,
		GP_5_11_FN,	GPSR5_11,
		GP_5_10_FN,	GPSR5_10,
		GP_5_9_FN,	GPSR5_9,
		GP_5_8_FN,	GPSR5_8,
		GP_5_7_FN,	GPSR5_7,
		GP_5_6_FN,	GPSR5_6,
		GP_5_5_FN,	GPSR5_5,
		GP_5_4_FN,	GPSR5_4,
		GP_5_3_FN,	GPSR5_3,
		GP_5_2_FN,	GPSR5_2,
		GP_5_1_FN,	GPSR5_1,
		GP_5_0_FN,	GPSR5_0, }
	},
#undef F_
#undef FM

#define F_(x, y)	x,
#define FM(x)		FN_##x,
	{ PINMUX_CFG_REG("IPSR0", 0xe6060200, 32, 4) {
		IP0_31_28
		IP0_27_24
		IP0_23_20
		IP0_19_16
		IP0_15_12
		IP0_11_8
		IP0_7_4
		IP0_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR1", 0xe6060204, 32, 4) {
		IP1_31_28
		IP1_27_24
		IP1_23_20
		IP1_19_16
		IP1_15_12
		IP1_11_8
		IP1_7_4
		IP1_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR2", 0xe6060208, 32, 4) {
		IP2_31_28
		IP2_27_24
		IP2_23_20
		IP2_19_16
		IP2_15_12
		IP2_11_8
		IP2_7_4
		IP2_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR3", 0xe606020c, 32, 4) {
		IP3_31_28
		IP3_27_24
		IP3_23_20
		IP3_19_16
		IP3_15_12
		IP3_11_8
		IP3_7_4
		IP3_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR4", 0xe6060210, 32, 4) {
		IP4_31_28
		IP4_27_24
		IP4_23_20
		IP4_19_16
		IP4_15_12
		IP4_11_8
		IP4_7_4
		IP4_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR5", 0xe6060214, 32, 4) {
		IP5_31_28
		IP5_27_24
		IP5_23_20
		IP5_19_16
		IP5_15_12
		IP5_11_8
		IP5_7_4
		IP5_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR6", 0xe6060218, 32, 4) {
		IP6_31_28
		IP6_27_24
		IP6_23_20
		IP6_19_16
		IP6_15_12
		IP6_11_8
		IP6_7_4
		IP6_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR7", 0xe606021c, 32, 4) {
		IP7_31_28
		IP7_27_24
		IP7_23_20
		IP7_19_16
		IP7_15_12
		IP7_11_8
		IP7_7_4
		IP7_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR8", 0xe6060220, 32, 4) {
		IP8_31_28
		IP8_27_24
		IP8_23_20
		IP8_19_16
		IP8_15_12
		IP8_11_8
		IP8_7_4
		IP8_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR9", 0xe6060224, 32, 4) {
		IP9_31_28
		IP9_27_24
		IP9_23_20
		IP9_19_16
		IP9_15_12
		IP9_11_8
		IP9_7_4
		IP9_3_0 }
	},
	{ PINMUX_CFG_REG("IPSR10", 0xe6060228, 32, 4) {
		IP10_31_28
		IP10_27_24
		IP10_23_20
		IP10_19_16
		IP10_15_12
		IP10_11_8
		IP10_7_4
		IP10_3_0 }
	},
#undef F_
#undef FM

#define F_(x, y)	x,
#define FM(x)		FN_##x,
	{ PINMUX_CFG_REG_VAR("MOD_SEL0", 0xe6060500, 32,
			     4, 4, 4, 4, 4,
			     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1) {
		/* RESERVED 31, 30, 29, 28 */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* RESERVED 27, 26, 25, 24 */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* RESERVED 23, 22, 21, 20 */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* RESERVED 19, 18, 17, 16 */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		/* RESERVED 15, 14, 13, 12 */
		0, 0, 0, 0, 0, 0, 0, 0,	0, 0, 0, 0, 0, 0, 0, 0,
		MOD_SEL0_11
		MOD_SEL0_10
		MOD_SEL0_9
		MOD_SEL0_8
		MOD_SEL0_7
		MOD_SEL0_6
		MOD_SEL0_5
		MOD_SEL0_4
		0, 0,
		MOD_SEL0_2
		MOD_SEL0_1
		MOD_SEL0_0 }
	},
	{ },
};

enum ioctrl_regs {
	IOCTRL30,
	IOCTRL31,
	IOCTRL32,
	IOCTRL33,
};

static const struct pinmux_ioctrl_reg pinmux_ioctrl_regs[] = {
	[IOCTRL30] = { 0xe6060380, },
	[IOCTRL31] = { 0xe6060384, },
	[IOCTRL32] = { 0xe6060388, },
	[IOCTRL33] = { 0xe606038c, },
	{ /* sentinel */ },
};

static int r8a77980_pin_to_pocctrl(struct sh_pfc *pfc, unsigned int pin,
				   u32 *pocctrl)
{
	int bit = pin & 0x1f;

	*pocctrl = pinmux_ioctrl_regs[IOCTRL30].reg;
	if (pin >= RCAR_GP_PIN(0, 0) && pin <= RCAR_GP_PIN(0, 21))
		return bit;
	else if (pin >= RCAR_GP_PIN(2, 0) && pin <= RCAR_GP_PIN(2, 9))
		return bit + 22;

	*pocctrl = pinmux_ioctrl_regs[IOCTRL31].reg;
	if (pin >= RCAR_GP_PIN(2, 10) && pin <= RCAR_GP_PIN(2, 16))
		return bit - 10;
	if ((pin >= RCAR_GP_PIN(2, 17) && pin <= RCAR_GP_PIN(2, 24)) ||
	    (pin >= RCAR_GP_PIN(3,  0) && pin <= RCAR_GP_PIN(3, 16)))
		return bit + 7;

	*pocctrl = pinmux_ioctrl_regs[IOCTRL32].reg;
	if (pin >= RCAR_GP_PIN(2, 25) && pin <= RCAR_GP_PIN(2, 29))
		return pin - 25;

	return -EINVAL;
}

static const struct sh_pfc_soc_operations pinmux_ops = {
	.pin_to_pocctrl = r8a77980_pin_to_pocctrl,
};

const struct sh_pfc_soc_info r8a77980_pinmux_info = {
	.name = "r8a77980_pfc",
	.ops = &pinmux_ops,
	.unlock_reg = 0xe6060000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,
	.ioctrl_regs = pinmux_ioctrl_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
