/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (C) 2012-2018 ARM Limited or its affiliates. */

#ifndef __CC_HOST_H__
#define __CC_HOST_H__

// --------------------------------------
// BLOCK: HOST_P
// --------------------------------------
#define CC_HOST_IRR_REG_OFFSET	0xA00UL
#define CC_HOST_IRR_DSCRPTR_COMPLETION_LOW_INT_BIT_SHIFT	0x2UL
#define CC_HOST_IRR_DSCRPTR_COMPLETION_LOW_INT_BIT_SIZE	0x1UL
#define CC_HOST_IRR_AXI_ERR_INT_BIT_SHIFT	0x8UL
#define CC_HOST_IRR_AXI_ERR_INT_BIT_SIZE	0x1UL
#define CC_HOST_IRR_GPR0_BIT_SHIFT	0xBUL
#define CC_HOST_IRR_GPR0_BIT_SIZE	0x1UL
#define CC_HOST_IRR_DSCRPTR_WATERMARK_INT_BIT_SHIFT	0x13UL
#define CC_HOST_IRR_DSCRPTR_WATERMARK_INT_BIT_SIZE	0x1UL
#define CC_HOST_IRR_AXIM_COMP_INT_BIT_SHIFT	0x17UL
#define CC_HOST_IRR_AXIM_COMP_INT_BIT_SIZE	0x1UL
#define CC_HOST_IMR_REG_OFFSET	0xA04UL
#define CC_HOST_IMR_NOT_USED_MASK_BIT_SHIFT	0x1UL
#define CC_HOST_IMR_NOT_USED_MASK_BIT_SIZE	0x1UL
#define CC_HOST_IMR_DSCRPTR_COMPLETION_MASK_BIT_SHIFT	0x2UL
#define CC_HOST_IMR_DSCRPTR_COMPLETION_MASK_BIT_SIZE	0x1UL
#define CC_HOST_IMR_AXI_ERR_MASK_BIT_SHIFT	0x8UL
#define CC_HOST_IMR_AXI_ERR_MASK_BIT_SIZE	0x1UL
#define CC_HOST_IMR_GPR0_BIT_SHIFT	0xBUL
#define CC_HOST_IMR_GPR0_BIT_SIZE	0x1UL
#define CC_HOST_IMR_DSCRPTR_WATERMARK_MASK0_BIT_SHIFT	0x13UL
#define CC_HOST_IMR_DSCRPTR_WATERMARK_MASK0_BIT_SIZE	0x1UL
#define CC_HOST_IMR_AXIM_COMP_INT_MASK_BIT_SHIFT	0x17UL
#define CC_HOST_IMR_AXIM_COMP_INT_MASK_BIT_SIZE	0x1UL
#define CC_HOST_ICR_REG_OFFSET	0xA08UL
#define CC_HOST_ICR_DSCRPTR_COMPLETION_BIT_SHIFT	0x2UL
#define CC_HOST_ICR_DSCRPTR_COMPLETION_BIT_SIZE	0x1UL
#define CC_HOST_ICR_AXI_ERR_CLEAR_BIT_SHIFT	0x8UL
#define CC_HOST_ICR_AXI_ERR_CLEAR_BIT_SIZE	0x1UL
#define CC_HOST_ICR_GPR_INT_CLEAR_BIT_SHIFT	0xBUL
#define CC_HOST_ICR_GPR_INT_CLEAR_BIT_SIZE	0x1UL
#define CC_HOST_ICR_DSCRPTR_WATERMARK_QUEUE0_CLEAR_BIT_SHIFT	0x13UL
#define CC_HOST_ICR_DSCRPTR_WATERMARK_QUEUE0_CLEAR_BIT_SIZE	0x1UL
#define CC_HOST_ICR_AXIM_COMP_INT_CLEAR_BIT_SHIFT	0x17UL
#define CC_HOST_ICR_AXIM_COMP_INT_CLEAR_BIT_SIZE	0x1UL
#define CC_HOST_SIGNATURE_REG_OFFSET	0xA24UL
#define CC_HOST_SIGNATURE_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_SIGNATURE_VALUE_BIT_SIZE	0x20UL
#define CC_HOST_BOOT_REG_OFFSET	0xA28UL
#define CC_HOST_BOOT_SYNTHESIS_CONFIG_BIT_SHIFT	0x0UL
#define CC_HOST_BOOT_SYNTHESIS_CONFIG_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_LARGE_RKEK_LOCAL_BIT_SHIFT	0x1UL
#define CC_HOST_BOOT_LARGE_RKEK_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_HASH_IN_FUSES_LOCAL_BIT_SHIFT	0x2UL
#define CC_HOST_BOOT_HASH_IN_FUSES_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_EXT_MEM_SECURED_LOCAL_BIT_SHIFT	0x3UL
#define CC_HOST_BOOT_EXT_MEM_SECURED_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_RKEK_ECC_EXISTS_LOCAL_N_BIT_SHIFT	0x5UL
#define CC_HOST_BOOT_RKEK_ECC_EXISTS_LOCAL_N_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_SRAM_SIZE_LOCAL_BIT_SHIFT	0x6UL
#define CC_HOST_BOOT_SRAM_SIZE_LOCAL_BIT_SIZE	0x3UL
#define CC_HOST_BOOT_DSCRPTR_EXISTS_LOCAL_BIT_SHIFT	0x9UL
#define CC_HOST_BOOT_DSCRPTR_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_PAU_EXISTS_LOCAL_BIT_SHIFT	0xAUL
#define CC_HOST_BOOT_PAU_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_RNG_EXISTS_LOCAL_BIT_SHIFT	0xBUL
#define CC_HOST_BOOT_RNG_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_PKA_EXISTS_LOCAL_BIT_SHIFT	0xCUL
#define CC_HOST_BOOT_PKA_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_RC4_EXISTS_LOCAL_BIT_SHIFT	0xDUL
#define CC_HOST_BOOT_RC4_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_SHA_512_PRSNT_LOCAL_BIT_SHIFT	0xEUL
#define CC_HOST_BOOT_SHA_512_PRSNT_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_SHA_256_PRSNT_LOCAL_BIT_SHIFT	0xFUL
#define CC_HOST_BOOT_SHA_256_PRSNT_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_MD5_PRSNT_LOCAL_BIT_SHIFT	0x10UL
#define CC_HOST_BOOT_MD5_PRSNT_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_HASH_EXISTS_LOCAL_BIT_SHIFT	0x11UL
#define CC_HOST_BOOT_HASH_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_C2_EXISTS_LOCAL_BIT_SHIFT	0x12UL
#define CC_HOST_BOOT_C2_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_DES_EXISTS_LOCAL_BIT_SHIFT	0x13UL
#define CC_HOST_BOOT_DES_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_AES_XCBC_MAC_EXISTS_LOCAL_BIT_SHIFT	0x14UL
#define CC_HOST_BOOT_AES_XCBC_MAC_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_AES_CMAC_EXISTS_LOCAL_BIT_SHIFT	0x15UL
#define CC_HOST_BOOT_AES_CMAC_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_AES_CCM_EXISTS_LOCAL_BIT_SHIFT	0x16UL
#define CC_HOST_BOOT_AES_CCM_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_AES_XEX_HW_T_CALC_LOCAL_BIT_SHIFT	0x17UL
#define CC_HOST_BOOT_AES_XEX_HW_T_CALC_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_AES_XEX_EXISTS_LOCAL_BIT_SHIFT	0x18UL
#define CC_HOST_BOOT_AES_XEX_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_CTR_EXISTS_LOCAL_BIT_SHIFT	0x19UL
#define CC_HOST_BOOT_CTR_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_AES_DIN_BYTE_RESOLUTION_LOCAL_BIT_SHIFT	0x1AUL
#define CC_HOST_BOOT_AES_DIN_BYTE_RESOLUTION_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_TUNNELING_ENB_LOCAL_BIT_SHIFT	0x1BUL
#define CC_HOST_BOOT_TUNNELING_ENB_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_SUPPORT_256_192_KEY_LOCAL_BIT_SHIFT	0x1CUL
#define CC_HOST_BOOT_SUPPORT_256_192_KEY_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_ONLY_ENCRYPT_LOCAL_BIT_SHIFT	0x1DUL
#define CC_HOST_BOOT_ONLY_ENCRYPT_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_BOOT_AES_EXISTS_LOCAL_BIT_SHIFT	0x1EUL
#define CC_HOST_BOOT_AES_EXISTS_LOCAL_BIT_SIZE	0x1UL
#define CC_HOST_VERSION_REG_OFFSET	0xA40UL
#define CC_HOST_VERSION_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_VERSION_VALUE_BIT_SIZE	0x20UL
#define CC_HOST_KFDE0_VALID_REG_OFFSET	0xA60UL
#define CC_HOST_KFDE0_VALID_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_KFDE0_VALID_VALUE_BIT_SIZE	0x1UL
#define CC_HOST_KFDE1_VALID_REG_OFFSET	0xA64UL
#define CC_HOST_KFDE1_VALID_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_KFDE1_VALID_VALUE_BIT_SIZE	0x1UL
#define CC_HOST_KFDE2_VALID_REG_OFFSET	0xA68UL
#define CC_HOST_KFDE2_VALID_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_KFDE2_VALID_VALUE_BIT_SIZE	0x1UL
#define CC_HOST_KFDE3_VALID_REG_OFFSET	0xA6CUL
#define CC_HOST_KFDE3_VALID_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_KFDE3_VALID_VALUE_BIT_SIZE	0x1UL
#define CC_HOST_GPR0_REG_OFFSET	0xA70UL
#define CC_HOST_GPR0_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_GPR0_VALUE_BIT_SIZE	0x20UL
#define CC_GPR_HOST_REG_OFFSET	0xA74UL
#define CC_GPR_HOST_VALUE_BIT_SHIFT	0x0UL
#define CC_GPR_HOST_VALUE_BIT_SIZE	0x20UL
#define CC_HOST_POWER_DOWN_EN_REG_OFFSET	0xA78UL
#define CC_HOST_POWER_DOWN_EN_VALUE_BIT_SHIFT	0x0UL
#define CC_HOST_POWER_DOWN_EN_VALUE_BIT_SIZE	0x1UL
// --------------------------------------
// BLOCK: HOST_SRAM
// --------------------------------------
#define CC_SRAM_DATA_REG_OFFSET	0xF00UL
#define CC_SRAM_DATA_VALUE_BIT_SHIFT	0x0UL
#define CC_SRAM_DATA_VALUE_BIT_SIZE	0x20UL
#define CC_SRAM_ADDR_REG_OFFSET	0xF04UL
#define CC_SRAM_ADDR_VALUE_BIT_SHIFT	0x0UL
#define CC_SRAM_ADDR_VALUE_BIT_SIZE	0xFUL
#define CC_SRAM_DATA_READY_REG_OFFSET	0xF08UL
#define CC_SRAM_DATA_READY_VALUE_BIT_SHIFT	0x0UL
#define CC_SRAM_DATA_READY_VALUE_BIT_SIZE	0x1UL

#endif //__CC_HOST_H__
