/*  *********************************************************************
    *  BCM1280/BCM1480 Board Support Package
    *
    *  Memory Controller constants		File: bcm1480_mc.h
    *
    *  This module contains constants and macros useful for
    *  programming the memory controller.
    *
    *  BCM1400 specification level:  1280-UM100-D1 (11/14/03 Review Copy)
    *
    *********************************************************************
    *
    *  Copyright 2000,2001,2002,2003
    *  Broadcom Corporation. All rights reserved.
    *
    *  This program is free software; you can redistribute it and/or
    *  modify it under the terms of the GNU General Public License as
    *  published by the Free Software Foundation; either version 2 of
    *  the License, or (at your option) any later version.
    *
    *  This program is distributed in the hope that it will be useful,
    *  but WITHOUT ANY WARRANTY; without even the implied warranty of
    *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    *  GNU General Public License for more details.
    *
    *  You should have received a copy of the GNU General Public License
    *  along with this program; if not, write to the Free Software
    *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
    *  MA 02111-1307 USA
    ********************************************************************* */


#ifndef _BCM1480_MC_H
#define _BCM1480_MC_H

#include <asm/sibyte/sb1250_defs.h>

/*
 * Memory Channel Configuration Register (Table 81)
 */

#define S_BCM1480_MC_INTLV0		    0
#define M_BCM1480_MC_INTLV0		    _SB_MAKEMASK(6, S_BCM1480_MC_INTLV0)
#define V_BCM1480_MC_INTLV0(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_INTLV0)
#define G_BCM1480_MC_INTLV0(x)		    _SB_GETVALUE(x, S_BCM1480_MC_INTLV0, M_BCM1480_MC_INTLV0)
#define V_BCM1480_MC_INTLV0_DEFAULT	    V_BCM1480_MC_INTLV0(0)

#define S_BCM1480_MC_INTLV1		    8
#define M_BCM1480_MC_INTLV1		    _SB_MAKEMASK(6, S_BCM1480_MC_INTLV1)
#define V_BCM1480_MC_INTLV1(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_INTLV1)
#define G_BCM1480_MC_INTLV1(x)		    _SB_GETVALUE(x, S_BCM1480_MC_INTLV1, M_BCM1480_MC_INTLV1)
#define V_BCM1480_MC_INTLV1_DEFAULT	    V_BCM1480_MC_INTLV1(0)

#define S_BCM1480_MC_INTLV2		    16
#define M_BCM1480_MC_INTLV2		    _SB_MAKEMASK(6, S_BCM1480_MC_INTLV2)
#define V_BCM1480_MC_INTLV2(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_INTLV2)
#define G_BCM1480_MC_INTLV2(x)		    _SB_GETVALUE(x, S_BCM1480_MC_INTLV2, M_BCM1480_MC_INTLV2)
#define V_BCM1480_MC_INTLV2_DEFAULT	    V_BCM1480_MC_INTLV2(0)

#define S_BCM1480_MC_CS_MODE		    32
#define M_BCM1480_MC_CS_MODE		    _SB_MAKEMASK(8, S_BCM1480_MC_CS_MODE)
#define V_BCM1480_MC_CS_MODE(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_CS_MODE)
#define G_BCM1480_MC_CS_MODE(x)		    _SB_GETVALUE(x, S_BCM1480_MC_CS_MODE, M_BCM1480_MC_CS_MODE)
#define V_BCM1480_MC_CS_MODE_DEFAULT	    V_BCM1480_MC_CS_MODE(0)

#define V_BCM1480_MC_CONFIG_DEFAULT	    (V_BCM1480_MC_INTLV0_DEFAULT  | \
				     V_BCM1480_MC_INTLV1_DEFAULT  | \
				     V_BCM1480_MC_INTLV2_DEFAULT  | \
				     V_BCM1480_MC_CS_MODE_DEFAULT)

#define K_BCM1480_MC_CS01_MODE		    0x03
#define K_BCM1480_MC_CS02_MODE		    0x05
#define K_BCM1480_MC_CS0123_MODE	    0x0F
#define K_BCM1480_MC_CS0246_MODE	    0x55
#define K_BCM1480_MC_CS0145_MODE	    0x33
#define K_BCM1480_MC_CS0167_MODE	    0xC3
#define K_BCM1480_MC_CSFULL_MODE	    0xFF

/*
 * Chip Select Start Address Register (Table 82)
 */

#define S_BCM1480_MC_CS0_START		    0
#define M_BCM1480_MC_CS0_START		    _SB_MAKEMASK(12, S_BCM1480_MC_CS0_START)
#define V_BCM1480_MC_CS0_START(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS0_START)
#define G_BCM1480_MC_CS0_START(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS0_START, M_BCM1480_MC_CS0_START)

#define S_BCM1480_MC_CS1_START		    16
#define M_BCM1480_MC_CS1_START		    _SB_MAKEMASK(12, S_BCM1480_MC_CS1_START)
#define V_BCM1480_MC_CS1_START(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS1_START)
#define G_BCM1480_MC_CS1_START(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS1_START, M_BCM1480_MC_CS1_START)

#define S_BCM1480_MC_CS2_START		    32
#define M_BCM1480_MC_CS2_START		    _SB_MAKEMASK(12, S_BCM1480_MC_CS2_START)
#define V_BCM1480_MC_CS2_START(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS2_START)
#define G_BCM1480_MC_CS2_START(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS2_START, M_BCM1480_MC_CS2_START)

#define S_BCM1480_MC_CS3_START		    48
#define M_BCM1480_MC_CS3_START		    _SB_MAKEMASK(12, S_BCM1480_MC_CS3_START)
#define V_BCM1480_MC_CS3_START(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS3_START)
#define G_BCM1480_MC_CS3_START(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS3_START, M_BCM1480_MC_CS3_START)

/*
 * Chip Select End Address Register (Table 83)
 */

#define S_BCM1480_MC_CS0_END		    0
#define M_BCM1480_MC_CS0_END		    _SB_MAKEMASK(12, S_BCM1480_MC_CS0_END)
#define V_BCM1480_MC_CS0_END(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_CS0_END)
#define G_BCM1480_MC_CS0_END(x)		    _SB_GETVALUE(x, S_BCM1480_MC_CS0_END, M_BCM1480_MC_CS0_END)

#define S_BCM1480_MC_CS1_END		    16
#define M_BCM1480_MC_CS1_END		    _SB_MAKEMASK(12, S_BCM1480_MC_CS1_END)
#define V_BCM1480_MC_CS1_END(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_CS1_END)
#define G_BCM1480_MC_CS1_END(x)		    _SB_GETVALUE(x, S_BCM1480_MC_CS1_END, M_BCM1480_MC_CS1_END)

#define S_BCM1480_MC_CS2_END		    32
#define M_BCM1480_MC_CS2_END		    _SB_MAKEMASK(12, S_BCM1480_MC_CS2_END)
#define V_BCM1480_MC_CS2_END(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_CS2_END)
#define G_BCM1480_MC_CS2_END(x)		    _SB_GETVALUE(x, S_BCM1480_MC_CS2_END, M_BCM1480_MC_CS2_END)

#define S_BCM1480_MC_CS3_END		    48
#define M_BCM1480_MC_CS3_END		    _SB_MAKEMASK(12, S_BCM1480_MC_CS3_END)
#define V_BCM1480_MC_CS3_END(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_CS3_END)
#define G_BCM1480_MC_CS3_END(x)		    _SB_GETVALUE(x, S_BCM1480_MC_CS3_END, M_BCM1480_MC_CS3_END)

/*
 * Row Address Bit Select Register 0 (Table 84)
 */

#define S_BCM1480_MC_ROW00		    0
#define M_BCM1480_MC_ROW00		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW00)
#define V_BCM1480_MC_ROW00(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW00)
#define G_BCM1480_MC_ROW00(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW00, M_BCM1480_MC_ROW00)

#define S_BCM1480_MC_ROW01		    8
#define M_BCM1480_MC_ROW01		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW01)
#define V_BCM1480_MC_ROW01(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW01)
#define G_BCM1480_MC_ROW01(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW01, M_BCM1480_MC_ROW01)

#define S_BCM1480_MC_ROW02		    16
#define M_BCM1480_MC_ROW02		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW02)
#define V_BCM1480_MC_ROW02(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW02)
#define G_BCM1480_MC_ROW02(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW02, M_BCM1480_MC_ROW02)

#define S_BCM1480_MC_ROW03		    24
#define M_BCM1480_MC_ROW03		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW03)
#define V_BCM1480_MC_ROW03(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW03)
#define G_BCM1480_MC_ROW03(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW03, M_BCM1480_MC_ROW03)

#define S_BCM1480_MC_ROW04		    32
#define M_BCM1480_MC_ROW04		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW04)
#define V_BCM1480_MC_ROW04(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW04)
#define G_BCM1480_MC_ROW04(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW04, M_BCM1480_MC_ROW04)

#define S_BCM1480_MC_ROW05		    40
#define M_BCM1480_MC_ROW05		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW05)
#define V_BCM1480_MC_ROW05(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW05)
#define G_BCM1480_MC_ROW05(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW05, M_BCM1480_MC_ROW05)

#define S_BCM1480_MC_ROW06		    48
#define M_BCM1480_MC_ROW06		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW06)
#define V_BCM1480_MC_ROW06(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW06)
#define G_BCM1480_MC_ROW06(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW06, M_BCM1480_MC_ROW06)

#define S_BCM1480_MC_ROW07		    56
#define M_BCM1480_MC_ROW07		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW07)
#define V_BCM1480_MC_ROW07(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW07)
#define G_BCM1480_MC_ROW07(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW07, M_BCM1480_MC_ROW07)

/*
 * Row Address Bit Select Register 1 (Table 85)
 */

#define S_BCM1480_MC_ROW08		    0
#define M_BCM1480_MC_ROW08		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW08)
#define V_BCM1480_MC_ROW08(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW08)
#define G_BCM1480_MC_ROW08(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW08, M_BCM1480_MC_ROW08)

#define S_BCM1480_MC_ROW09		    8
#define M_BCM1480_MC_ROW09		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW09)
#define V_BCM1480_MC_ROW09(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW09)
#define G_BCM1480_MC_ROW09(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW09, M_BCM1480_MC_ROW09)

#define S_BCM1480_MC_ROW10		    16
#define M_BCM1480_MC_ROW10		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW10)
#define V_BCM1480_MC_ROW10(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW10)
#define G_BCM1480_MC_ROW10(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW10, M_BCM1480_MC_ROW10)

#define S_BCM1480_MC_ROW11		    24
#define M_BCM1480_MC_ROW11		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW11)
#define V_BCM1480_MC_ROW11(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW11)
#define G_BCM1480_MC_ROW11(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW11, M_BCM1480_MC_ROW11)

#define S_BCM1480_MC_ROW12		    32
#define M_BCM1480_MC_ROW12		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW12)
#define V_BCM1480_MC_ROW12(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW12)
#define G_BCM1480_MC_ROW12(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW12, M_BCM1480_MC_ROW12)

#define S_BCM1480_MC_ROW13		    40
#define M_BCM1480_MC_ROW13		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW13)
#define V_BCM1480_MC_ROW13(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW13)
#define G_BCM1480_MC_ROW13(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW13, M_BCM1480_MC_ROW13)

#define S_BCM1480_MC_ROW14		    48
#define M_BCM1480_MC_ROW14		    _SB_MAKEMASK(6, S_BCM1480_MC_ROW14)
#define V_BCM1480_MC_ROW14(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ROW14)
#define G_BCM1480_MC_ROW14(x)		    _SB_GETVALUE(x, S_BCM1480_MC_ROW14, M_BCM1480_MC_ROW14)

#define K_BCM1480_MC_ROWX_BIT_SPACING	    8

/*
 * Column Address Bit Select Register 0 (Table 86)
 */

#define S_BCM1480_MC_COL00		    0
#define M_BCM1480_MC_COL00		    _SB_MAKEMASK(6, S_BCM1480_MC_COL00)
#define V_BCM1480_MC_COL00(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL00)
#define G_BCM1480_MC_COL00(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL00, M_BCM1480_MC_COL00)

#define S_BCM1480_MC_COL01		    8
#define M_BCM1480_MC_COL01		    _SB_MAKEMASK(6, S_BCM1480_MC_COL01)
#define V_BCM1480_MC_COL01(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL01)
#define G_BCM1480_MC_COL01(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL01, M_BCM1480_MC_COL01)

#define S_BCM1480_MC_COL02		    16
#define M_BCM1480_MC_COL02		    _SB_MAKEMASK(6, S_BCM1480_MC_COL02)
#define V_BCM1480_MC_COL02(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL02)
#define G_BCM1480_MC_COL02(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL02, M_BCM1480_MC_COL02)

#define S_BCM1480_MC_COL03		    24
#define M_BCM1480_MC_COL03		    _SB_MAKEMASK(6, S_BCM1480_MC_COL03)
#define V_BCM1480_MC_COL03(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL03)
#define G_BCM1480_MC_COL03(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL03, M_BCM1480_MC_COL03)

#define S_BCM1480_MC_COL04		    32
#define M_BCM1480_MC_COL04		    _SB_MAKEMASK(6, S_BCM1480_MC_COL04)
#define V_BCM1480_MC_COL04(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL04)
#define G_BCM1480_MC_COL04(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL04, M_BCM1480_MC_COL04)

#define S_BCM1480_MC_COL05		    40
#define M_BCM1480_MC_COL05		    _SB_MAKEMASK(6, S_BCM1480_MC_COL05)
#define V_BCM1480_MC_COL05(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL05)
#define G_BCM1480_MC_COL05(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL05, M_BCM1480_MC_COL05)

#define S_BCM1480_MC_COL06		    48
#define M_BCM1480_MC_COL06		    _SB_MAKEMASK(6, S_BCM1480_MC_COL06)
#define V_BCM1480_MC_COL06(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL06)
#define G_BCM1480_MC_COL06(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL06, M_BCM1480_MC_COL06)

#define S_BCM1480_MC_COL07		    56
#define M_BCM1480_MC_COL07		    _SB_MAKEMASK(6, S_BCM1480_MC_COL07)
#define V_BCM1480_MC_COL07(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL07)
#define G_BCM1480_MC_COL07(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL07, M_BCM1480_MC_COL07)

/*
 * Column Address Bit Select Register 1 (Table 87)
 */

#define S_BCM1480_MC_COL08		    0
#define M_BCM1480_MC_COL08		    _SB_MAKEMASK(6, S_BCM1480_MC_COL08)
#define V_BCM1480_MC_COL08(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL08)
#define G_BCM1480_MC_COL08(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL08, M_BCM1480_MC_COL08)

#define S_BCM1480_MC_COL09		    8
#define M_BCM1480_MC_COL09		    _SB_MAKEMASK(6, S_BCM1480_MC_COL09)
#define V_BCM1480_MC_COL09(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL09)
#define G_BCM1480_MC_COL09(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL09, M_BCM1480_MC_COL09)

#define S_BCM1480_MC_COL10		    16	 /* not a valid position, must be prog as 0 */

#define S_BCM1480_MC_COL11		    24
#define M_BCM1480_MC_COL11		    _SB_MAKEMASK(6, S_BCM1480_MC_COL11)
#define V_BCM1480_MC_COL11(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL11)
#define G_BCM1480_MC_COL11(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL11, M_BCM1480_MC_COL11)

#define S_BCM1480_MC_COL12		    32
#define M_BCM1480_MC_COL12		    _SB_MAKEMASK(6, S_BCM1480_MC_COL12)
#define V_BCM1480_MC_COL12(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL12)
#define G_BCM1480_MC_COL12(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL12, M_BCM1480_MC_COL12)

#define S_BCM1480_MC_COL13		    40
#define M_BCM1480_MC_COL13		    _SB_MAKEMASK(6, S_BCM1480_MC_COL13)
#define V_BCM1480_MC_COL13(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL13)
#define G_BCM1480_MC_COL13(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL13, M_BCM1480_MC_COL13)

#define S_BCM1480_MC_COL14		    48
#define M_BCM1480_MC_COL14		    _SB_MAKEMASK(6, S_BCM1480_MC_COL14)
#define V_BCM1480_MC_COL14(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COL14)
#define G_BCM1480_MC_COL14(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COL14, M_BCM1480_MC_COL14)

#define K_BCM1480_MC_COLX_BIT_SPACING	    8

/*
 * CS0 and CS1 Bank Address Bit Select Register (Table 88)
 */

#define S_BCM1480_MC_CS01_BANK0		    0
#define M_BCM1480_MC_CS01_BANK0		    _SB_MAKEMASK(6, S_BCM1480_MC_CS01_BANK0)
#define V_BCM1480_MC_CS01_BANK0(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS01_BANK0)
#define G_BCM1480_MC_CS01_BANK0(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS01_BANK0, M_BCM1480_MC_CS01_BANK0)

#define S_BCM1480_MC_CS01_BANK1		    8
#define M_BCM1480_MC_CS01_BANK1		    _SB_MAKEMASK(6, S_BCM1480_MC_CS01_BANK1)
#define V_BCM1480_MC_CS01_BANK1(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS01_BANK1)
#define G_BCM1480_MC_CS01_BANK1(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS01_BANK1, M_BCM1480_MC_CS01_BANK1)

#define S_BCM1480_MC_CS01_BANK2		    16
#define M_BCM1480_MC_CS01_BANK2		    _SB_MAKEMASK(6, S_BCM1480_MC_CS01_BANK2)
#define V_BCM1480_MC_CS01_BANK2(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS01_BANK2)
#define G_BCM1480_MC_CS01_BANK2(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS01_BANK2, M_BCM1480_MC_CS01_BANK2)

/*
 * CS2 and CS3 Bank Address Bit Select Register (Table 89)
 */

#define S_BCM1480_MC_CS23_BANK0		    0
#define M_BCM1480_MC_CS23_BANK0		    _SB_MAKEMASK(6, S_BCM1480_MC_CS23_BANK0)
#define V_BCM1480_MC_CS23_BANK0(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS23_BANK0)
#define G_BCM1480_MC_CS23_BANK0(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS23_BANK0, M_BCM1480_MC_CS23_BANK0)

#define S_BCM1480_MC_CS23_BANK1		    8
#define M_BCM1480_MC_CS23_BANK1		    _SB_MAKEMASK(6, S_BCM1480_MC_CS23_BANK1)
#define V_BCM1480_MC_CS23_BANK1(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS23_BANK1)
#define G_BCM1480_MC_CS23_BANK1(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS23_BANK1, M_BCM1480_MC_CS23_BANK1)

#define S_BCM1480_MC_CS23_BANK2		    16
#define M_BCM1480_MC_CS23_BANK2		    _SB_MAKEMASK(6, S_BCM1480_MC_CS23_BANK2)
#define V_BCM1480_MC_CS23_BANK2(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CS23_BANK2)
#define G_BCM1480_MC_CS23_BANK2(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CS23_BANK2, M_BCM1480_MC_CS23_BANK2)

#define K_BCM1480_MC_CSXX_BANKX_BIT_SPACING  8

/*
 * DRAM Command Register (Table 90)
 */

#define S_BCM1480_MC_COMMAND		    0
#define M_BCM1480_MC_COMMAND		    _SB_MAKEMASK(4, S_BCM1480_MC_COMMAND)
#define V_BCM1480_MC_COMMAND(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_COMMAND)
#define G_BCM1480_MC_COMMAND(x)		    _SB_GETVALUE(x, S_BCM1480_MC_COMMAND, M_BCM1480_MC_COMMAND)

#define K_BCM1480_MC_COMMAND_EMRS	    0
#define K_BCM1480_MC_COMMAND_MRS	    1
#define K_BCM1480_MC_COMMAND_PRE	    2
#define K_BCM1480_MC_COMMAND_AR		    3
#define K_BCM1480_MC_COMMAND_SETRFSH	    4
#define K_BCM1480_MC_COMMAND_CLRRFSH	    5
#define K_BCM1480_MC_COMMAND_SETPWRDN	    6
#define K_BCM1480_MC_COMMAND_CLRPWRDN	    7

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define K_BCM1480_MC_COMMAND_EMRS2	    8
#define K_BCM1480_MC_COMMAND_EMRS3	    9
#define K_BCM1480_MC_COMMAND_ENABLE_MCLK    10
#define K_BCM1480_MC_COMMAND_DISABLE_MCLK   11
#endif

#define V_BCM1480_MC_COMMAND_EMRS	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_EMRS)
#define V_BCM1480_MC_COMMAND_MRS	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_MRS)
#define V_BCM1480_MC_COMMAND_PRE	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_PRE)
#define V_BCM1480_MC_COMMAND_AR		    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_AR)
#define V_BCM1480_MC_COMMAND_SETRFSH	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_SETRFSH)
#define V_BCM1480_MC_COMMAND_CLRRFSH	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_CLRRFSH)
#define V_BCM1480_MC_COMMAND_SETPWRDN	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_SETPWRDN)
#define V_BCM1480_MC_COMMAND_CLRPWRDN	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_CLRPWRDN)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define V_BCM1480_MC_COMMAND_EMRS2	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_EMRS2)
#define V_BCM1480_MC_COMMAND_EMRS3	    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_EMRS3)
#define V_BCM1480_MC_COMMAND_ENABLE_MCLK    V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_ENABLE_MCLK)
#define V_BCM1480_MC_COMMAND_DISABLE_MCLK   V_BCM1480_MC_COMMAND(K_BCM1480_MC_COMMAND_DISABLE_MCLK)
#endif

#define S_BCM1480_MC_CS0		    4
#define M_BCM1480_MC_CS0		    _SB_MAKEMASK1(4)
#define M_BCM1480_MC_CS1		    _SB_MAKEMASK1(5)
#define M_BCM1480_MC_CS2		    _SB_MAKEMASK1(6)
#define M_BCM1480_MC_CS3		    _SB_MAKEMASK1(7)
#define M_BCM1480_MC_CS4		    _SB_MAKEMASK1(8)
#define M_BCM1480_MC_CS5		    _SB_MAKEMASK1(9)
#define M_BCM1480_MC_CS6		    _SB_MAKEMASK1(10)
#define M_BCM1480_MC_CS7		    _SB_MAKEMASK1(11)

#define M_BCM1480_MC_CS			 _SB_MAKEMASK(8, S_BCM1480_MC_CS0)
#define V_BCM1480_MC_CS(x)		 _SB_MAKEVALUE(x, S_BCM1480_MC_CS0)
#define G_BCM1480_MC_CS(x)		 _SB_GETVALUE(x, S_BCM1480_MC_CS0, M_BCM1480_MC_CS0)

#define M_BCM1480_MC_CMD_ACTIVE		    _SB_MAKEMASK1(16)

/*
 * DRAM Mode Register (Table 91)
 */

#define S_BCM1480_MC_EMODE		    0
#define M_BCM1480_MC_EMODE		    _SB_MAKEMASK(15, S_BCM1480_MC_EMODE)
#define V_BCM1480_MC_EMODE(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_EMODE)
#define G_BCM1480_MC_EMODE(x)		    _SB_GETVALUE(x, S_BCM1480_MC_EMODE, M_BCM1480_MC_EMODE)
#define V_BCM1480_MC_EMODE_DEFAULT	    V_BCM1480_MC_EMODE(0)

#define S_BCM1480_MC_MODE		    16
#define M_BCM1480_MC_MODE		    _SB_MAKEMASK(15, S_BCM1480_MC_MODE)
#define V_BCM1480_MC_MODE(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_MODE)
#define G_BCM1480_MC_MODE(x)		    _SB_GETVALUE(x, S_BCM1480_MC_MODE, M_BCM1480_MC_MODE)
#define V_BCM1480_MC_MODE_DEFAULT	    V_BCM1480_MC_MODE(0)

#define S_BCM1480_MC_DRAM_TYPE		    32
#define M_BCM1480_MC_DRAM_TYPE		    _SB_MAKEMASK(4, S_BCM1480_MC_DRAM_TYPE)
#define V_BCM1480_MC_DRAM_TYPE(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_DRAM_TYPE)
#define G_BCM1480_MC_DRAM_TYPE(x)	    _SB_GETVALUE(x, S_BCM1480_MC_DRAM_TYPE, M_BCM1480_MC_DRAM_TYPE)

#define K_BCM1480_MC_DRAM_TYPE_JEDEC	    0
#define K_BCM1480_MC_DRAM_TYPE_FCRAM	    1

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define K_BCM1480_MC_DRAM_TYPE_DDR2	    2
#endif

#define K_BCM1480_MC_DRAM_TYPE_DDR2_PASS1   0

#define V_BCM1480_MC_DRAM_TYPE_JEDEC	    V_BCM1480_MC_DRAM_TYPE(K_BCM1480_MC_DRAM_TYPE_JEDEC)
#define V_BCM1480_MC_DRAM_TYPE_FCRAM	    V_BCM1480_MC_DRAM_TYPE(K_BCM1480_MC_DRAM_TYPE_FCRAM)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define V_BCM1480_MC_DRAM_TYPE_DDR2	    V_BCM1480_MC_DRAM_TYPE(K_BCM1480_MC_DRAM_TYPE_DDR2)
#endif

#define M_BCM1480_MC_GANGED		    _SB_MAKEMASK1(36)
#define M_BCM1480_MC_BY9_INTF		    _SB_MAKEMASK1(37)
#define M_BCM1480_MC_FORCE_ECC64	    _SB_MAKEMASK1(38)
#define M_BCM1480_MC_ECC_DISABLE	    _SB_MAKEMASK1(39)

#define S_BCM1480_MC_PG_POLICY		    40
#define M_BCM1480_MC_PG_POLICY		    _SB_MAKEMASK(2, S_BCM1480_MC_PG_POLICY)
#define V_BCM1480_MC_PG_POLICY(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_PG_POLICY)
#define G_BCM1480_MC_PG_POLICY(x)	    _SB_GETVALUE(x, S_BCM1480_MC_PG_POLICY, M_BCM1480_MC_PG_POLICY)

#define K_BCM1480_MC_PG_POLICY_CLOSED	    0
#define K_BCM1480_MC_PG_POLICY_CAS_TIME_CHK 1

#define V_BCM1480_MC_PG_POLICY_CLOSED	    V_BCM1480_MC_PG_POLICY(K_BCM1480_MC_PG_POLICY_CLOSED)
#define V_BCM1480_MC_PG_POLICY_CAS_TIME_CHK V_BCM1480_MC_PG_POLICY(K_BCM1480_MC_PG_POLICY_CAS_TIME_CHK)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define M_BCM1480_MC_2T_CMD		    _SB_MAKEMASK1(42)
#define M_BCM1480_MC_ECC_COR_DIS	    _SB_MAKEMASK1(43)
#endif

#define V_BCM1480_MC_DRAMMODE_DEFAULT	V_BCM1480_MC_EMODE_DEFAULT | V_BCM1480_MC_MODE_DEFAULT | V_BCM1480_MC_DRAM_TYPE_JEDEC | \
				V_BCM1480_MC_PG_POLICY(K_BCM1480_MC_PG_POLICY_CAS_TIME_CHK)

/*
 * Memory Clock Configuration Register (Table 92)
 */

#define S_BCM1480_MC_CLK_RATIO		    0
#define M_BCM1480_MC_CLK_RATIO		    _SB_MAKEMASK(6, S_BCM1480_MC_CLK_RATIO)
#define V_BCM1480_MC_CLK_RATIO(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CLK_RATIO)
#define G_BCM1480_MC_CLK_RATIO(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CLK_RATIO, M_BCM1480_MC_CLK_RATIO)

#define V_BCM1480_MC_CLK_RATIO_DEFAULT	    V_BCM1480_MC_CLK_RATIO(10)

#define S_BCM1480_MC_REF_RATE		    8
#define M_BCM1480_MC_REF_RATE		    _SB_MAKEMASK(8, S_BCM1480_MC_REF_RATE)
#define V_BCM1480_MC_REF_RATE(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_REF_RATE)
#define G_BCM1480_MC_REF_RATE(x)	    _SB_GETVALUE(x, S_BCM1480_MC_REF_RATE, M_BCM1480_MC_REF_RATE)

#define K_BCM1480_MC_REF_RATE_100MHz	    0x31
#define K_BCM1480_MC_REF_RATE_200MHz	    0x62
#define K_BCM1480_MC_REF_RATE_400MHz	    0xC4

#define V_BCM1480_MC_REF_RATE_100MHz	    V_BCM1480_MC_REF_RATE(K_BCM1480_MC_REF_RATE_100MHz)
#define V_BCM1480_MC_REF_RATE_200MHz	    V_BCM1480_MC_REF_RATE(K_BCM1480_MC_REF_RATE_200MHz)
#define V_BCM1480_MC_REF_RATE_400MHz	    V_BCM1480_MC_REF_RATE(K_BCM1480_MC_REF_RATE_400MHz)
#define V_BCM1480_MC_REF_RATE_DEFAULT	    V_BCM1480_MC_REF_RATE_400MHz

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define M_BCM1480_MC_AUTO_REF_DIS	    _SB_MAKEMASK1(16)
#endif

/*
 * ODT Register (Table 99)
 */

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define M_BCM1480_MC_RD_ODT0_CS0	    _SB_MAKEMASK1(0)
#define M_BCM1480_MC_RD_ODT0_CS2	    _SB_MAKEMASK1(1)
#define M_BCM1480_MC_RD_ODT0_CS4	    _SB_MAKEMASK1(2)
#define M_BCM1480_MC_RD_ODT0_CS6	    _SB_MAKEMASK1(3)
#define M_BCM1480_MC_WR_ODT0_CS0	    _SB_MAKEMASK1(4)
#define M_BCM1480_MC_WR_ODT0_CS2	    _SB_MAKEMASK1(5)
#define M_BCM1480_MC_WR_ODT0_CS4	    _SB_MAKEMASK1(6)
#define M_BCM1480_MC_WR_ODT0_CS6	    _SB_MAKEMASK1(7)
#define M_BCM1480_MC_RD_ODT2_CS0	    _SB_MAKEMASK1(8)
#define M_BCM1480_MC_RD_ODT2_CS2	    _SB_MAKEMASK1(9)
#define M_BCM1480_MC_RD_ODT2_CS4	    _SB_MAKEMASK1(10)
#define M_BCM1480_MC_RD_ODT2_CS6	    _SB_MAKEMASK1(11)
#define M_BCM1480_MC_WR_ODT2_CS0	    _SB_MAKEMASK1(12)
#define M_BCM1480_MC_WR_ODT2_CS2	    _SB_MAKEMASK1(13)
#define M_BCM1480_MC_WR_ODT2_CS4	    _SB_MAKEMASK1(14)
#define M_BCM1480_MC_WR_ODT2_CS6	    _SB_MAKEMASK1(15)
#define M_BCM1480_MC_RD_ODT4_CS0	    _SB_MAKEMASK1(16)
#define M_BCM1480_MC_RD_ODT4_CS2	    _SB_MAKEMASK1(17)
#define M_BCM1480_MC_RD_ODT4_CS4	    _SB_MAKEMASK1(18)
#define M_BCM1480_MC_RD_ODT4_CS6	    _SB_MAKEMASK1(19)
#define M_BCM1480_MC_WR_ODT4_CS0	    _SB_MAKEMASK1(20)
#define M_BCM1480_MC_WR_ODT4_CS2	    _SB_MAKEMASK1(21)
#define M_BCM1480_MC_WR_ODT4_CS4	    _SB_MAKEMASK1(22)
#define M_BCM1480_MC_WR_ODT4_CS6	    _SB_MAKEMASK1(23)
#define M_BCM1480_MC_RD_ODT6_CS0	    _SB_MAKEMASK1(24)
#define M_BCM1480_MC_RD_ODT6_CS2	    _SB_MAKEMASK1(25)
#define M_BCM1480_MC_RD_ODT6_CS4	    _SB_MAKEMASK1(26)
#define M_BCM1480_MC_RD_ODT6_CS6	    _SB_MAKEMASK1(27)
#define M_BCM1480_MC_WR_ODT6_CS0	    _SB_MAKEMASK1(28)
#define M_BCM1480_MC_WR_ODT6_CS2	    _SB_MAKEMASK1(29)
#define M_BCM1480_MC_WR_ODT6_CS4	    _SB_MAKEMASK1(30)
#define M_BCM1480_MC_WR_ODT6_CS6	    _SB_MAKEMASK1(31)

#define M_BCM1480_MC_CS_ODD_ODT_EN	    _SB_MAKEMASK1(32)

#define S_BCM1480_MC_ODT0		    0
#define M_BCM1480_MC_ODT0		    _SB_MAKEMASK(8, S_BCM1480_MC_ODT0)
#define V_BCM1480_MC_ODT0(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ODT0)

#define S_BCM1480_MC_ODT2		    8
#define M_BCM1480_MC_ODT2		    _SB_MAKEMASK(8, S_BCM1480_MC_ODT2)
#define V_BCM1480_MC_ODT2(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ODT2)

#define S_BCM1480_MC_ODT4		    16
#define M_BCM1480_MC_ODT4		    _SB_MAKEMASK(8, S_BCM1480_MC_ODT4)
#define V_BCM1480_MC_ODT4(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ODT4)

#define S_BCM1480_MC_ODT6		    24
#define M_BCM1480_MC_ODT6		    _SB_MAKEMASK(8, S_BCM1480_MC_ODT6)
#define V_BCM1480_MC_ODT6(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_ODT6)
#endif

/*
 * Memory DLL Configuration Register (Table 93)
 */

#define S_BCM1480_MC_ADDR_COARSE_ADJ	     0
#define M_BCM1480_MC_ADDR_COARSE_ADJ	     _SB_MAKEMASK(6, S_BCM1480_MC_ADDR_COARSE_ADJ)
#define V_BCM1480_MC_ADDR_COARSE_ADJ(x)	     _SB_MAKEVALUE(x, S_BCM1480_MC_ADDR_COARSE_ADJ)
#define G_BCM1480_MC_ADDR_COARSE_ADJ(x)	     _SB_GETVALUE(x, S_BCM1480_MC_ADDR_COARSE_ADJ, M_BCM1480_MC_ADDR_COARSE_ADJ)
#define V_BCM1480_MC_ADDR_COARSE_ADJ_DEFAULT V_BCM1480_MC_ADDR_COARSE_ADJ(0x0)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_ADDR_FREQ_RANGE		8
#define M_BCM1480_MC_ADDR_FREQ_RANGE		_SB_MAKEMASK(4, S_BCM1480_MC_ADDR_FREQ_RANGE)
#define V_BCM1480_MC_ADDR_FREQ_RANGE(x)		_SB_MAKEVALUE(x, S_BCM1480_MC_ADDR_FREQ_RANGE)
#define G_BCM1480_MC_ADDR_FREQ_RANGE(x)		_SB_GETVALUE(x, S_BCM1480_MC_ADDR_FREQ_RANGE, M_BCM1480_MC_ADDR_FREQ_RANGE)
#define V_BCM1480_MC_ADDR_FREQ_RANGE_DEFAULT	V_BCM1480_MC_ADDR_FREQ_RANGE(0x4)
#endif

#define S_BCM1480_MC_ADDR_FINE_ADJ	    8
#define M_BCM1480_MC_ADDR_FINE_ADJ	    _SB_MAKEMASK(4, S_BCM1480_MC_ADDR_FINE_ADJ)
#define V_BCM1480_MC_ADDR_FINE_ADJ(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_ADDR_FINE_ADJ)
#define G_BCM1480_MC_ADDR_FINE_ADJ(x)	    _SB_GETVALUE(x, S_BCM1480_MC_ADDR_FINE_ADJ, M_BCM1480_MC_ADDR_FINE_ADJ)
#define V_BCM1480_MC_ADDR_FINE_ADJ_DEFAULT  V_BCM1480_MC_ADDR_FINE_ADJ(0x8)

#define S_BCM1480_MC_DQI_COARSE_ADJ	    16
#define M_BCM1480_MC_DQI_COARSE_ADJ	    _SB_MAKEMASK(6, S_BCM1480_MC_DQI_COARSE_ADJ)
#define V_BCM1480_MC_DQI_COARSE_ADJ(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_DQI_COARSE_ADJ)
#define G_BCM1480_MC_DQI_COARSE_ADJ(x)	    _SB_GETVALUE(x, S_BCM1480_MC_DQI_COARSE_ADJ, M_BCM1480_MC_DQI_COARSE_ADJ)
#define V_BCM1480_MC_DQI_COARSE_ADJ_DEFAULT V_BCM1480_MC_DQI_COARSE_ADJ(0x0)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_DQI_FREQ_RANGE		24
#define M_BCM1480_MC_DQI_FREQ_RANGE		_SB_MAKEMASK(4, S_BCM1480_MC_DQI_FREQ_RANGE)
#define V_BCM1480_MC_DQI_FREQ_RANGE(x)		_SB_MAKEVALUE(x, S_BCM1480_MC_DQI_FREQ_RANGE)
#define G_BCM1480_MC_DQI_FREQ_RANGE(x)		_SB_GETVALUE(x, S_BCM1480_MC_DQI_FREQ_RANGE, M_BCM1480_MC_DQI_FREQ_RANGE)
#define V_BCM1480_MC_DQI_FREQ_RANGE_DEFAULT	V_BCM1480_MC_DQI_FREQ_RANGE(0x4)
#endif

#define S_BCM1480_MC_DQI_FINE_ADJ	    24
#define M_BCM1480_MC_DQI_FINE_ADJ	    _SB_MAKEMASK(4, S_BCM1480_MC_DQI_FINE_ADJ)
#define V_BCM1480_MC_DQI_FINE_ADJ(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_DQI_FINE_ADJ)
#define G_BCM1480_MC_DQI_FINE_ADJ(x)	    _SB_GETVALUE(x, S_BCM1480_MC_DQI_FINE_ADJ, M_BCM1480_MC_DQI_FINE_ADJ)
#define V_BCM1480_MC_DQI_FINE_ADJ_DEFAULT   V_BCM1480_MC_DQI_FINE_ADJ(0x8)

#define S_BCM1480_MC_DQO_COARSE_ADJ	    32
#define M_BCM1480_MC_DQO_COARSE_ADJ	    _SB_MAKEMASK(6, S_BCM1480_MC_DQO_COARSE_ADJ)
#define V_BCM1480_MC_DQO_COARSE_ADJ(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_DQO_COARSE_ADJ)
#define G_BCM1480_MC_DQO_COARSE_ADJ(x)	    _SB_GETVALUE(x, S_BCM1480_MC_DQO_COARSE_ADJ, M_BCM1480_MC_DQO_COARSE_ADJ)
#define V_BCM1480_MC_DQO_COARSE_ADJ_DEFAULT V_BCM1480_MC_DQO_COARSE_ADJ(0x0)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_DQO_FREQ_RANGE		40
#define M_BCM1480_MC_DQO_FREQ_RANGE		_SB_MAKEMASK(4, S_BCM1480_MC_DQO_FREQ_RANGE)
#define V_BCM1480_MC_DQO_FREQ_RANGE(x)		_SB_MAKEVALUE(x, S_BCM1480_MC_DQO_FREQ_RANGE)
#define G_BCM1480_MC_DQO_FREQ_RANGE(x)		_SB_GETVALUE(x, S_BCM1480_MC_DQO_FREQ_RANGE, M_BCM1480_MC_DQO_FREQ_RANGE)
#define V_BCM1480_MC_DQO_FREQ_RANGE_DEFAULT	V_BCM1480_MC_DQO_FREQ_RANGE(0x4)
#endif

#define S_BCM1480_MC_DQO_FINE_ADJ	    40
#define M_BCM1480_MC_DQO_FINE_ADJ	    _SB_MAKEMASK(4, S_BCM1480_MC_DQO_FINE_ADJ)
#define V_BCM1480_MC_DQO_FINE_ADJ(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_DQO_FINE_ADJ)
#define G_BCM1480_MC_DQO_FINE_ADJ(x)	    _SB_GETVALUE(x, S_BCM1480_MC_DQO_FINE_ADJ, M_BCM1480_MC_DQO_FINE_ADJ)
#define V_BCM1480_MC_DQO_FINE_ADJ_DEFAULT   V_BCM1480_MC_DQO_FINE_ADJ(0x8)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_DLL_PDSEL		  44
#define M_BCM1480_MC_DLL_PDSEL		  _SB_MAKEMASK(2, S_BCM1480_MC_DLL_PDSEL)
#define V_BCM1480_MC_DLL_PDSEL(x)	  _SB_MAKEVALUE(x, S_BCM1480_MC_DLL_PDSEL)
#define G_BCM1480_MC_DLL_PDSEL(x)	  _SB_GETVALUE(x, S_BCM1480_MC_DLL_PDSEL, M_BCM1480_MC_DLL_PDSEL)
#define V_BCM1480_MC_DLL_DEFAULT_PDSEL	  V_BCM1480_MC_DLL_PDSEL(0x0)

#define M_BCM1480_MC_DLL_REGBYPASS	  _SB_MAKEMASK1(46)
#define M_BCM1480_MC_DQO_SHIFT		  _SB_MAKEMASK1(47)
#endif

#define S_BCM1480_MC_DLL_DEFAULT	   48
#define M_BCM1480_MC_DLL_DEFAULT	   _SB_MAKEMASK(6, S_BCM1480_MC_DLL_DEFAULT)
#define V_BCM1480_MC_DLL_DEFAULT(x)	   _SB_MAKEVALUE(x, S_BCM1480_MC_DLL_DEFAULT)
#define G_BCM1480_MC_DLL_DEFAULT(x)	   _SB_GETVALUE(x, S_BCM1480_MC_DLL_DEFAULT, M_BCM1480_MC_DLL_DEFAULT)
#define V_BCM1480_MC_DLL_DEFAULT_DEFAULT   V_BCM1480_MC_DLL_DEFAULT(0x10)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_DLL_REGCTRL	  54
#define M_BCM1480_MC_DLL_REGCTRL	  _SB_MAKEMASK(2, S_BCM1480_MC_DLL_REGCTRL)
#define V_BCM1480_MC_DLL_REGCTRL(x)	  _SB_MAKEVALUE(x, S_BCM1480_MC_DLL_REGCTRL)
#define G_BCM1480_MC_DLL_REGCTRL(x)	  _SB_GETVALUE(x, S_BCM1480_MC_DLL_REGCTRL, M_BCM1480_MC_DLL_REGCTRL)
#define V_BCM1480_MC_DLL_DEFAULT_REGCTRL  V_BCM1480_MC_DLL_REGCTRL(0x0)
#endif

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_DLL_FREQ_RANGE		56
#define M_BCM1480_MC_DLL_FREQ_RANGE		_SB_MAKEMASK(4, S_BCM1480_MC_DLL_FREQ_RANGE)
#define V_BCM1480_MC_DLL_FREQ_RANGE(x)		_SB_MAKEVALUE(x, S_BCM1480_MC_DLL_FREQ_RANGE)
#define G_BCM1480_MC_DLL_FREQ_RANGE(x)		_SB_GETVALUE(x, S_BCM1480_MC_DLL_FREQ_RANGE, M_BCM1480_MC_DLL_FREQ_RANGE)
#define V_BCM1480_MC_DLL_FREQ_RANGE_DEFAULT	V_BCM1480_MC_DLL_FREQ_RANGE(0x4)
#endif

#define S_BCM1480_MC_DLL_STEP_SIZE	    56
#define M_BCM1480_MC_DLL_STEP_SIZE	    _SB_MAKEMASK(4, S_BCM1480_MC_DLL_STEP_SIZE)
#define V_BCM1480_MC_DLL_STEP_SIZE(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_DLL_STEP_SIZE)
#define G_BCM1480_MC_DLL_STEP_SIZE(x)	    _SB_GETVALUE(x, S_BCM1480_MC_DLL_STEP_SIZE, M_BCM1480_MC_DLL_STEP_SIZE)
#define V_BCM1480_MC_DLL_STEP_SIZE_DEFAULT  V_BCM1480_MC_DLL_STEP_SIZE(0x8)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_DLL_BGCTRL	  60
#define M_BCM1480_MC_DLL_BGCTRL		  _SB_MAKEMASK(2, S_BCM1480_MC_DLL_BGCTRL)
#define V_BCM1480_MC_DLL_BGCTRL(x)	 _SB_MAKEVALUE(x, S_BCM1480_MC_DLL_BGCTRL)
#define G_BCM1480_MC_DLL_BGCTRL(x)	 _SB_GETVALUE(x, S_BCM1480_MC_DLL_BGCTRL, M_BCM1480_MC_DLL_BGCTRL)
#define V_BCM1480_MC_DLL_DEFAULT_BGCTRL	 V_BCM1480_MC_DLL_BGCTRL(0x0)
#endif

#define M_BCM1480_MC_DLL_BYPASS		    _SB_MAKEMASK1(63)

/*
 * Memory Drive Configuration Register (Table 94)
 */

#define S_BCM1480_MC_RTT_BYP_PULLDOWN	    0
#define M_BCM1480_MC_RTT_BYP_PULLDOWN	    _SB_MAKEMASK(3, S_BCM1480_MC_RTT_BYP_PULLDOWN)
#define V_BCM1480_MC_RTT_BYP_PULLDOWN(x)    _SB_MAKEVALUE(x, S_BCM1480_MC_RTT_BYP_PULLDOWN)
#define G_BCM1480_MC_RTT_BYP_PULLDOWN(x)    _SB_GETVALUE(x, S_BCM1480_MC_RTT_BYP_PULLDOWN, M_BCM1480_MC_RTT_BYP_PULLDOWN)

#define S_BCM1480_MC_RTT_BYP_PULLUP	    6
#define M_BCM1480_MC_RTT_BYP_PULLUP	    _SB_MAKEMASK(3, S_BCM1480_MC_RTT_BYP_PULLUP)
#define V_BCM1480_MC_RTT_BYP_PULLUP(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_RTT_BYP_PULLUP)
#define G_BCM1480_MC_RTT_BYP_PULLUP(x)	    _SB_GETVALUE(x, S_BCM1480_MC_RTT_BYP_PULLUP, M_BCM1480_MC_RTT_BYP_PULLUP)

#define M_BCM1480_MC_RTT_BYPASS		    _SB_MAKEMASK1(8)
#define M_BCM1480_MC_RTT_COMP_MOV_AVG	    _SB_MAKEMASK1(9)

#define S_BCM1480_MC_PVT_BYP_C1_PULLDOWN    10
#define M_BCM1480_MC_PVT_BYP_C1_PULLDOWN    _SB_MAKEMASK(4, S_BCM1480_MC_PVT_BYP_C1_PULLDOWN)
#define V_BCM1480_MC_PVT_BYP_C1_PULLDOWN(x) _SB_MAKEVALUE(x, S_BCM1480_MC_PVT_BYP_C1_PULLDOWN)
#define G_BCM1480_MC_PVT_BYP_C1_PULLDOWN(x) _SB_GETVALUE(x, S_BCM1480_MC_PVT_BYP_C1_PULLDOWN, M_BCM1480_MC_PVT_BYP_C1_PULLDOWN)

#define S_BCM1480_MC_PVT_BYP_C1_PULLUP	    15
#define M_BCM1480_MC_PVT_BYP_C1_PULLUP	    _SB_MAKEMASK(4, S_BCM1480_MC_PVT_BYP_C1_PULLUP)
#define V_BCM1480_MC_PVT_BYP_C1_PULLUP(x)   _SB_MAKEVALUE(x, S_BCM1480_MC_PVT_BYP_C1_PULLUP)
#define G_BCM1480_MC_PVT_BYP_C1_PULLUP(x)   _SB_GETVALUE(x, S_BCM1480_MC_PVT_BYP_C1_PULLUP, M_BCM1480_MC_PVT_BYP_C1_PULLUP)

#define S_BCM1480_MC_PVT_BYP_C2_PULLDOWN    20
#define M_BCM1480_MC_PVT_BYP_C2_PULLDOWN    _SB_MAKEMASK(4, S_BCM1480_MC_PVT_BYP_C2_PULLDOWN)
#define V_BCM1480_MC_PVT_BYP_C2_PULLDOWN(x) _SB_MAKEVALUE(x, S_BCM1480_MC_PVT_BYP_C2_PULLDOWN)
#define G_BCM1480_MC_PVT_BYP_C2_PULLDOWN(x) _SB_GETVALUE(x, S_BCM1480_MC_PVT_BYP_C2_PULLDOWN, M_BCM1480_MC_PVT_BYP_C2_PULLDOWN)

#define S_BCM1480_MC_PVT_BYP_C2_PULLUP	    25
#define M_BCM1480_MC_PVT_BYP_C2_PULLUP	    _SB_MAKEMASK(4, S_BCM1480_MC_PVT_BYP_C2_PULLUP)
#define V_BCM1480_MC_PVT_BYP_C2_PULLUP(x)   _SB_MAKEVALUE(x, S_BCM1480_MC_PVT_BYP_C2_PULLUP)
#define G_BCM1480_MC_PVT_BYP_C2_PULLUP(x)   _SB_GETVALUE(x, S_BCM1480_MC_PVT_BYP_C2_PULLUP, M_BCM1480_MC_PVT_BYP_C2_PULLUP)

#define M_BCM1480_MC_PVT_BYPASS		    _SB_MAKEMASK1(30)
#define M_BCM1480_MC_PVT_COMP_MOV_AVG	    _SB_MAKEMASK1(31)

#define M_BCM1480_MC_CLK_CLASS		    _SB_MAKEMASK1(34)
#define M_BCM1480_MC_DATA_CLASS		    _SB_MAKEMASK1(35)
#define M_BCM1480_MC_ADDR_CLASS		    _SB_MAKEMASK1(36)

#define M_BCM1480_MC_DQ_ODT_75		    _SB_MAKEMASK1(37)
#define M_BCM1480_MC_DQ_ODT_150		    _SB_MAKEMASK1(38)
#define M_BCM1480_MC_DQS_ODT_75		    _SB_MAKEMASK1(39)
#define M_BCM1480_MC_DQS_ODT_150	    _SB_MAKEMASK1(40)
#define M_BCM1480_MC_DQS_DIFF		    _SB_MAKEMASK1(41)

/*
 * ECC Test Data Register (Table 95)
 */

#define S_BCM1480_MC_DATA_INVERT	    0
#define M_DATA_ECC_INVERT	    _SB_MAKEMASK(64, S_BCM1480_MC_ECC_INVERT)

/*
 * ECC Test ECC Register (Table 96)
 */

#define S_BCM1480_MC_ECC_INVERT		    0
#define M_BCM1480_MC_ECC_INVERT		    _SB_MAKEMASK(8, S_BCM1480_MC_ECC_INVERT)

/*
 * SDRAM Timing Register  (Table 97)
 */

#define S_BCM1480_MC_tRCD		    0
#define M_BCM1480_MC_tRCD		    _SB_MAKEMASK(4, S_BCM1480_MC_tRCD)
#define V_BCM1480_MC_tRCD(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRCD)
#define G_BCM1480_MC_tRCD(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRCD, M_BCM1480_MC_tRCD)
#define K_BCM1480_MC_tRCD_DEFAULT	    3
#define V_BCM1480_MC_tRCD_DEFAULT	    V_BCM1480_MC_tRCD(K_BCM1480_MC_tRCD_DEFAULT)

#define S_BCM1480_MC_tCL		    4
#define M_BCM1480_MC_tCL		    _SB_MAKEMASK(4, S_BCM1480_MC_tCL)
#define V_BCM1480_MC_tCL(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tCL)
#define G_BCM1480_MC_tCL(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tCL, M_BCM1480_MC_tCL)
#define K_BCM1480_MC_tCL_DEFAULT	    2
#define V_BCM1480_MC_tCL_DEFAULT	    V_BCM1480_MC_tCL(K_BCM1480_MC_tCL_DEFAULT)

#define M_BCM1480_MC_tCrDh		    _SB_MAKEMASK1(8)

#define S_BCM1480_MC_tWR		    9
#define M_BCM1480_MC_tWR		    _SB_MAKEMASK(3, S_BCM1480_MC_tWR)
#define V_BCM1480_MC_tWR(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tWR)
#define G_BCM1480_MC_tWR(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tWR, M_BCM1480_MC_tWR)
#define K_BCM1480_MC_tWR_DEFAULT	    2
#define V_BCM1480_MC_tWR_DEFAULT	    V_BCM1480_MC_tWR(K_BCM1480_MC_tWR_DEFAULT)

#define S_BCM1480_MC_tCwD		    12
#define M_BCM1480_MC_tCwD		    _SB_MAKEMASK(4, S_BCM1480_MC_tCwD)
#define V_BCM1480_MC_tCwD(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tCwD)
#define G_BCM1480_MC_tCwD(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tCwD, M_BCM1480_MC_tCwD)
#define K_BCM1480_MC_tCwD_DEFAULT	    1
#define V_BCM1480_MC_tCwD_DEFAULT	    V_BCM1480_MC_tCwD(K_BCM1480_MC_tCwD_DEFAULT)

#define S_BCM1480_MC_tRP		    16
#define M_BCM1480_MC_tRP		    _SB_MAKEMASK(4, S_BCM1480_MC_tRP)
#define V_BCM1480_MC_tRP(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRP)
#define G_BCM1480_MC_tRP(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRP, M_BCM1480_MC_tRP)
#define K_BCM1480_MC_tRP_DEFAULT	    4
#define V_BCM1480_MC_tRP_DEFAULT	    V_BCM1480_MC_tRP(K_BCM1480_MC_tRP_DEFAULT)

#define S_BCM1480_MC_tRRD		    20
#define M_BCM1480_MC_tRRD		    _SB_MAKEMASK(4, S_BCM1480_MC_tRRD)
#define V_BCM1480_MC_tRRD(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRRD)
#define G_BCM1480_MC_tRRD(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRRD, M_BCM1480_MC_tRRD)
#define K_BCM1480_MC_tRRD_DEFAULT	    2
#define V_BCM1480_MC_tRRD_DEFAULT	    V_BCM1480_MC_tRRD(K_BCM1480_MC_tRRD_DEFAULT)

#define S_BCM1480_MC_tRCw		    24
#define M_BCM1480_MC_tRCw		    _SB_MAKEMASK(5, S_BCM1480_MC_tRCw)
#define V_BCM1480_MC_tRCw(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRCw)
#define G_BCM1480_MC_tRCw(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRCw, M_BCM1480_MC_tRCw)
#define K_BCM1480_MC_tRCw_DEFAULT	    10
#define V_BCM1480_MC_tRCw_DEFAULT	    V_BCM1480_MC_tRCw(K_BCM1480_MC_tRCw_DEFAULT)

#define S_BCM1480_MC_tRCr		    32
#define M_BCM1480_MC_tRCr		    _SB_MAKEMASK(5, S_BCM1480_MC_tRCr)
#define V_BCM1480_MC_tRCr(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRCr)
#define G_BCM1480_MC_tRCr(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRCr, M_BCM1480_MC_tRCr)
#define K_BCM1480_MC_tRCr_DEFAULT	    9
#define V_BCM1480_MC_tRCr_DEFAULT	    V_BCM1480_MC_tRCr(K_BCM1480_MC_tRCr_DEFAULT)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define S_BCM1480_MC_tFAW		    40
#define M_BCM1480_MC_tFAW		    _SB_MAKEMASK(6, S_BCM1480_MC_tFAW)
#define V_BCM1480_MC_tFAW(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tFAW)
#define G_BCM1480_MC_tFAW(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tFAW, M_BCM1480_MC_tFAW)
#define K_BCM1480_MC_tFAW_DEFAULT	    0
#define V_BCM1480_MC_tFAW_DEFAULT	    V_BCM1480_MC_tFAW(K_BCM1480_MC_tFAW_DEFAULT)
#endif

#define S_BCM1480_MC_tRFC		    48
#define M_BCM1480_MC_tRFC		    _SB_MAKEMASK(7, S_BCM1480_MC_tRFC)
#define V_BCM1480_MC_tRFC(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRFC)
#define G_BCM1480_MC_tRFC(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRFC, M_BCM1480_MC_tRFC)
#define K_BCM1480_MC_tRFC_DEFAULT	    12
#define V_BCM1480_MC_tRFC_DEFAULT	    V_BCM1480_MC_tRFC(K_BCM1480_MC_tRFC_DEFAULT)

#define S_BCM1480_MC_tFIFO		    56
#define M_BCM1480_MC_tFIFO		    _SB_MAKEMASK(2, S_BCM1480_MC_tFIFO)
#define V_BCM1480_MC_tFIFO(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tFIFO)
#define G_BCM1480_MC_tFIFO(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tFIFO, M_BCM1480_MC_tFIFO)
#define K_BCM1480_MC_tFIFO_DEFAULT	    0
#define V_BCM1480_MC_tFIFO_DEFAULT	    V_BCM1480_MC_tFIFO(K_BCM1480_MC_tFIFO_DEFAULT)

#define S_BCM1480_MC_tW2R		   58
#define M_BCM1480_MC_tW2R		   _SB_MAKEMASK(2, S_BCM1480_MC_tW2R)
#define V_BCM1480_MC_tW2R(x)		   _SB_MAKEVALUE(x, S_BCM1480_MC_tW2R)
#define G_BCM1480_MC_tW2R(x)		   _SB_GETVALUE(x, S_BCM1480_MC_tW2R, M_BCM1480_MC_tW2R)
#define K_BCM1480_MC_tW2R_DEFAULT	   1
#define V_BCM1480_MC_tW2R_DEFAULT	   V_BCM1480_MC_tW2R(K_BCM1480_MC_tW2R_DEFAULT)

#define S_BCM1480_MC_tR2W		   60
#define M_BCM1480_MC_tR2W		   _SB_MAKEMASK(2, S_BCM1480_MC_tR2W)
#define V_BCM1480_MC_tR2W(x)		   _SB_MAKEVALUE(x, S_BCM1480_MC_tR2W)
#define G_BCM1480_MC_tR2W(x)		   _SB_GETVALUE(x, S_BCM1480_MC_tR2W, M_BCM1480_MC_tR2W)
#define K_BCM1480_MC_tR2W_DEFAULT	   0
#define V_BCM1480_MC_tR2W_DEFAULT	   V_BCM1480_MC_tR2W(K_BCM1480_MC_tR2W_DEFAULT)

#define M_BCM1480_MC_tR2R		    _SB_MAKEMASK1(62)

#define V_BCM1480_MC_TIMING_DEFAULT	    (M_BCM1480_MC_tR2R | \
				     V_BCM1480_MC_tFIFO_DEFAULT | \
				     V_BCM1480_MC_tR2W_DEFAULT | \
				     V_BCM1480_MC_tW2R_DEFAULT | \
				     V_BCM1480_MC_tRFC_DEFAULT | \
				     V_BCM1480_MC_tRCr_DEFAULT | \
				     V_BCM1480_MC_tRCw_DEFAULT | \
				     V_BCM1480_MC_tRRD_DEFAULT | \
				     V_BCM1480_MC_tRP_DEFAULT | \
				     V_BCM1480_MC_tCwD_DEFAULT | \
				     V_BCM1480_MC_tWR_DEFAULT | \
				     M_BCM1480_MC_tCrDh | \
				     V_BCM1480_MC_tCL_DEFAULT | \
				     V_BCM1480_MC_tRCD_DEFAULT)

/*
 * SDRAM Timing Register 2
 */

#if SIBYTE_HDR_FEATURE(1480, PASS2)

#define S_BCM1480_MC_tAL		   0
#define M_BCM1480_MC_tAL		   _SB_MAKEMASK(4, S_BCM1480_MC_tAL)
#define V_BCM1480_MC_tAL(x)		   _SB_MAKEVALUE(x, S_BCM1480_MC_tAL)
#define G_BCM1480_MC_tAL(x)		   _SB_GETVALUE(x, S_BCM1480_MC_tAL, M_BCM1480_MC_tAL)
#define K_BCM1480_MC_tAL_DEFAULT	   0
#define V_BCM1480_MC_tAL_DEFAULT	   V_BCM1480_MC_tAL(K_BCM1480_MC_tAL_DEFAULT)

#define S_BCM1480_MC_tRTP		    4
#define M_BCM1480_MC_tRTP		    _SB_MAKEMASK(3, S_BCM1480_MC_tRTP)
#define V_BCM1480_MC_tRTP(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRTP)
#define G_BCM1480_MC_tRTP(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRTP, M_BCM1480_MC_tRTP)
#define K_BCM1480_MC_tRTP_DEFAULT	    2
#define V_BCM1480_MC_tRTP_DEFAULT	    V_BCM1480_MC_tRTP(K_BCM1480_MC_tRTP_DEFAULT)

#define S_BCM1480_MC_tW2W		    8
#define M_BCM1480_MC_tW2W		    _SB_MAKEMASK(2, S_BCM1480_MC_tW2W)
#define V_BCM1480_MC_tW2W(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tW2W)
#define G_BCM1480_MC_tW2W(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tW2W, M_BCM1480_MC_tW2W)
#define K_BCM1480_MC_tW2W_DEFAULT	    0
#define V_BCM1480_MC_tW2W_DEFAULT	    V_BCM1480_MC_tW2W(K_BCM1480_MC_tW2W_DEFAULT)

#define S_BCM1480_MC_tRAP		    12
#define M_BCM1480_MC_tRAP		   _SB_MAKEMASK(4, S_BCM1480_MC_tRAP)
#define V_BCM1480_MC_tRAP(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_tRAP)
#define G_BCM1480_MC_tRAP(x)		    _SB_GETVALUE(x, S_BCM1480_MC_tRAP, M_BCM1480_MC_tRAP)
#define K_BCM1480_MC_tRAP_DEFAULT	    0
#define V_BCM1480_MC_tRAP_DEFAULT	    V_BCM1480_MC_tRAP(K_BCM1480_MC_tRAP_DEFAULT)

#endif



/*
 * Global Registers: single instances per BCM1480
 */

/*
 * Global Configuration Register (Table 99)
 */

#define S_BCM1480_MC_BLK_SET_MARK	    8
#define M_BCM1480_MC_BLK_SET_MARK	    _SB_MAKEMASK(4, S_BCM1480_MC_BLK_SET_MARK)
#define V_BCM1480_MC_BLK_SET_MARK(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_BLK_SET_MARK)
#define G_BCM1480_MC_BLK_SET_MARK(x)	    _SB_GETVALUE(x, S_BCM1480_MC_BLK_SET_MARK, M_BCM1480_MC_BLK_SET_MARK)

#define S_BCM1480_MC_BLK_CLR_MARK	    12
#define M_BCM1480_MC_BLK_CLR_MARK	    _SB_MAKEMASK(4, S_BCM1480_MC_BLK_CLR_MARK)
#define V_BCM1480_MC_BLK_CLR_MARK(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_BLK_CLR_MARK)
#define G_BCM1480_MC_BLK_CLR_MARK(x)	    _SB_GETVALUE(x, S_BCM1480_MC_BLK_CLR_MARK, M_BCM1480_MC_BLK_CLR_MARK)

#define M_BCM1480_MC_PKT_PRIORITY	    _SB_MAKEMASK1(16)

#define S_BCM1480_MC_MAX_AGE		    20
#define M_BCM1480_MC_MAX_AGE		    _SB_MAKEMASK(4, S_BCM1480_MC_MAX_AGE)
#define V_BCM1480_MC_MAX_AGE(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_MAX_AGE)
#define G_BCM1480_MC_MAX_AGE(x)		    _SB_GETVALUE(x, S_BCM1480_MC_MAX_AGE, M_BCM1480_MC_MAX_AGE)

#define M_BCM1480_MC_BERR_DISABLE	    _SB_MAKEMASK1(29)
#define M_BCM1480_MC_FORCE_SEQ		    _SB_MAKEMASK1(30)
#define M_BCM1480_MC_VGEN		    _SB_MAKEMASK1(32)

#define S_BCM1480_MC_SLEW		    33
#define M_BCM1480_MC_SLEW		    _SB_MAKEMASK(2, S_BCM1480_MC_SLEW)
#define V_BCM1480_MC_SLEW(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_SLEW)
#define G_BCM1480_MC_SLEW(x)		    _SB_GETVALUE(x, S_BCM1480_MC_SLEW, M_BCM1480_MC_SLEW)

#define M_BCM1480_MC_SSTL_VOLTAGE	    _SB_MAKEMASK1(35)

/*
 * Global Channel Interleave Register (Table 100)
 */

#define S_BCM1480_MC_INTLV0		    0
#define M_BCM1480_MC_INTLV0		    _SB_MAKEMASK(6, S_BCM1480_MC_INTLV0)
#define V_BCM1480_MC_INTLV0(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_INTLV0)
#define G_BCM1480_MC_INTLV0(x)		    _SB_GETVALUE(x, S_BCM1480_MC_INTLV0, M_BCM1480_MC_INTLV0)

#define S_BCM1480_MC_INTLV1		    8
#define M_BCM1480_MC_INTLV1		    _SB_MAKEMASK(6, S_BCM1480_MC_INTLV1)
#define V_BCM1480_MC_INTLV1(x)		    _SB_MAKEVALUE(x, S_BCM1480_MC_INTLV1)
#define G_BCM1480_MC_INTLV1(x)		    _SB_GETVALUE(x, S_BCM1480_MC_INTLV1, M_BCM1480_MC_INTLV1)

#define S_BCM1480_MC_INTLV_MODE		    16
#define M_BCM1480_MC_INTLV_MODE		    _SB_MAKEMASK(3, S_BCM1480_MC_INTLV_MODE)
#define V_BCM1480_MC_INTLV_MODE(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_INTLV_MODE)
#define G_BCM1480_MC_INTLV_MODE(x)	    _SB_GETVALUE(x, S_BCM1480_MC_INTLV_MODE, M_BCM1480_MC_INTLV_MODE)

#define K_BCM1480_MC_INTLV_MODE_NONE	    0x0
#define K_BCM1480_MC_INTLV_MODE_01	    0x1
#define K_BCM1480_MC_INTLV_MODE_23	    0x2
#define K_BCM1480_MC_INTLV_MODE_01_23	    0x3
#define K_BCM1480_MC_INTLV_MODE_0123	    0x4

#define V_BCM1480_MC_INTLV_MODE_NONE	    V_BCM1480_MC_INTLV_MODE(K_BCM1480_MC_INTLV_MODE_NONE)
#define V_BCM1480_MC_INTLV_MODE_01	    V_BCM1480_MC_INTLV_MODE(K_BCM1480_MC_INTLV_MODE_01)
#define V_BCM1480_MC_INTLV_MODE_23	    V_BCM1480_MC_INTLV_MODE(K_BCM1480_MC_INTLV_MODE_23)
#define V_BCM1480_MC_INTLV_MODE_01_23	    V_BCM1480_MC_INTLV_MODE(K_BCM1480_MC_INTLV_MODE_01_23)
#define V_BCM1480_MC_INTLV_MODE_0123	    V_BCM1480_MC_INTLV_MODE(K_BCM1480_MC_INTLV_MODE_0123)

/*
 * ECC Status Register
 */

#define S_BCM1480_MC_ECC_ERR_ADDR	    0
#define M_BCM1480_MC_ECC_ERR_ADDR	    _SB_MAKEMASK(37, S_BCM1480_MC_ECC_ERR_ADDR)
#define V_BCM1480_MC_ECC_ERR_ADDR(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_ECC_ERR_ADDR)
#define G_BCM1480_MC_ECC_ERR_ADDR(x)	    _SB_GETVALUE(x, S_BCM1480_MC_ECC_ERR_ADDR, M_BCM1480_MC_ECC_ERR_ADDR)

#if SIBYTE_HDR_FEATURE(1480, PASS2)
#define M_BCM1480_MC_ECC_ERR_RMW	    _SB_MAKEMASK1(60)
#endif

#define M_BCM1480_MC_ECC_MULT_ERR_DET	    _SB_MAKEMASK1(61)
#define M_BCM1480_MC_ECC_UERR_DET	    _SB_MAKEMASK1(62)
#define M_BCM1480_MC_ECC_CERR_DET	    _SB_MAKEMASK1(63)

/*
 * Global ECC Address Register (Table 102)
 */

#define S_BCM1480_MC_ECC_CORR_ADDR	    0
#define M_BCM1480_MC_ECC_CORR_ADDR	    _SB_MAKEMASK(37, S_BCM1480_MC_ECC_CORR_ADDR)
#define V_BCM1480_MC_ECC_CORR_ADDR(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_ECC_CORR_ADDR)
#define G_BCM1480_MC_ECC_CORR_ADDR(x)	    _SB_GETVALUE(x, S_BCM1480_MC_ECC_CORR_ADDR, M_BCM1480_MC_ECC_CORR_ADDR)

/*
 * Global ECC Correction Register (Table 103)
 */

#define S_BCM1480_MC_ECC_CORRECT	    0
#define M_BCM1480_MC_ECC_CORRECT	    _SB_MAKEMASK(64, S_BCM1480_MC_ECC_CORRECT)
#define V_BCM1480_MC_ECC_CORRECT(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_ECC_CORRECT)
#define G_BCM1480_MC_ECC_CORRECT(x)	    _SB_GETVALUE(x, S_BCM1480_MC_ECC_CORRECT, M_BCM1480_MC_ECC_CORRECT)

/*
 * Global ECC Performance Counters Control Register (Table 104)
 */

#define S_BCM1480_MC_CHANNEL_SELECT	    0
#define M_BCM1480_MC_CHANNEL_SELECT	    _SB_MAKEMASK(4, S_BCM1480_MC_CHANNEL_SELECT)
#define V_BCM1480_MC_CHANNEL_SELECT(x)	    _SB_MAKEVALUE(x, S_BCM1480_MC_CHANNEL_SELECT)
#define G_BCM1480_MC_CHANNEL_SELECT(x)	    _SB_GETVALUE(x, S_BCM1480_MC_CHANNEL_SELECT, M_BCM1480_MC_CHANNEL_SELECT)
#define K_BCM1480_MC_CHANNEL_SELECT_0	    0x1
#define K_BCM1480_MC_CHANNEL_SELECT_1	    0x2
#define K_BCM1480_MC_CHANNEL_SELECT_2	    0x4
#define K_BCM1480_MC_CHANNEL_SELECT_3	    0x8

#endif /* _BCM1480_MC_H */
