/*
 * SAPIC Interrupt Controller
 *
 * This takes care of interrupts that are generated by the CPU's
 * internal Streamlined Advanced Programmable Interrupt Controller
 * (SAPIC), such as the ITC and IPI interrupts.
 *
 * Copyright (C) 1999 VA Linux Systems
 * Copyright (C) 1999 Walt Drummond <drummond@valinux.com>
 * Copyright (C) 2000 Hewlett-Packard Co
 * Copyright (C) 2000 David Mosberger-Tang <davidm@hpl.hp.com>
 */

#include <linux/sched.h>
#include <linux/irq.h>

static unsigned int
sapic_noop_startup (unsigned int irq)
{
	return 0;
}

static void
sapic_noop (unsigned int irq)
{
	/* nuthing to do... */
}

struct hw_interrupt_type irq_type_ia64_sapic = {
	typename:	"SAPIC",
	startup:	sapic_noop_startup,
	shutdown:	sapic_noop,
	enable:		sapic_noop,
	disable:	sapic_noop,
	ack:		sapic_noop,
	end:		sapic_noop,
	set_affinity:	(void (*)(unsigned int, unsigned long)) sapic_noop
};
